/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.layouters;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeSet;
import org.openjdk.jol.datamodel.DataModel;
import org.openjdk.jol.info.ClassData;
import org.openjdk.jol.info.ClassLayout;
import org.openjdk.jol.info.FieldData;
import org.openjdk.jol.info.FieldLayout;
import org.openjdk.jol.layouters.FieldAllocationType;
import org.openjdk.jol.layouters.Layouter;
import org.openjdk.jol.util.MathUtil;

public class HotSpotLayouter
implements Layouter {
    private static Set<String> PREDEF_OFFSETS = new HashSet<String>(Arrays.asList("java.lang.AssertionStatusDirectives", "java.lang.Class", "java.lang.ClassLoader", "java.lang.ref.Reference", "java.lang.ref.SoftReference", "java.lang.StackTraceElement", "java.lang.String", "java.lang.Throwable", "java.lang.Boolean", "java.lang.Character", "java.lang.Float", "java.lang.Double", "java.lang.Byte", "java.lang.Short", "java.lang.Integer", "java.lang.Long"));
    static final int CONTENDED_PADDING_WIDTH = Integer.getInteger("contendedPaddingWidth", 128);
    static final int DEFAULT_FIELD_ALLOCATION_STYLE = Integer.getInteger("fieldAllocationStyle", 1);
    private final DataModel model;
    private final boolean takeHierarchyGaps;
    private final boolean takeSuperGaps;
    private final boolean autoAlign;
    private final boolean compactFields;
    private final int fieldAllocationStyle;

    public HotSpotLayouter(DataModel model) {
        this(model, false, false, false, true, DEFAULT_FIELD_ALLOCATION_STYLE);
    }

    public HotSpotLayouter(DataModel model, boolean takeHierarchyGaps, boolean takeSuperGaps, boolean autoAlign, boolean compactFields, int fieldAllocationStyle) {
        this.model = model;
        this.takeHierarchyGaps = takeHierarchyGaps;
        this.takeSuperGaps = takeSuperGaps;
        this.autoAlign = autoAlign;
        this.compactFields = compactFields;
        this.fieldAllocationStyle = fieldAllocationStyle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ClassLayout layout(ClassData cd) {
        TreeSet<FieldLayout> result = new TreeSet<FieldLayout>();
        if (cd.isArray()) {
            int base = this.model.arrayHeaderSize();
            int scale = this.model.sizeOf(cd.arrayComponentType());
            long instanceSize = (long)base + cd.arrayLength() * (long)scale;
            instanceSize = MathUtil.align(instanceSize, this.model.objectAlignment());
            base = MathUtil.align(base, Math.max(4, scale));
            result.add(new FieldLayout(FieldData.create(cd.arrayClass(), "<elements>", cd.arrayComponentType()), base, (long)scale * cd.arrayLength()));
            return new ClassLayout(cd, result, this.model.arrayHeaderSize(), instanceSize, false);
        }
        ArrayList<ClassData> classDataClassHierarchy = new ArrayList<ClassData>();
        ClassData cld = cd;
        classDataClassHierarchy.add(cld);
        while ((cld = cld.superClass()) != null) {
            classDataClassHierarchy.add(0, cld);
        }
        int superClassLastOopOffset = 0;
        int superClassFieldsSize = 0;
        int nextPaddedOffset = 0;
        ArrayList<Integer> superGapsOffsets = new ArrayList<Integer>();
        ArrayList<Integer> superGapsSizes = new ArrayList<Integer>();
        for (ClassData classData : classDataClassHierarchy) {
            int allocationStyle;
            boolean compactFields;
            int firstOopOffset;
            int oopCount;
            int byteCount;
            int shortCount;
            int wordCount;
            int doubleCount;
            boolean isContendedClass;
            int contendedCount;
            EnumMap<FieldAllocationType, Integer> allocationTypeSizes;
            EnumMap spaceOffset;
            EnumMap<FieldAllocationType, Integer> nextOffset;
            block47: {
                int fieldsStart;
                EnumMap<FieldAllocationType, Integer> fieldsAllocationCount = new EnumMap<FieldAllocationType, Integer>(FieldAllocationType.class);
                nextOffset = new EnumMap<FieldAllocationType, Integer>(FieldAllocationType.class);
                spaceOffset = new EnumMap(FieldAllocationType.class);
                allocationTypeSizes = new EnumMap<FieldAllocationType, Integer>(FieldAllocationType.class);
                for (FieldAllocationType atype : FieldAllocationType.values()) {
                    fieldsAllocationCount.put(atype, 0);
                    nextOffset.put(atype, 0);
                    spaceOffset.put(atype, new ArrayDeque());
                }
                allocationTypeSizes.put(FieldAllocationType.OOP, this.model.sizeOf("oop"));
                allocationTypeSizes.put(FieldAllocationType.BYTE, this.model.sizeOf("byte"));
                allocationTypeSizes.put(FieldAllocationType.SHORT, this.model.sizeOf("short"));
                allocationTypeSizes.put(FieldAllocationType.WORD, this.model.sizeOf("int"));
                allocationTypeSizes.put(FieldAllocationType.DOUBLE, this.model.sizeOf("long"));
                for (FieldData f : classData.ownFields()) {
                    FieldAllocationType atype = FieldAllocationType.allocationTypeFor(f);
                    Integer count = (Integer)fieldsAllocationCount.get((Object)atype);
                    count = count + 1;
                    fieldsAllocationCount.put(atype, count);
                }
                contendedCount = 0;
                EnumMap<FieldAllocationType, Integer> facContended = new EnumMap<FieldAllocationType, Integer>(FieldAllocationType.class);
                for (FieldData f : classData.ownFields()) {
                    int n;
                    FieldAllocationType atype = FieldAllocationType.allocationTypeFor(f);
                    if (!f.isContended()) continue;
                    Integer count = (Integer)facContended.get((Object)atype);
                    if (count == null) {
                        n = 1;
                    } else {
                        count = count + 1;
                        n = count;
                    }
                    facContended.put(atype, n);
                    ++contendedCount;
                }
                int nextFieldOffset = fieldsStart = (classData.superClass() == null ? this.model.headerSize() : 0) + superClassFieldsSize;
                isContendedClass = classData.isContended();
                if (isContendedClass) {
                    nextFieldOffset += CONTENDED_PADDING_WIDTH;
                }
                doubleCount = (Integer)fieldsAllocationCount.get((Object)FieldAllocationType.DOUBLE) - (facContended.containsKey((Object)FieldAllocationType.DOUBLE) ? (Integer)facContended.get((Object)FieldAllocationType.DOUBLE) : 0);
                wordCount = (Integer)fieldsAllocationCount.get((Object)FieldAllocationType.WORD) - (facContended.containsKey((Object)FieldAllocationType.WORD) ? (Integer)facContended.get((Object)FieldAllocationType.WORD) : 0);
                shortCount = (Integer)fieldsAllocationCount.get((Object)FieldAllocationType.SHORT) - (facContended.containsKey((Object)FieldAllocationType.SHORT) ? (Integer)facContended.get((Object)FieldAllocationType.SHORT) : 0);
                byteCount = (Integer)fieldsAllocationCount.get((Object)FieldAllocationType.BYTE) - (facContended.containsKey((Object)FieldAllocationType.BYTE) ? (Integer)facContended.get((Object)FieldAllocationType.BYTE) : 0);
                oopCount = (Integer)fieldsAllocationCount.get((Object)FieldAllocationType.OOP) - (facContended.containsKey((Object)FieldAllocationType.OOP) ? (Integer)facContended.get((Object)FieldAllocationType.OOP) : 0);
                firstOopOffset = 0;
                compactFields = this.compactFields;
                allocationStyle = this.fieldAllocationStyle;
                if (allocationStyle < 0 || allocationStyle > 2) {
                    allocationStyle = 1;
                }
                if ((allocationStyle != 0 || compactFields) && PREDEF_OFFSETS.contains(classData.name())) {
                    allocationStyle = 0;
                    compactFields = false;
                }
                if (allocationStyle == 0) {
                    nextOffset.put(FieldAllocationType.OOP, nextFieldOffset);
                    nextOffset.put(FieldAllocationType.DOUBLE, (Integer)nextOffset.get((Object)FieldAllocationType.OOP) + oopCount * this.model.sizeOf("oop"));
                } else if (allocationStyle == 1) {
                    nextOffset.put(FieldAllocationType.DOUBLE, nextFieldOffset);
                } else {
                    if (allocationStyle != 2) throw new IllegalStateException();
                    if (superClassFieldsSize > 0 && classData.superClass() != null && classData.superClass().oopsCount() > 0 && superClassLastOopOffset + this.model.sizeOf("oop") == nextFieldOffset) {
                        allocationStyle = 0;
                        nextOffset.put(FieldAllocationType.OOP, nextFieldOffset);
                        nextOffset.put(FieldAllocationType.DOUBLE, (Integer)nextOffset.get((Object)FieldAllocationType.OOP) + oopCount * this.model.sizeOf("oop"));
                    }
                    if (allocationStyle == 2) {
                        allocationStyle = 1;
                        nextOffset.put(FieldAllocationType.DOUBLE, nextFieldOffset);
                    }
                }
                if (!this.takeHierarchyGaps && !this.takeSuperGaps) break block47;
                ListIterator<Integer> itSuperGapsOffsets = superGapsOffsets.listIterator();
                ListIterator<Integer> itSuperGapsSizes = superGapsSizes.listIterator();
                int currentGapIndex = 0;
                while (itSuperGapsOffsets.hasNext() && itSuperGapsSizes.hasNext()) {
                    int length;
                    int offset;
                    block49: {
                        block48: {
                            offset = (Integer)itSuperGapsOffsets.next();
                            length = (Integer)itSuperGapsSizes.next();
                            if (length < (Integer)allocationTypeSizes.get((Object)FieldAllocationType.WORD) || wordCount <= 0) break block48;
                            int alignedWordOffset = MathUtil.align(offset, (int)((Integer)allocationTypeSizes.get((Object)FieldAllocationType.WORD)));
                            if (alignedWordOffset + (Integer)allocationTypeSizes.get((Object)FieldAllocationType.WORD) > offset + length) throw new IllegalStateException();
                            --wordCount;
                            ((ArrayDeque)spaceOffset.get((Object)FieldAllocationType.WORD)).push(alignedWordOffset);
                            if ((length -= ((Integer)allocationTypeSizes.get((Object)FieldAllocationType.WORD)).intValue()) < (Integer)allocationTypeSizes.get((Object)FieldAllocationType.SHORT) || shortCount <= 0) break block49;
                            int alignedShortOffset = MathUtil.align(offset, (int)((Integer)allocationTypeSizes.get((Object)FieldAllocationType.SHORT)));
                            if (alignedShortOffset + (Integer)allocationTypeSizes.get((Object)FieldAllocationType.SHORT) > alignedWordOffset) throw new IllegalStateException();
                            --shortCount;
                            ((ArrayDeque)spaceOffset.get((Object)FieldAllocationType.SHORT)).push(alignedShortOffset);
                            if ((length -= ((Integer)allocationTypeSizes.get((Object)FieldAllocationType.SHORT)).intValue()) < (Integer)allocationTypeSizes.get((Object)FieldAllocationType.BYTE) || byteCount <= 0) break block49;
                            --byteCount;
                            ((ArrayDeque)spaceOffset.get((Object)FieldAllocationType.BYTE)).push(offset);
                            length -= ((Integer)allocationTypeSizes.get((Object)FieldAllocationType.BYTE)).intValue();
                            break block49;
                        }
                        while (length >= (Integer)allocationTypeSizes.get((Object)FieldAllocationType.SHORT) && shortCount > 0) {
                            int alignedShortOffset = MathUtil.align(offset, (int)((Integer)allocationTypeSizes.get((Object)FieldAllocationType.SHORT)));
                            int shortAlignmentGapSize = alignedShortOffset - offset;
                            int shortAlignmentGapOffset = offset;
                            if (alignedShortOffset + (Integer)allocationTypeSizes.get((Object)FieldAllocationType.SHORT) > offset + length) continue;
                            --shortCount;
                            ((ArrayDeque)spaceOffset.get((Object)FieldAllocationType.SHORT)).push(alignedShortOffset);
                            length -= ((Integer)allocationTypeSizes.get((Object)FieldAllocationType.SHORT)).intValue();
                            offset = alignedShortOffset + (Integer)allocationTypeSizes.get((Object)FieldAllocationType.SHORT);
                            if (shortAlignmentGapSize == 0) continue;
                            if (byteCount > 0) {
                                --byteCount;
                                ((ArrayDeque)spaceOffset.get((Object)FieldAllocationType.BYTE)).push(shortAlignmentGapOffset);
                            } else {
                                itSuperGapsOffsets.previous();
                                itSuperGapsSizes.previous();
                                itSuperGapsOffsets.add(shortAlignmentGapOffset);
                                itSuperGapsSizes.add(shortAlignmentGapSize);
                                ++currentGapIndex;
                                itSuperGapsOffsets.next();
                                itSuperGapsSizes.next();
                            }
                            length -= ((Integer)allocationTypeSizes.get((Object)FieldAllocationType.BYTE)).intValue();
                        }
                    }
                    while (length > 0 && byteCount > 0) {
                        --byteCount;
                        ((ArrayDeque)spaceOffset.get((Object)FieldAllocationType.BYTE)).push(offset);
                        length -= ((Integer)allocationTypeSizes.get((Object)FieldAllocationType.BYTE)).intValue();
                        offset += ((Integer)allocationTypeSizes.get((Object)FieldAllocationType.BYTE)).intValue();
                    }
                    if (length == 0) {
                        itSuperGapsOffsets.remove();
                        itSuperGapsSizes.remove();
                        continue;
                    }
                    superGapsOffsets.set(currentGapIndex, offset);
                    superGapsSizes.set(currentGapIndex, length);
                    ++currentGapIndex;
                }
            }
            if (doubleCount > 0) {
                int offset = (Integer)nextOffset.get((Object)FieldAllocationType.DOUBLE);
                nextOffset.put(FieldAllocationType.DOUBLE, MathUtil.align(offset, (int)((Integer)allocationTypeSizes.get((Object)FieldAllocationType.DOUBLE))));
                if (offset != (Integer)nextOffset.get((Object)FieldAllocationType.DOUBLE)) {
                    int length = (Integer)nextOffset.get((Object)FieldAllocationType.DOUBLE) - offset;
                    if (compactFields) {
                        if (wordCount > 0) {
                            --wordCount;
                            ((ArrayDeque)spaceOffset.get((Object)FieldAllocationType.WORD)).push(offset);
                            length -= ((Integer)allocationTypeSizes.get((Object)FieldAllocationType.WORD)).intValue();
                            offset += ((Integer)allocationTypeSizes.get((Object)FieldAllocationType.WORD)).intValue();
                        }
                        while (length >= (Integer)allocationTypeSizes.get((Object)FieldAllocationType.SHORT) && shortCount > 0) {
                            --shortCount;
                            ((ArrayDeque)spaceOffset.get((Object)FieldAllocationType.SHORT)).push(offset);
                            length -= ((Integer)allocationTypeSizes.get((Object)FieldAllocationType.SHORT)).intValue();
                            offset += ((Integer)allocationTypeSizes.get((Object)FieldAllocationType.SHORT)).intValue();
                        }
                        while (length > 0 && byteCount > 0) {
                            --byteCount;
                            ((ArrayDeque)spaceOffset.get((Object)FieldAllocationType.BYTE)).push(offset);
                            length -= ((Integer)allocationTypeSizes.get((Object)FieldAllocationType.BYTE)).intValue();
                            offset += ((Integer)allocationTypeSizes.get((Object)FieldAllocationType.BYTE)).intValue();
                        }
                        if (length >= (Integer)allocationTypeSizes.get((Object)FieldAllocationType.OOP) && oopCount > 0 && allocationStyle != 0) {
                            --oopCount;
                            ((ArrayDeque)spaceOffset.get((Object)FieldAllocationType.OOP)).push(offset);
                            length -= ((Integer)allocationTypeSizes.get((Object)FieldAllocationType.OOP)).intValue();
                            offset += ((Integer)allocationTypeSizes.get((Object)FieldAllocationType.OOP)).intValue();
                        }
                    }
                    if (this.takeSuperGaps && length > 0) {
                        superGapsOffsets.add(offset);
                        superGapsSizes.add(length);
                    }
                }
            }
            nextOffset.put(FieldAllocationType.WORD, (Integer)nextOffset.get((Object)FieldAllocationType.DOUBLE) + doubleCount * (Integer)allocationTypeSizes.get((Object)FieldAllocationType.DOUBLE));
            nextOffset.put(FieldAllocationType.SHORT, (Integer)nextOffset.get((Object)FieldAllocationType.WORD) + wordCount * (Integer)allocationTypeSizes.get((Object)FieldAllocationType.WORD));
            nextOffset.put(FieldAllocationType.BYTE, (Integer)nextOffset.get((Object)FieldAllocationType.SHORT) + shortCount * (Integer)allocationTypeSizes.get((Object)FieldAllocationType.SHORT));
            nextPaddedOffset = (Integer)nextOffset.get((Object)FieldAllocationType.BYTE) + byteCount;
            if (allocationStyle == 1) {
                nextOffset.put(FieldAllocationType.OOP, nextPaddedOffset);
                if (oopCount > 0) {
                    nextOffset.put(FieldAllocationType.OOP, MathUtil.align((Integer)nextOffset.get((Object)FieldAllocationType.OOP), (int)((Integer)allocationTypeSizes.get((Object)FieldAllocationType.OOP))));
                }
                nextPaddedOffset = (Integer)nextOffset.get((Object)FieldAllocationType.OOP) + oopCount * (Integer)allocationTypeSizes.get((Object)FieldAllocationType.OOP);
            }
            HashSet<FieldData> layoutedFields = new HashSet<FieldData>();
            for (FieldData f : classData.ownFields()) {
                int realOffset;
                if (layoutedFields.contains(f) || f.isContended()) continue;
                FieldAllocationType atype = FieldAllocationType.allocationTypeFor(f);
                int allocationTypeSize = (Integer)allocationTypeSizes.get((Object)atype);
                Integer allocationTypeSpaceOffset = (Integer)((ArrayDeque)spaceOffset.get((Object)atype)).poll();
                if (atype == FieldAllocationType.DOUBLE) {
                    int nextDoubleOffset = (Integer)nextOffset.get((Object)FieldAllocationType.DOUBLE);
                    realOffset = (Integer)nextOffset.get((Object)FieldAllocationType.DOUBLE);
                    nextOffset.put(atype, nextDoubleOffset + allocationTypeSize);
                } else if (allocationTypeSpaceOffset != null) {
                    realOffset = allocationTypeSpaceOffset;
                } else {
                    int allocationTypeNextOffset;
                    realOffset = allocationTypeNextOffset = ((Integer)nextOffset.get((Object)atype)).intValue();
                    nextOffset.put(atype, allocationTypeNextOffset + allocationTypeSize);
                }
                layoutedFields.add(f);
                result.add(new FieldLayout(f, realOffset, this.model.sizeOf(f.typeClass())));
                if (atype != FieldAllocationType.OOP) continue;
                superClassLastOopOffset = realOffset;
            }
            if (contendedCount > 0) {
                nextPaddedOffset += CONTENDED_PADDING_WIDTH;
                HashSet<String> contendedGroups = new HashSet<String>();
                for (FieldData f : classData.ownFields()) {
                    if (!f.isContended()) continue;
                    contendedGroups.add(f.contendedGroup());
                }
                for (String currentGroup : contendedGroups) {
                    for (FieldData f : classData.ownFields()) {
                        if (layoutedFields.contains(f) || !f.isContended() || !f.contendedGroup().equals(currentGroup)) continue;
                        FieldAllocationType atype = FieldAllocationType.allocationTypeFor(f);
                        int allocationTypeSize = (Integer)allocationTypeSizes.get((Object)atype);
                        int realOffset = nextPaddedOffset = MathUtil.align(nextPaddedOffset, allocationTypeSize);
                        nextPaddedOffset += allocationTypeSize;
                        if (atype == FieldAllocationType.OOP && firstOopOffset == 0) {
                            firstOopOffset = realOffset;
                        }
                        if (f.contendedGroup().equals("")) {
                            nextPaddedOffset += CONTENDED_PADDING_WIDTH;
                        }
                        result.add(new FieldLayout(f, realOffset, this.model.sizeOf(f.typeClass())));
                    }
                    if (currentGroup.equals("")) continue;
                    nextPaddedOffset += CONTENDED_PADDING_WIDTH;
                }
            }
            if (isContendedClass) {
                nextPaddedOffset += CONTENDED_PADDING_WIDTH;
            }
            superClassFieldsSize = MathUtil.align(nextPaddedOffset, this.model.sizeOf("oop"));
            if (!this.takeHierarchyGaps && !this.takeSuperGaps || superClassFieldsSize == nextPaddedOffset) continue;
            superGapsOffsets.add(nextPaddedOffset);
            superGapsSizes.add(superClassFieldsSize - nextPaddedOffset);
        }
        int minAlignment = this.autoAlign ? 4 : this.model.objectAlignment();
        for (String k : cd.classHierarchy()) {
            Collection<FieldData> fields = cd.fieldsFor(k);
            for (FieldData f : fields) {
                minAlignment = Math.max(minAlignment, this.model.sizeOf(f.typeClass()));
            }
        }
        int n = MathUtil.align(nextPaddedOffset, minAlignment);
        return new ClassLayout(cd, result, this.model.headerSize(), n, true);
    }

    public String toString() {
        return "VM Layout Simulation (" + this.model + (this.takeHierarchyGaps ? ", hierarchy gaps" : "") + (this.takeSuperGaps ? ", super gaps" : "") + (this.autoAlign ? ", autoalign" : "") + (this.compactFields ? ", compact fields" : "") + ", field allocation style: " + this.fieldAllocationStyle + ")";
    }
}

