/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.storage.impl.client;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.KeyException;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.json.Json;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.shibboleth.utilities.java.support.annotation.constraint.Live;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.net.CookieManager;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.security.DataExpiredException;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import net.shibboleth.utilities.java.support.security.DataSealerKeyStrategy;
import org.opensaml.storage.AbstractMapBackedStorageService;
import org.opensaml.storage.MutableStorageRecord;
import org.opensaml.storage.StorageCapabilitiesEx;
import org.opensaml.storage.impl.client.ClientStorageServiceOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientStorageService
extends AbstractMapBackedStorageService
implements Filter,
StorageCapabilitiesEx {
    @Nonnull
    protected static final String LOCK_ATTRIBUTE = "org.opensaml.storage.impl.client.ClientStorageService.lock";
    @Nonnull
    protected static final String STORAGE_ATTRIBUTE = "org.opensaml.storage.impl.client.ClientStorageService.store";
    @Nonnull
    @NotEmpty
    private static final String DEFAULT_STORAGE_NAME = "shib_idp_client_ss";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ClientStorageService.class);
    @Nonnull
    @NotEmpty
    private Map<ClientStorageSource, Integer> capabilityMap = new HashMap<ClientStorageSource, Integer>(2);
    @NonnullAfterInit
    private HttpServletRequest httpServletRequest;
    @NonnullAfterInit
    private CookieManager cookieManager;
    @Nonnull
    @NotEmpty
    private String storageName = "shib_idp_client_ss";
    @NonnullAfterInit
    private DataSealer dataSealer;
    @Nullable
    private DataSealerKeyStrategy keyStrategy;

    public ClientStorageService() {
        this.capabilityMap.put(ClientStorageSource.COOKIE, 4096);
        this.capabilityMap.put(ClientStorageSource.HTML_LOCAL_STORAGE, 0x100000);
    }

    public synchronized void setCleanupInterval(@Nullable Duration interval) {
        super.setCleanupInterval(Duration.ZERO);
    }

    public void setCapabilityMap(@Nonnull @NonnullElements Map<ClientStorageSource, Integer> map) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull(map, (String)"Capability map cannot be null");
        for (Map.Entry<ClientStorageSource, Integer> entry : map.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            this.capabilityMap.put(entry.getKey(), entry.getValue());
        }
    }

    public boolean isServerSide() {
        return false;
    }

    public boolean isClustered() {
        return true;
    }

    public void setHttpServletRequest(@Nonnull HttpServletRequest request) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.httpServletRequest = (HttpServletRequest)Constraint.isNotNull((Object)request, (String)"HttpServletRequest cannot be null");
    }

    @NonnullAfterInit
    public CookieManager getCookieManager() {
        return this.cookieManager;
    }

    public void setCookieManager(@Nonnull CookieManager manager) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.cookieManager = (CookieManager)Constraint.isNotNull((Object)manager, (String)"CookieManager cannot be null");
    }

    @Nonnull
    @NotEmpty
    public String getStorageName() {
        return this.storageName;
    }

    public void setStorageName(@Nonnull @NotEmpty String name) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.storageName = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)name), (String)"Storage name cannot be null or empty");
    }

    public void setDataSealer(@Nonnull DataSealer sealer) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.dataSealer = (DataSealer)Constraint.isNotNull((Object)sealer, (String)"DataSealer cannot be null");
    }

    public void setKeyStrategy(@Nullable DataSealerKeyStrategy strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.keyStrategy = strategy;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        chain.doFilter(request, response);
    }

    public int getContextSize() {
        try {
            return this.capabilityMap.get((Object)this.getSource());
        }
        catch (IOException e) {
            return this.capabilityMap.get((Object)ClientStorageSource.COOKIE);
        }
    }

    public int getKeySize() {
        return this.getContextSize();
    }

    public long getValueSize() {
        return this.getContextSize();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.httpServletRequest == null) {
            throw new ComponentInitializationException("HttpServletRequest must be set");
        }
        if (this.dataSealer == null || this.cookieManager == null) {
            throw new ComponentInitializationException("DataSealer and CookieManager must be set");
        }
    }

    @Nullable
    protected TimerTask getCleanupTask() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected ReadWriteLock getLock() {
        HttpSession session = (HttpSession)Constraint.isNotNull((Object)this.httpServletRequest.getSession(), (String)"HttpSession cannot be null");
        Object lock = session.getAttribute("org.opensaml.storage.impl.client.ClientStorageService.lock." + this.storageName);
        if (lock == null || !(lock instanceof ReadWriteLock)) {
            ClientStorageService clientStorageService = this;
            synchronized (clientStorageService) {
                lock = session.getAttribute("org.opensaml.storage.impl.client.ClientStorageService.lock." + this.storageName);
                if (lock == null) {
                    lock = new ReentrantReadWriteLock();
                    session.setAttribute("org.opensaml.storage.impl.client.ClientStorageService.lock." + this.storageName, lock);
                }
            }
        }
        return (ReadWriteLock)lock;
    }

    @Nonnull
    @NonnullElements
    @Live
    protected Map<String, Map<String, MutableStorageRecord<?>>> getContextMap() throws IOException {
        try {
            HttpSession session = (HttpSession)Constraint.isNotNull((Object)this.httpServletRequest.getSession(), (String)"HttpSession cannot be null");
            Object store = Constraint.isNotNull((Object)session.getAttribute("org.opensaml.storage.impl.client.ClientStorageService.store." + this.storageName), (String)"Storage object was not present in session");
            return ((ClientStorageServiceStore)store).getContextMap();
        }
        catch (ConstraintViolationException e) {
            throw new IOException(e);
        }
    }

    protected void setDirty() throws IOException {
        try {
            HttpSession session = (HttpSession)Constraint.isNotNull((Object)this.httpServletRequest.getSession(), (String)"HttpSession cannot be null");
            Object store = session.getAttribute("org.opensaml.storage.impl.client.ClientStorageService.store." + this.storageName);
            if (store != null && store instanceof ClientStorageServiceStore) {
                ((ClientStorageServiceStore)store).setDirty(true);
            }
        }
        catch (ConstraintViolationException e) {
            throw new IOException(e);
        }
    }

    @Nonnull
    ClientStorageSource getSource() throws IOException {
        Lock lock = this.getLock().readLock();
        try {
            lock.lock();
            HttpSession session = (HttpSession)Constraint.isNotNull((Object)this.httpServletRequest.getSession(), (String)"HttpSession cannot be null");
            Object object = session.getAttribute("org.opensaml.storage.impl.client.ClientStorageService.store." + this.storageName);
            if (object != null && object instanceof ClientStorageServiceStore) {
                ClientStorageSource clientStorageSource = ((ClientStorageServiceStore)object).getSource();
                return clientStorageSource;
            }
            ClientStorageSource clientStorageSource = ClientStorageSource.COOKIE;
            return clientStorageSource;
        }
        catch (ConstraintViolationException e) {
            throw new IOException(e);
        }
        finally {
            lock.unlock();
        }
    }

    boolean isLoaded() throws IOException {
        Lock lock = this.getLock().readLock();
        try {
            lock.lock();
            HttpSession session = (HttpSession)Constraint.isNotNull((Object)this.httpServletRequest.getSession(), (String)"HttpSession cannot be null");
            boolean bl = session.getAttribute("org.opensaml.storage.impl.client.ClientStorageService.store." + this.storageName) instanceof ClientStorageServiceStore;
            return bl;
        }
        catch (ConstraintViolationException e) {
            throw new IOException(e);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void load(@Nullable @NotEmpty String raw, @Nonnull ClientStorageSource source) {
        ClientStorageServiceStore storageObject;
        if (raw != null) {
            this.log.trace("{} Loading storage state into session", (Object)this.getLogPrefix());
            try {
                StringBuffer keyAliasUsed = new StringBuffer();
                String decrypted = this.dataSealer.unwrap(raw, keyAliasUsed);
                this.log.trace("{} Data after decryption: {}", (Object)this.getLogPrefix(), (Object)decrypted);
                storageObject = new ClientStorageServiceStore(decrypted, source);
                if (this.keyStrategy != null) {
                    try {
                        if (!((String)this.keyStrategy.getDefaultKey().getFirst()).equals(keyAliasUsed.toString())) {
                            storageObject.setDirty(true);
                        }
                    }
                    catch (KeyException e) {
                        this.log.error("{} Exception while accessing default key during stale key detection", (Object)this.getLogPrefix(), (Object)e);
                    }
                }
                this.log.debug("{} Successfully decrypted and loaded storage state from client", (Object)this.getLogPrefix());
            }
            catch (DataExpiredException e) {
                this.log.debug("{} Secured data or key has expired", (Object)this.getLogPrefix());
                storageObject = new ClientStorageServiceStore(null, source);
                storageObject.setDirty(true);
            }
            catch (DataSealerException e) {
                this.log.error("{} Exception unwrapping secured data", (Object)this.getLogPrefix(), (Object)e);
                storageObject = new ClientStorageServiceStore(null, source);
                storageObject.setDirty(true);
            }
        } else {
            this.log.trace("{} Initializing empty storage state into session", (Object)this.getLogPrefix());
            storageObject = new ClientStorageServiceStore(null, source);
        }
        Lock lock = this.getLock().writeLock();
        try {
            lock.lock();
            HttpSession session = (HttpSession)Constraint.isNotNull((Object)this.httpServletRequest.getSession(), (String)"HttpSession cannot be null");
            session.setAttribute("org.opensaml.storage.impl.client.ClientStorageService.store." + this.storageName, (Object)storageObject);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    ClientStorageServiceOperation save() {
        this.log.trace("{} Preserving storage state from session", (Object)this.getLogPrefix());
        Lock lock = this.getLock().writeLock();
        try {
            lock.lock();
            HttpSession session = (HttpSession)Constraint.isNotNull((Object)this.httpServletRequest.getSession(), (String)"HttpSession cannot be null");
            Object object = session.getAttribute("org.opensaml.storage.impl.client.ClientStorageService.store." + this.storageName);
            if (object == null || !(object instanceof ClientStorageServiceStore)) {
                this.log.error("{} No storage object found in session", (Object)this.getLogPrefix());
                ClientStorageServiceOperation clientStorageServiceOperation = null;
                return clientStorageServiceOperation;
            }
            ClientStorageServiceOperation clientStorageServiceOperation = ((ClientStorageServiceStore)object).save();
            return clientStorageServiceOperation;
        }
        finally {
            lock.unlock();
        }
    }

    @Nonnull
    @NotEmpty
    private String getLogPrefix() {
        return "StorageService " + this.getId() + ":";
    }

    public class ClientStorageServiceStore {
        @Nonnull
        @NonnullElements
        private final Map<String, Map<String, MutableStorageRecord<?>>> contextMap = new HashMap();
        @Nonnull
        private final ClientStorageSource source;
        private boolean dirty;

        ClientStorageServiceStore(@Nonnull String raw, ClientStorageSource src) {
            this.source = (ClientStorageSource)((Object)Constraint.isNotNull((Object)((Object)src), (String)"Data source cannot be null"));
            if (raw == null) {
                return;
            }
            try {
                JsonReader reader = Json.createReader((Reader)new StringReader(raw));
                JsonStructure st = reader.read();
                if (!(st instanceof JsonObject)) {
                    throw new JsonException("Found invalid data structure while parsing context map");
                }
                JsonObject obj = (JsonObject)st;
                for (Map.Entry context : obj.entrySet()) {
                    if (((JsonValue)context.getValue()).getValueType() != JsonValue.ValueType.OBJECT) {
                        throw new JsonException("Found invalid data structure while parsing context map");
                    }
                    Map<String, MutableStorageRecord<?>> dataMap = this.contextMap.get(context.getKey());
                    if (dataMap == null) {
                        dataMap = new HashMap();
                        this.contextMap.put((String)context.getKey(), dataMap);
                    }
                    JsonObject contextRecords = (JsonObject)context.getValue();
                    for (Map.Entry record : contextRecords.entrySet()) {
                        JsonObject fields = (JsonObject)record.getValue();
                        Long exp = null;
                        if (fields.containsKey((Object)"x")) {
                            exp = fields.getJsonNumber("x").longValueExact();
                        }
                        dataMap.put((String)record.getKey(), new MutableStorageRecord(fields.getString("v"), exp));
                    }
                }
                this.setDirty(false);
            }
            catch (ArithmeticException | ClassCastException | NullPointerException | JsonException e) {
                this.contextMap.clear();
                this.setDirty(true);
                ClientStorageService.this.log.error("{} Found invalid data structure while parsing context map", (Object)ClientStorageService.this.getLogPrefix(), (Object)e);
            }
        }

        @Nonnull
        @NonnullElements
        @Live
        Map<String, Map<String, MutableStorageRecord<?>>> getContextMap() {
            return this.contextMap;
        }

        @Nonnull
        public ClientStorageSource getSource() {
            return this.source;
        }

        boolean isDirty() {
            return this.dirty;
        }

        void setDirty(boolean flag) {
            this.dirty = flag;
        }

        @Nullable
        ClientStorageServiceOperation save() throws IOException {
            if (!this.isDirty()) {
                ClientStorageService.this.log.trace("{} Storage state has not been modified, save operation skipped", (Object)ClientStorageService.this.getLogPrefix());
                return null;
            }
            if (this.contextMap.isEmpty()) {
                ClientStorageService.this.log.trace("{} Data is empty", (Object)ClientStorageService.this.getLogPrefix());
                return new ClientStorageServiceOperation(ClientStorageService.this.getId(), ClientStorageService.this.getStorageName(), null, this.source);
            }
            long exp = 0L;
            long now = System.currentTimeMillis();
            boolean empty = true;
            try {
                StringWriter sink = new StringWriter(128);
                JsonGenerator gen = Json.createGenerator((Writer)sink);
                gen.writeStartObject();
                for (Map.Entry<String, Map<String, MutableStorageRecord<?>>> context : this.contextMap.entrySet()) {
                    if (context.getValue().isEmpty()) continue;
                    gen.writeStartObject(context.getKey());
                    for (Map.Entry<String, MutableStorageRecord<?>> entry : context.getValue().entrySet()) {
                        MutableStorageRecord<?> record = entry.getValue();
                        Long recexp = record.getExpiration();
                        if (recexp != null && recexp <= now) continue;
                        empty = false;
                        gen.writeStartObject(entry.getKey()).write("v", record.getValue());
                        if (recexp != null) {
                            gen.write("x", record.getExpiration().longValue());
                            exp = Math.max(exp, recexp);
                        }
                        gen.writeEnd();
                    }
                    gen.writeEnd();
                }
                gen.writeEnd().close();
                if (empty) {
                    ClientStorageService.this.log.trace("{} Data is empty", (Object)ClientStorageService.this.getLogPrefix());
                    return new ClientStorageServiceOperation(ClientStorageService.this.getId(), ClientStorageService.this.getStorageName(), null, this.source);
                }
                String raw = sink.toString();
                ClientStorageService.this.log.trace("{} Size of data before encryption is {}", (Object)ClientStorageService.this.getLogPrefix(), (Object)raw.length());
                ClientStorageService.this.log.trace("{} Data before encryption is {}", (Object)ClientStorageService.this.getLogPrefix(), (Object)raw);
                try {
                    String wrapped = ClientStorageService.this.dataSealer.wrap(raw, exp > 0L ? Instant.ofEpochMilli(exp) : Instant.now().plus(Duration.ofDays(1L)));
                    ClientStorageService.this.log.trace("{} Size of data after encryption is {}", (Object)ClientStorageService.this.getLogPrefix(), (Object)wrapped.length());
                    this.setDirty(false);
                    return new ClientStorageServiceOperation(ClientStorageService.this.getId(), ClientStorageService.this.getStorageName(), wrapped, this.source);
                }
                catch (DataSealerException e) {
                    throw new IOException(e);
                }
            }
            catch (JsonException e) {
                throw new IOException(e);
            }
        }
    }

    public static enum ClientStorageSource {
        COOKIE,
        HTML_LOCAL_STORAGE;

    }
}

