/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nvdcve;

import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.annotation.concurrent.ThreadSafe;
import org.anarres.jdiagnostics.DefaultQuery;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.io.IOUtils;
import org.owasp.dependencycheck.data.nvdcve.DatabaseException;
import org.owasp.dependencycheck.data.nvdcve.DriverLoadException;
import org.owasp.dependencycheck.data.nvdcve.DriverLoader;
import org.owasp.dependencycheck.utils.DBUtils;
import org.owasp.dependencycheck.utils.DependencyVersion;
import org.owasp.dependencycheck.utils.DependencyVersionUtil;
import org.owasp.dependencycheck.utils.FileUtils;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class DatabaseManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseManager.class);
    public static final String DB_STRUCTURE_RESOURCE = "data/initialize.sql";
    public static final String DB_STRUCTURE_UPDATE_RESOURCE = "data/upgrade_%s.sql";
    public static final String UPGRADE_HELP_URL = "https://jeremylong.github.io/DependencyCheck/data/upgrade.html";
    private Driver driver = null;
    private String connectionString = null;
    private String userName = null;
    private String password = null;
    private int callDepth = 0;
    private final Settings settings;
    private boolean isH2;
    private boolean isOracle;
    private String databaseProductName;
    private BasicDataSource connectionPool;

    public DatabaseManager(Settings settings) throws DatabaseException {
        this.settings = settings;
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() throws DatabaseException {
        boolean autoUpdate = this.settings.getBoolean("odc.autoupdate", true);
        Connection conn = null;
        try {
            String driverName = this.settings.getString("data.driver_name", "");
            if (!driverName.isEmpty()) {
                String driverPath = this.settings.getString("data.driver_path", "");
                LOGGER.debug("Loading driver '{}'", (Object)driverName);
                try {
                    if (!driverPath.isEmpty()) {
                        LOGGER.debug("Loading driver from: {}", (Object)driverPath);
                        this.driver = DriverLoader.load(driverName, driverPath);
                    } else {
                        this.driver = DriverLoader.load(driverName);
                        LOGGER.warn("Explicitly loaded driver {} from classpath; if JDBCv4 service loading is supported by the driver you should remove the dbDriver configuration", (Object)driverName);
                    }
                }
                catch (DriverLoadException ex) {
                    LOGGER.debug("Unable to load database driver", (Throwable)ex);
                    throw new DatabaseException("Unable to load database driver", ex);
                }
            }
            this.userName = this.settings.getString("data.user", "dcuser");
            this.password = this.settings.getString("data.password", "DC-Pass1337!");
            try {
                this.connectionString = this.settings.getConnectionString("data.connection_string", "data.file_name");
            }
            catch (IOException ex) {
                LOGGER.debug("Unable to retrieve the database connection string", (Throwable)ex);
                throw new DatabaseException("Unable to retrieve the database connection string", ex);
            }
            this.isH2 = DatabaseManager.isH2Connection(this.connectionString);
            boolean shouldCreateSchema = false;
            try {
                if (autoUpdate && this.isH2) {
                    shouldCreateSchema = !this.h2DataFileExists();
                    LOGGER.debug("Need to create DB Structure: {}", (Object)shouldCreateSchema);
                }
            }
            catch (IOException ioex) {
                LOGGER.debug("Unable to verify database exists", (Throwable)ioex);
                throw new DatabaseException("Unable to verify database exists", ioex);
            }
            LOGGER.debug("Loading database connection");
            LOGGER.debug("Connection String: {}", (Object)this.connectionString);
            LOGGER.debug("Database User: {}", (Object)this.userName);
            try {
                conn = this.connectionString.toLowerCase().contains("integrated security=true") || this.connectionString.toLowerCase().contains("trusted_connection=true") ? DriverManager.getConnection(this.connectionString) : DriverManager.getConnection(this.connectionString, this.userName, this.password);
            }
            catch (SQLException ex) {
                if (ex.getMessage().contains("java.net.UnknownHostException") && this.connectionString.contains("AUTO_SERVER=TRUE;")) {
                    this.connectionString = this.connectionString.replace("AUTO_SERVER=TRUE;", "");
                    try {
                        conn = DriverManager.getConnection(this.connectionString, this.userName, this.password);
                        this.settings.setString("data.connection_string", this.connectionString);
                        LOGGER.debug("Unable to start the database in server mode; reverting to single user mode");
                    }
                    catch (SQLException sqlex) {
                        LOGGER.debug("Unable to connect to the database", (Throwable)ex);
                        throw new DatabaseException("Unable to connect to the database", ex);
                    }
                }
                if (this.isH2 && ex.getMessage().contains("file version or invalid file header")) {
                    LOGGER.error("Incompatible or corrupt database found. To resolve this issue please remove the existing database by running purge");
                    throw new DatabaseException("Incompatible or corrupt database found; run the purge command to resolve the issue");
                }
                LOGGER.debug("Unable to connect to the database", (Throwable)ex);
                throw new DatabaseException("Unable to connect to the database", ex);
            }
            this.databaseProductName = this.determineDatabaseProductName(conn);
            this.isOracle = "oracle".equals(this.databaseProductName);
            if (shouldCreateSchema) {
                try {
                    this.createTables(conn);
                }
                catch (DatabaseException dex) {
                    LOGGER.debug("", (Throwable)dex);
                    throw new DatabaseException("Unable to create the database structure", dex);
                }
            }
            try {
                this.ensureSchemaVersion(conn);
            }
            catch (DatabaseException dex) {
                LOGGER.debug("", (Throwable)dex);
                throw new DatabaseException("Database schema does not match this version of dependency-check", dex);
            }
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {
                    LOGGER.debug("An error occurred closing the connection", (Throwable)ex);
                }
            }
        }
    }

    private String determineDatabaseProductName(Connection conn) {
        try {
            String databaseProductName = conn.getMetaData().getDatabaseProductName().toLowerCase();
            LOGGER.debug("Database product: {}", (Object)databaseProductName);
            return databaseProductName;
        }
        catch (SQLException se) {
            LOGGER.warn("Problem determining database product!", (Throwable)se);
            return null;
        }
    }

    public void cleanup() {
        if (this.driver != null) {
            DriverLoader.cleanup(this.driver);
            this.driver = null;
        }
        this.connectionString = null;
        this.userName = null;
        this.password = null;
    }

    public boolean h2DataFileExists() throws IOException {
        return DatabaseManager.h2DataFileExists(this.settings);
    }

    public static boolean h2DataFileExists(Settings configuration) throws IOException {
        File file = DatabaseManager.getH2DataFile(configuration);
        return file.exists();
    }

    public static File getH2DataFile(Settings configuration) throws IOException {
        File dir = configuration.getH2DataDirectory();
        String fileName = configuration.getString("data.file_name");
        return new File(dir, fileName);
    }

    public String getDatabaseProductName() {
        return this.databaseProductName;
    }

    public boolean isH2Connection() {
        return this.isH2;
    }

    public boolean isOracle() {
        return this.isOracle;
    }

    public static boolean isH2Connection(Settings configuration) {
        String connStr;
        try {
            connStr = configuration.getConnectionString("data.connection_string", "data.file_name");
        }
        catch (IOException ex) {
            LOGGER.debug("Unable to get connectionn string", (Throwable)ex);
            return false;
        }
        return DatabaseManager.isH2Connection(connStr);
    }

    public static boolean isH2Connection(String connectionString) {
        return connectionString.startsWith("jdbc:h2:file:");
    }

    private void createTables(Connection conn) throws DatabaseException {
        LOGGER.debug("Creating database structure");
        try {
            String dbStructure = this.getResource(DB_STRUCTURE_RESOURCE);
            Statement statement = null;
            try {
                statement = conn.createStatement();
                statement.execute(dbStructure);
            }
            catch (SQLException ex) {
                LOGGER.debug("", (Throwable)ex);
                throw new DatabaseException("Unable to create database statement", ex);
            }
            finally {
                DBUtils.closeStatement(statement);
            }
        }
        catch (IOException ex) {
            throw new DatabaseException("Unable to create database schema", ex);
        }
        catch (LinkageError ex) {
            LOGGER.debug(new DefaultQuery((Throwable)ex).call().toString());
        }
    }

    private String getResource(String resource) throws IOException {
        String dbStructure;
        try {
            URL url = Resources.getResource((String)resource);
            dbStructure = Resources.toString((URL)url, (Charset)StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException ex) {
            LOGGER.debug("Resources.getResource(String) failed to find the DB Structure Resource", (Throwable)ex);
            try (InputStream is = FileUtils.getResourceAsStream((String)resource);){
                dbStructure = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            }
        }
        return dbStructure;
    }

    private void updateSchema(Connection conn, DependencyVersion appExpectedVersion, DependencyVersion currentDbVersion) throws DatabaseException {
        block12: {
            if (this.connectionString.startsWith("jdbc:h2:file:")) {
                LOGGER.debug("Updating database structure");
                String updateFile = String.format(DB_STRUCTURE_UPDATE_RESOURCE, currentDbVersion.toString());
                if ("data/upgrade_4.2.sql".equals(updateFile) && !FileUtils.getResourceAsFile((String)updateFile).exists()) {
                    throw new DatabaseException("unable to upgrade the database schema - please run the dependency-check purge command to remove the existing database");
                }
                try {
                    String dbStructureUpdate = this.getResource(updateFile);
                    Statement statement = null;
                    try {
                        statement = conn.createStatement();
                        statement.execute(dbStructureUpdate);
                        break block12;
                    }
                    catch (SQLException ex) {
                        throw new DatabaseException(String.format("Unable to upgrade the database schema from %s to %s", currentDbVersion, appExpectedVersion.toString()), ex);
                    }
                    finally {
                        DBUtils.closeStatement(statement);
                    }
                }
                catch (IOException | IllegalArgumentException ex) {
                    String msg = String.format("Upgrade SQL file does not exist: %s", updateFile);
                    throw new DatabaseException(msg, ex);
                }
            }
            int e0 = Integer.parseInt(appExpectedVersion.getVersionParts().get(0));
            int c0 = Integer.parseInt(currentDbVersion.getVersionParts().get(0));
            int e1 = Integer.parseInt(appExpectedVersion.getVersionParts().get(1));
            int c1 = Integer.parseInt(currentDbVersion.getVersionParts().get(1));
            if (e0 == c0 && e1 < c1) {
                LOGGER.warn("A new version of dependency-check is available; consider upgrading");
                this.settings.setBoolean("odc.autoupdate", false);
            } else if (e0 != c0 || e1 != c1) {
                LOGGER.error("The database schema must be upgraded to use this version of dependency-check. Please see {} for more information.", (Object)UPGRADE_HELP_URL);
                throw new DatabaseException("Database schema is out of date");
            }
        }
    }

    public ResourceBundle getSqlStatements() {
        ResourceBundle statementBundle = this.getDatabaseProductName() != null ? ResourceBundle.getBundle("data/dbStatements", new Locale(this.getDatabaseProductName())) : ResourceBundle.getBundle("data/dbStatements");
        return statementBundle;
    }

    private void ensureSchemaVersion(Connection conn) throws DatabaseException {
        PreparedStatement ps;
        ResultSet rs;
        block9: {
            rs = null;
            ps = null;
            ResourceBundle statementBundle = this.getSqlStatements();
            String sql = statementBundle.getString("SELECT_SCHEMA_VERSION");
            try {
                ps = conn.prepareStatement(sql);
                rs = ps.executeQuery();
                if (rs.next()) {
                    String dbSchemaVersion = this.settings.getString("data.version");
                    DependencyVersion appDbVersion = DependencyVersionUtil.parseVersion(dbSchemaVersion);
                    if (appDbVersion == null) {
                        throw new DatabaseException("Invalid application database schema");
                    }
                    DependencyVersion db = DependencyVersionUtil.parseVersion(rs.getString(1));
                    if (db == null) {
                        throw new DatabaseException("Invalid database schema");
                    }
                    LOGGER.debug("DC Schema: {}", (Object)appDbVersion);
                    LOGGER.debug("DB Schema: {}", (Object)db);
                    if (appDbVersion.compareTo(db) <= 0) break block9;
                    boolean autoUpdate = this.settings.getBoolean("odc.autoupdate", true);
                    if (autoUpdate) {
                        this.updateSchema(conn, appDbVersion, db);
                        if (++this.callDepth < 10) {
                            this.ensureSchemaVersion(conn);
                        }
                        break block9;
                    }
                    throw new DatabaseException("Old database schema identified - please execute dependency-check without the no-update configuration to continue");
                }
                throw new DatabaseException("Database schema is missing");
            }
            catch (SQLException ex) {
                try {
                    LOGGER.debug("", (Throwable)ex);
                    throw new DatabaseException("Unable to check the database schema version", ex);
                }
                catch (Throwable throwable) {
                    DBUtils.closeResultSet(rs);
                    DBUtils.closeStatement(ps);
                    throw throwable;
                }
            }
        }
        DBUtils.closeResultSet(rs);
        DBUtils.closeStatement(ps);
    }

    public void open() {
        this.connectionPool = new BasicDataSource();
        if (this.driver != null) {
            this.connectionPool.setDriver(this.driver);
        }
        this.connectionPool.setUrl(this.connectionString);
        this.connectionPool.setUsername(this.userName);
        this.connectionPool.setPassword(this.password);
    }

    public void close() {
        try {
            this.connectionPool.close();
        }
        catch (SQLException ex) {
            LOGGER.debug("Error closing the connection pool", (Throwable)ex);
        }
        this.connectionPool = null;
    }

    public boolean isOpen() {
        return this.connectionPool != null;
    }

    public Connection getConnection() throws DatabaseException {
        try {
            return this.connectionPool.getConnection();
        }
        catch (SQLException ex) {
            throw new DatabaseException("Error connecting to the database", ex);
        }
    }
}

