/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.dependency;

import io.github.jeremylong.openvulnerability.client.nvd.CvssV2;
import io.github.jeremylong.openvulnerability.client.nvd.CvssV3;
import io.github.jeremylong.openvulnerability.client.nvd.CvssV4;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.jetbrains.annotations.NotNull;
import org.owasp.dependencycheck.dependency.CweSet;
import org.owasp.dependencycheck.dependency.Reference;
import org.owasp.dependencycheck.dependency.VulnerableSoftware;
import org.owasp.dependencycheck.utils.SeverityUtil;

@NotThreadSafe
public class Vulnerability
implements Serializable,
Comparable<Vulnerability> {
    private static final long serialVersionUID = 307319490326651053L;
    private String name;
    private String description;
    private org.owasp.dependencycheck.data.knownexploited.json.Vulnerability knownExploitedVulnerability;
    private final Set<Reference> references = Collections.synchronizedSet(new HashSet());
    private final Set<VulnerableSoftware> vulnerableSoftware = new HashSet<VulnerableSoftware>();
    private final CweSet cwes = new CweSet();
    private String unscoredSeverity;
    private CvssV2 cvssV2;
    private CvssV3 cvssV3;
    private CvssV4 cvssV4;
    private VulnerableSoftware matchedVulnerableSoftware;
    private String notes;
    private Source source = null;

    public Vulnerability() {
    }

    public Vulnerability(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Set<Reference> getReferences() {
        return this.references;
    }

    public List<Reference> getReferences(boolean sorted) {
        ArrayList<Reference> sortedRefs = new ArrayList<Reference>(this.references);
        if (sorted) {
            Collections.sort(sortedRefs);
        }
        return sortedRefs;
    }

    public void addReferences(Set<Reference> references) {
        this.references.addAll(references);
    }

    public void addReference(Reference ref) {
        this.references.add(ref);
    }

    public void addReference(String referenceSource, String referenceName, String referenceUrl) {
        Reference ref = new Reference();
        ref.setSource(referenceSource);
        ref.setName(referenceName);
        ref.setUrl(referenceUrl);
        this.references.add(ref);
    }

    public void setKnownExploitedVulnerability(org.owasp.dependencycheck.data.knownexploited.json.Vulnerability kev) {
        this.knownExploitedVulnerability = kev;
    }

    public org.owasp.dependencycheck.data.knownexploited.json.Vulnerability getKnownExploitedVulnerability() {
        return this.knownExploitedVulnerability;
    }

    public Set<VulnerableSoftware> getVulnerableSoftware() {
        return this.vulnerableSoftware;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VulnerableSoftware> getVulnerableSoftware(boolean sorted) {
        Set<VulnerableSoftware> set = this.vulnerableSoftware;
        synchronized (set) {
            ArrayList<VulnerableSoftware> sortedVulnerableSoftware = new ArrayList<VulnerableSoftware>(this.vulnerableSoftware);
            if (sorted) {
                Collections.sort(sortedVulnerableSoftware);
            }
            return sortedVulnerableSoftware;
        }
    }

    public void addVulnerableSoftware(Set<VulnerableSoftware> vulnerableSoftware) {
        this.vulnerableSoftware.addAll(vulnerableSoftware);
    }

    public void addVulnerableSoftware(VulnerableSoftware software) {
        this.vulnerableSoftware.add(software);
    }

    public CvssV2 getCvssV2() {
        return this.cvssV2;
    }

    public void setCvssV2(CvssV2 cvssV2) {
        this.cvssV2 = cvssV2;
    }

    public CvssV3 getCvssV3() {
        return this.cvssV3;
    }

    public void setCvssV3(CvssV3 cvssV3) {
        this.cvssV3 = cvssV3;
    }

    public CvssV4 getCvssV4() {
        return this.cvssV4;
    }

    public void setCvssV4(CvssV4 cvssV4) {
        this.cvssV4 = cvssV4;
    }

    public CweSet getCwes() {
        return this.cwes;
    }

    public void addCwe(String cwe) {
        this.cwes.addCwe(cwe);
    }

    public String getUnscoredSeverity() {
        return this.unscoredSeverity;
    }

    public void setUnscoredSeverity(String unscoredSeverity) {
        this.unscoredSeverity = unscoredSeverity;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Vulnerability)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Vulnerability other = (Vulnerability)obj;
        return new EqualsBuilder().append((Object)this.name, (Object)other.name).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(3, 73).append((Object)this.name).toHashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Vulnerability ");
        sb.append(this.name);
        sb.append("\nReferences:\n");
        for (Reference reference : this.getReferences(true)) {
            sb.append("=> ");
            sb.append(reference);
            sb.append("\n");
        }
        sb.append("\nSoftware:\n");
        for (VulnerableSoftware software : this.getVulnerableSoftware(true)) {
            sb.append("=> ");
            sb.append(software);
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public int compareTo(@NotNull Vulnerability o) {
        return new CompareToBuilder().append((Object)o.bestEffortSeverityLevelForSorting(), (Object)this.bestEffortSeverityLevelForSorting()).append((Object)this.name, (Object)o.name).toComparison();
    }

    private Double bestEffortSeverityLevelForSorting() {
        if (this.cvssV3 != null) {
            return SeverityUtil.sortAdjustedCVSSv3BaseScore(this.cvssV3.getCvssData().getBaseScore());
        }
        if (this.cvssV2 != null) {
            return this.cvssV2.getCvssData().getBaseScore();
        }
        return SeverityUtil.estimatedSortAdjustedCVSSv3(this.unscoredSeverity);
    }

    public String getHighestSeverityText() {
        if (this.cvssV3 != null) {
            return this.cvssV3.getCvssData().getBaseSeverity().value().toUpperCase();
        }
        if (this.cvssV2 != null) {
            return this.cvssV2.getCvssData().getBaseSeverity().toUpperCase();
        }
        return SeverityUtil.unscoredToSeveritytext(this.unscoredSeverity).toUpperCase();
    }

    public void setMatchedVulnerableSoftware(VulnerableSoftware software) {
        this.matchedVulnerableSoftware = software;
    }

    public VulnerableSoftware getMatchedVulnerableSoftware() {
        return this.matchedVulnerableSoftware;
    }

    public Source getSource() {
        return this.source;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public static enum Source {
        NVD,
        NPM,
        RETIREJS,
        OSSINDEX,
        BUNDLEAUDIT,
        MIXAUDIT;

    }
}

