/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update.nvd;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.owasp.dependencycheck.data.nvdcve.CveDB;
import org.owasp.dependencycheck.data.update.exception.UpdateException;
import org.owasp.dependencycheck.data.update.nvd.NvdCveInfo;
import org.owasp.dependencycheck.data.update.nvd.ProcessTask;
import org.owasp.dependencycheck.utils.DownloadFailedException;
import org.owasp.dependencycheck.utils.Downloader;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DownloadTask
implements Callable<Future<ProcessTask>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DownloadTask.class);
    private final CveDB cveDB;
    private final ExecutorService processorService;
    private NvdCveInfo nvdCveInfo;
    private final Settings settings;
    private File file;

    public DownloadTask(NvdCveInfo nvdCveInfo, ExecutorService processor, CveDB cveDB, Settings settings) throws UpdateException {
        this.nvdCveInfo = nvdCveInfo;
        this.processorService = processor;
        this.cveDB = cveDB;
        this.settings = settings;
        try {
            this.file = File.createTempFile("cve" + nvdCveInfo.getId() + '_', ".json.gz", settings.getTempDirectory());
        }
        catch (IOException ex) {
            throw new UpdateException("Unable to create temporary files", ex);
        }
    }

    public NvdCveInfo getNvdCveInfo() {
        return this.nvdCveInfo;
    }

    public void setNvdCveInfo(NvdCveInfo nvdCveInfo) {
        this.nvdCveInfo = nvdCveInfo;
    }

    public File getFile() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<ProcessTask> call() throws Exception {
        try {
            URL url1 = new URL(this.nvdCveInfo.getUrl());
            LOGGER.info("Download Started for NVD CVE - {}", (Object)this.nvdCveInfo.getId());
            long startDownload = System.currentTimeMillis();
            try {
                Downloader downloader = new Downloader(this.settings);
                downloader.fetchFile(url1, this.file, "cve.user", "cve.password");
            }
            catch (DownloadFailedException ex) {
                LOGGER.error("Download Failed for NVD CVE - {}\nSome CVEs may not be reported. Reason: {}", (Object)this.nvdCveInfo.getId(), (Object)ex.getMessage());
                if (this.settings.getString("proxy.server") == null) {
                    LOGGER.error("If you are behind a proxy you may need to configure dependency-check to use the proxy.");
                }
                LOGGER.debug("", (Throwable)ex);
                Future<ProcessTask> future = null;
                this.settings.cleanup(false);
                return future;
            }
            LOGGER.info("Download Complete for NVD CVE - {}  ({} ms)", (Object)this.nvdCveInfo.getId(), (Object)(System.currentTimeMillis() - startDownload));
            if (this.processorService == null) {
                Future<ProcessTask> ex = null;
                return ex;
            }
            ProcessTask task = new ProcessTask(this.cveDB, this, this.settings);
            Future<ProcessTask> future = this.processorService.submit(task);
            return future;
        }
        catch (Throwable ex) {
            LOGGER.error("An exception occurred downloading NVD CVE - {}\nSome CVEs may not be reported. Reason: {}", (Object)this.nvdCveInfo.getId(), (Object)ex.getMessage());
            LOGGER.debug("Download Task Failed", ex);
        }
        finally {
            this.settings.cleanup(false);
        }
        return null;
    }

    public void cleanup() {
        if (this.file != null && this.file.exists() && !this.file.delete()) {
            LOGGER.debug("Failed to delete first temporary file {}", (Object)this.file.toString());
            this.file.deleteOnExit();
        }
    }

    public boolean isModified() {
        return StringUtils.containsIgnoreCase((CharSequence)this.file.toString(), (CharSequence)"modified");
    }
}

