/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import org.primefaces.cache.CacheProvider;

public class DefaultCacheProvider
implements CacheProvider {
    private static final Logger LOGGER = Logger.getLogger(DefaultCacheProvider.class.getName());
    private final Map<String, ConcurrentMap<String, Object>> cache = new ConcurrentHashMap<String, ConcurrentMap<String, Object>>();

    public DefaultCacheProvider() {
        LOGGER.warning("DefaultCacheProvider is for development purposes only, prefer another provider such as EhCache, HazelCast, or Caffeine in production.");
    }

    @Override
    public Object get(String region, String key) {
        Map<String, Object> cacheRegion = this.getRegion(region);
        return cacheRegion.get(key);
    }

    @Override
    public void put(String region, String key, Object object) {
        Map<String, Object> cacheRegion = this.getRegion(region);
        cacheRegion.put(key, object);
    }

    @Override
    public void remove(String region, String key) {
        Map<String, Object> cacheRegion = this.getRegion(region);
        cacheRegion.remove(key);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    private Map<String, Object> getRegion(String name) {
        return this.cache.computeIfAbsent(name, k -> new ConcurrentHashMap());
    }
}

