/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.autocomplete;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.event.PhaseId;
import org.primefaces.component.autocomplete.AutoComplete;
import org.primefaces.component.autocomplete.AutoCompleteBase;
import org.primefaces.component.column.Column;
import org.primefaces.event.AutoCompleteEvent;
import org.primefaces.expression.SearchExpressionUtils;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.FacetUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;
import org.primefaces.validate.ClientValidator;

public class AutoCompleteRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        AutoComplete ac = (AutoComplete)component;
        String clientId = ac.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        if (!this.shouldDecode((UIInput)ac)) {
            return;
        }
        if (ac.isMultiple()) {
            this.decodeMultiple(context, ac);
        } else {
            this.decodeSingle(context, ac);
        }
        this.decodeBehaviors(context, (UIComponent)ac);
        String query = (String)params.get(clientId + "_query");
        if (query != null || ac.isClientCacheRequest(context)) {
            AutoCompleteEvent autoCompleteEvent = new AutoCompleteEvent((UIComponent)ac, query);
            autoCompleteEvent.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            ac.queueEvent(autoCompleteEvent);
        }
    }

    protected void decodeSingle(FacesContext context, AutoComplete ac) {
        Map params = context.getExternalContext().getRequestParameterMap();
        String clientId = ac.getClientId(context);
        String valueParam = ac.getVar() != null ? clientId + "_hinput" : clientId + "_input";
        String submittedValue = (String)params.get(valueParam);
        if (submittedValue != null) {
            ac.setSubmittedValue(submittedValue);
        }
    }

    protected void decodeMultiple(FacesContext context, AutoComplete ac) {
        Map paramValues = context.getExternalContext().getRequestParameterValuesMap();
        Map params = context.getExternalContext().getRequestParameterMap();
        String clientId = ac.getClientId(context);
        String[] hinputValues = (String[])paramValues.get(clientId + "_hinput");
        String[] submittedValues = hinputValues != null ? hinputValues : new String[]{};
        String inputValue = (String)params.get(clientId + "_input");
        if (!this.isValueBlank(inputValue)) {
            submittedValues = LangUtils.concat(submittedValues, new String[]{inputValue});
        }
        if (submittedValues.length > 0) {
            ac.setSubmittedValue(submittedValues);
        } else {
            ac.setSubmittedValue("");
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        AutoComplete ac = (AutoComplete)component;
        Map params = context.getExternalContext().getRequestParameterMap();
        String query = (String)params.get(ac.getClientId(context) + "_query");
        if ((ac.isClientQueryMode() || ac.isHybridQueryMode()) && !ac.isCache()) {
            ac.setCache(true);
        }
        if (query != null) {
            if (ac.isDynamicLoadRequest(context)) {
                this.encodePanel(context, ac);
            } else {
                this.encodeResults(context, component);
            }
        } else if (ac.isClientCacheRequest(context)) {
            this.encodeResults(context, (UIComponent)ac);
        } else {
            this.encodeMarkup(context, ac);
            this.encodeScript(context, ac);
        }
    }

    public void encodeResults(FacesContext context, UIComponent component) throws IOException {
        AutoComplete ac = (AutoComplete)component;
        List results = ac.getSuggestions();
        int maxResults = ac.getMaxResults();
        if (ac.isServerQueryMode() && maxResults != Integer.MAX_VALUE && results != null && ((List)results).size() > maxResults) {
            results = ((List)results).subList(0, ac.getMaxResults());
        }
        this.encodeSuggestions(context, ac, results);
    }

    protected void encodeMarkup(FacesContext context, AutoComplete ac) throws IOException {
        if (ac.isMultiple()) {
            this.encodeMultipleMarkup(context, ac);
        } else {
            this.encodeSingleMarkup(context, ac);
        }
    }

    protected void encodeSingleMarkup(FacesContext context, AutoComplete ac) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = ac.getClientId(context);
        boolean isDropdown = ac.isDropdown();
        boolean disabled = ac.isDisabled();
        String styleClass = this.getStyleClassBuilder(context).add("ui-autocomplete").add(ac.getStyleClass()).add(isDropdown, "ui-autocomplete-dd").add(disabled, "ui-state-disabled").build();
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (ac.getStyle() != null) {
            writer.writeAttribute("style", (Object)ac.getStyle(), null);
        }
        this.encodeInput(context, ac, clientId);
        if (ac.getVar() != null) {
            this.encodeHiddenInput(context, ac, clientId);
        }
        if (isDropdown) {
            this.encodeDropDown(context, ac, clientId);
        }
        if (!ac.isDynamic()) {
            this.encodePanel(context, ac);
        }
        writer.endElement("span");
    }

    protected void encodeInput(FacesContext context, AutoComplete ac, String clientId) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String var = ac.getVar();
        String inputStyle = ac.getInputStyle();
        String defaultStyleClass = ac.isDropdown() ? "ui-autocomplete-input ui-autocomplete-dd-input ui-inputfield ui-widget ui-state-default ui-corner-left" : "ui-autocomplete-input ui-inputfield ui-widget ui-state-default ui-corner-all";
        String inputStyleClass = this.createStyleClass((UIInput)ac, AutoCompleteBase.PropertyKeys.inputStyleClass.name(), defaultStyleClass);
        String autocompleteProp = ac.getAutocomplete() != null ? ac.getAutocomplete() : "off";
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)(clientId + "_input"), null);
        writer.writeAttribute("name", (Object)(clientId + "_input"), null);
        writer.writeAttribute("type", (Object)ac.getType(), null);
        writer.writeAttribute("class", (Object)inputStyleClass, null);
        writer.writeAttribute("autocomplete", (Object)autocompleteProp, null);
        writer.writeAttribute("role", (Object)"combobox", null);
        writer.writeAttribute("aria-controls", (Object)(clientId + "_panel"), null);
        writer.writeAttribute("aria-expanded", (Object)"false", null);
        writer.writeAttribute("aria-haspopup", (Object)"listbox", null);
        if (inputStyle != null) {
            writer.writeAttribute("style", (Object)inputStyle, null);
        }
        this.renderAccessibilityAttributes(context, (UIInput)ac);
        this.renderPassThruAttributes(context, (UIComponent)ac, HTML.INPUT_TEXT_ATTRS_WITHOUT_EVENTS);
        this.renderDomEvents(context, (UIComponent)ac, HTML.INPUT_TEXT_EVENTS);
        if (var == null) {
            String itemLabel = ComponentUtils.getValueToRender(context, (UIComponent)ac);
            if (itemLabel != null) {
                writer.writeAttribute("value", (Object)itemLabel, null);
            }
        } else {
            String itemLabel;
            Map requestMap = context.getExternalContext().getRequestMap();
            if (ac.isValid()) {
                requestMap.put(var, ac.getValue());
                itemLabel = ac.getItemLabel();
            } else {
                Object submittedValue = ac.getSubmittedValue();
                Object value = ac.getValue();
                if (submittedValue == null && value != null) {
                    requestMap.put(var, value);
                    itemLabel = ac.getItemLabel();
                } else if (submittedValue != null) {
                    try {
                        Object item = this.getConvertedValue(context, (UIComponent)ac, String.valueOf(submittedValue));
                        requestMap.put(var, item);
                        itemLabel = ac.getItemLabel();
                    }
                    catch (ConverterException ce) {
                        itemLabel = String.valueOf(submittedValue);
                    }
                } else {
                    itemLabel = null;
                }
            }
            if (itemLabel != null) {
                writer.writeAttribute("value", (Object)itemLabel, null);
            }
            requestMap.remove(var);
        }
        this.renderValidationMetadata(context, (EditableValueHolder)ac, new ClientValidator[0]);
        writer.endElement("input");
    }

    protected void encodeHiddenInput(FacesContext context, AutoComplete ac, String clientId) throws IOException {
        String valueToRender = ComponentUtils.getValueToRender(context, (UIComponent)ac);
        this.renderHiddenInput(context, clientId + "_hinput", valueToRender, ac.isDisabled());
    }

    protected void encodeHiddenSelect(FacesContext context, AutoComplete ac, String clientId, List<String> values) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String id = clientId + "_hinput";
        writer.startElement("select", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.writeAttribute("multiple", (Object)"multiple", null);
        writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
        writer.writeAttribute("tabindex", (Object)"-1", null);
        writer.writeAttribute("aria-hidden", (Object)"true", null);
        if (ac.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", "disabled");
        }
        this.renderValidationMetadata(context, (EditableValueHolder)ac, new ClientValidator[0]);
        for (int i = 0; i < values.size(); ++i) {
            String value = values.get(i);
            writer.startElement("option", null);
            writer.writeAttribute("value", (Object)value, null);
            writer.writeAttribute("selected", (Object)"selected", null);
            writer.endElement("option");
        }
        writer.endElement("select");
    }

    protected void encodeDropDown(FacesContext context, AutoComplete ac, String clientId) throws IOException {
        boolean disabled;
        ResponseWriter writer = context.getResponseWriter();
        Object dropdownClass = "ui-autocomplete-dropdown ui-button ui-widget ui-state-default ui-corner-right ui-button-icon-only";
        boolean bl = disabled = ac.isDisabled() || ac.isReadonly();
        if (disabled) {
            dropdownClass = (String)dropdownClass + " ui-state-disabled";
        }
        writer.startElement("button", (UIComponent)ac);
        writer.writeAttribute("id", (Object)(clientId + "_button"), null);
        writer.writeAttribute("class", dropdownClass, null);
        writer.writeAttribute("type", (Object)"button", null);
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (ac.getDropdownTabindex() != null) {
            writer.writeAttribute("tabindex", (Object)ac.getDropdownTabindex(), null);
        } else if (ac.getTabindex() != null) {
            writer.writeAttribute("tabindex", (Object)ac.getTabindex(), null);
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-icon-primary ui-icon ui-icon-triangle-1-s", null);
        writer.endElement("span");
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text", null);
        writer.write("&nbsp;");
        writer.endElement("span");
        writer.endElement("button");
    }

    protected void encodePanel(FacesContext context, AutoComplete ac) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Object styleClass = ac.getPanelStyleClass();
        styleClass = styleClass == null ? "ui-autocomplete-panel ui-widget-content ui-corner-all ui-helper-hidden ui-shadow ui-input-overlay" : "ui-autocomplete-panel ui-widget-content ui-corner-all ui-helper-hidden ui-shadow ui-input-overlay " + (String)styleClass;
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)(ac.getClientId(context) + "_panel"), null);
        writer.writeAttribute("class", styleClass, null);
        writer.writeAttribute("tabindex", (Object)"-1", null);
        if (ac.getPanelStyle() != null) {
            writer.writeAttribute("style", (Object)ac.getPanelStyle(), null);
        }
        if (ac.isDynamic() && ac.isDynamicLoadRequest(context)) {
            this.encodeResults(context, (UIComponent)ac);
        }
        writer.endElement("span");
    }

    protected void encodeMultipleMarkup(FacesContext context, AutoComplete ac) throws IOException {
        List values;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = ac.getClientId(context);
        String inputId = clientId + "_input";
        if (ac.isValid()) {
            values = (List)ac.getValue();
        } else {
            Object submittedValue = ac.getSubmittedValue();
            try {
                values = (List)this.getConvertedValue(context, (UIComponent)ac, submittedValue);
            }
            catch (ConverterException ce) {
                values = Arrays.asList((String[])submittedValue);
            }
        }
        ArrayList<String> stringValues = new ArrayList<String>();
        boolean disabled = ac.isDisabled();
        boolean isDropdown = ac.isDropdown();
        String title = ac.getTitle();
        String style = ac.getStyle();
        String styleClass = this.getStyleClassBuilder(context).add("ui-autocomplete ui-autocomplete-multiple").add(ac.getStyleClass()).add(isDropdown, "ui-autocomplete-dd").add(disabled, "ui-state-disabled").build();
        String listClass = isDropdown ? "ui-autocomplete-multiple-container ui-autocomplete-dd-multiple-container ui-widget ui-inputfield ui-state-default ui-corner-left" : "ui-autocomplete-multiple-container ui-widget ui-inputfield ui-state-default ui-corner-all";
        listClass = this.createStyleClass((UIInput)ac, null, listClass);
        String autocompleteProp = ac.getAutocomplete() != null ? ac.getAutocomplete() : "off";
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (title != null) {
            writer.writeAttribute("title", (Object)title, null);
        }
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)listClass, null);
        writer.writeAttribute("tabindex", (Object)-1, null);
        writer.writeAttribute("role", (Object)"listbox", null);
        writer.writeAttribute("aria-orientation", (Object)"horizontal", null);
        if (values != null && !values.isEmpty()) {
            Converter converter = ComponentUtils.getConverter(context, (UIComponent)ac);
            String var = ac.getVar();
            boolean pojo = var != null;
            SequencedCollection items = ac.isUnique() ? new LinkedHashSet(values) : values;
            for (Object value : items) {
                Object itemValue = null;
                String itemLabel = null;
                if (pojo) {
                    context.getExternalContext().getRequestMap().put(var, value);
                    itemValue = ac.getItemValue();
                    itemLabel = ac.getItemLabel();
                } else {
                    itemValue = value;
                    itemLabel = String.valueOf(value);
                }
                String tokenValue = converter != null ? converter.getAsString(context, (UIComponent)ac, itemValue) : String.valueOf(itemValue);
                Object itemStyleClass = "ui-autocomplete-token ui-state-active ui-corner-all";
                if (ac.getItemStyleClass() != null) {
                    itemStyleClass = (String)itemStyleClass + " " + ac.getItemStyleClass();
                }
                writer.startElement("li", null);
                writer.writeAttribute("data-token-value", (Object)tokenValue, null);
                writer.writeAttribute("class", itemStyleClass, null);
                writer.writeAttribute("role", (Object)"option", null);
                writer.writeAttribute("aria-label", (Object)itemLabel, null);
                writer.writeAttribute("aria-selected", (Object)"true", null);
                String labelClass = disabled ? "ui-autocomplete-token-label-disabled" : "ui-autocomplete-token-label";
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)labelClass, null);
                writer.writeText((Object)itemLabel, null);
                writer.endElement("span");
                if (!disabled) {
                    writer.startElement("span", null);
                    writer.writeAttribute("class", (Object)"ui-autocomplete-token-icon ui-icon ui-icon-close", null);
                    writer.writeAttribute("aria-hidden", (Object)"true", null);
                    writer.endElement("span");
                }
                writer.endElement("li");
                stringValues.add(tokenValue);
            }
        }
        writer.startElement("li", null);
        writer.writeAttribute("class", (Object)"ui-autocomplete-input-token", null);
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"text", null);
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("autocomplete", (Object)autocompleteProp, null);
        this.renderAccessibilityAttributes(context, (UIInput)ac);
        writer.writeAttribute("role", (Object)"combobox", null);
        writer.writeAttribute("aria-controls", (Object)(clientId + "_panel"), null);
        writer.writeAttribute("aria-expanded", (Object)"false", null);
        writer.writeAttribute("aria-haspopup", (Object)"listbox", null);
        this.renderPassThruAttributes(context, (UIComponent)ac, HTML.INPUT_TEXT_ATTRS_WITHOUT_EVENTS);
        this.renderDomEvents(context, (UIComponent)ac, HTML.INPUT_TEXT_EVENTS);
        writer.endElement("input");
        writer.endElement("li");
        writer.endElement("ul");
        if (ac.isDropdown()) {
            this.encodeDropDown(context, ac, clientId);
        }
        if (!ac.isDynamic()) {
            this.encodePanel(context, ac);
        }
        this.encodeHiddenSelect(context, ac, clientId, stringValues);
        writer.endElement("div");
    }

    protected void encodeSuggestions(FacesContext context, AutoComplete ac, Object items) throws IOException {
        boolean customContent = !ac.getColums().isEmpty();
        Converter converter = ComponentUtils.getConverter(context, (UIComponent)ac);
        if (customContent) {
            ComponentUtils.runWithoutFacesContextVar(context, "org.primefaces.HELPER_RENDERER", () -> this.encodeSuggestionsAsTable(context, ac, items, converter));
        } else {
            this.encodeSuggestionsAsList(context, ac, items, converter);
        }
        this.encodeFooter(context, ac);
    }

    protected void encodeFooter(FacesContext context, AutoComplete ac) throws IOException {
        UIComponent footer = ac.getFacet("footer");
        if (FacetUtils.shouldRenderFacet(footer)) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-autocomplete-footer", null);
            footer.encodeAll(context);
            writer.endElement("div");
        }
    }

    protected void encodeSuggestionsAsTable(FacesContext context, AutoComplete ac, Object items, Converter converter) throws IOException {
        Column column;
        int i;
        if (items == null || ((Collection)items).isEmpty()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        String var = ac.getVar();
        boolean pojo = var != null;
        boolean hasHeader = false;
        for (i = 0; i < ac.getColums().size(); ++i) {
            column = ac.getColums().get(i);
            if (!column.isRendered() || column.getHeaderText() == null && !FacetUtils.shouldRenderFacet(column.getFacet("header"))) continue;
            hasHeader = true;
            break;
        }
        writer.startElement("table", (UIComponent)ac);
        writer.writeAttribute("class", (Object)"ui-autocomplete-items ui-autocomplete-table ui-widget-content ui-widget ui-corner-all ui-helper-reset", null);
        if (hasHeader) {
            writer.startElement("thead", (UIComponent)ac);
            for (i = 0; i < ac.getColums().size(); ++i) {
                column = ac.getColums().get(i);
                if (!column.isRendered()) continue;
                String headerText = column.getHeaderText();
                UIComponent headerFacet = column.getFacet("header");
                String styleClass = column.getStyleClass() == null ? "ui-state-default" : "ui-state-default " + column.getStyleClass();
                writer.startElement("th", null);
                writer.writeAttribute("class", (Object)styleClass, null);
                if (column.getStyle() != null) {
                    writer.writeAttribute("style", (Object)column.getStyle(), null);
                }
                if (FacetUtils.shouldRenderFacet(headerFacet)) {
                    headerFacet.encodeAll(context);
                } else if (headerText != null) {
                    writer.writeText((Object)headerText, null);
                }
                writer.endElement("th");
            }
            writer.endElement("thead");
        }
        writer.startElement("tbody", (UIComponent)ac);
        if (items != null) {
            int index = 0;
            if (ac.isClientQueryMode() || items instanceof Map) {
                for (Map.Entry entry : ((Map)items).entrySet()) {
                    String key = (String)entry.getKey();
                    List list = (List)entry.getValue();
                    for (Object item : list) {
                        this.encodeSuggestionItemsAsTable(context, ac, item, converter, pojo, var, key, index++);
                    }
                }
            } else {
                for (Map.Entry item : (List)items) {
                    this.encodeSuggestionItemsAsTable(context, ac, item, converter, pojo, var, null, index++);
                }
                if (ac.hasMoreSuggestions()) {
                    this.encodeMoreText(context, ac);
                }
            }
        }
        writer.endElement("tbody");
        writer.endElement("table");
    }

    protected void encodeSuggestionsAsList(FacesContext context, AutoComplete ac, Object items, Converter converter) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String var = ac.getVar();
        Map requestMap = context.getExternalContext().getRequestMap();
        boolean pojo = var != null;
        writer.startElement("ul", (UIComponent)ac);
        writer.writeAttribute("class", (Object)"ui-autocomplete-items ui-autocomplete-list ui-widget-content ui-widget ui-corner-all ui-helper-reset", null);
        writer.writeAttribute("role", (Object)"listbox", null);
        if (items != null) {
            int index = 0;
            if (ac.isClientQueryMode() || items instanceof Map) {
                for (Map.Entry entry : ((Map)items).entrySet()) {
                    String key = (String)entry.getKey();
                    List list = (List)entry.getValue();
                    for (Object item : list) {
                        this.encodeSuggestionItemsAsList(context, ac, item, converter, pojo, var, key, index++);
                    }
                }
            } else {
                for (Object item : (List)items) {
                    this.encodeSuggestionItemsAsList(context, ac, item, converter, pojo, var, null, index++);
                }
                if (ac.hasMoreSuggestions()) {
                    this.encodeMoreText(context, ac);
                }
            }
        }
        writer.endElement("ul");
        if (pojo) {
            requestMap.remove(var);
        }
    }

    protected void encodeSuggestionItemsAsList(FacesContext context, AutoComplete ac, Object item, Converter converter, boolean pojo, String var, String key, int rowNumber) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Map requestMap = context.getExternalContext().getRequestMap();
        UIComponent itemtip = ac.getFacet("itemtip");
        boolean hasGroupByTooltip = ac.getValueExpression(AutoCompleteBase.PropertyKeys.groupByTooltip.toString()) != null;
        writer.startElement("li", null);
        writer.writeAttribute("id", (Object)(ac.getClientId(context) + "_item_" + rowNumber), null);
        writer.writeAttribute("class", (Object)"ui-autocomplete-item ui-autocomplete-list-item ui-corner-all", null);
        if (pojo) {
            requestMap.put(var, item);
            String value = converter == null ? String.valueOf(ac.getItemValue()) : converter.getAsString(context, (UIComponent)ac, ac.getItemValue());
            String itemLabel = ac.getItemLabel();
            writer.writeAttribute("data-item-value", (Object)value, null);
            writer.writeAttribute("data-item-label", (Object)itemLabel, null);
            writer.writeAttribute("data-item-class", (Object)ac.getItemStyleClass(), null);
            writer.writeAttribute("data-item-group", ac.getGroupBy(), null);
            if (key != null) {
                writer.writeAttribute("data-item-key", (Object)key, null);
            }
            if (hasGroupByTooltip) {
                writer.writeAttribute("data-item-group-tooltip", (Object)ac.getGroupByTooltip(), null);
            }
            if (ac.isEscape()) {
                writer.writeText((Object)itemLabel, null);
            } else {
                writer.write(itemLabel);
            }
        } else {
            String itemAsString = item.toString();
            writer.writeAttribute("data-item-label", (Object)itemAsString, null);
            writer.writeAttribute("data-item-value", (Object)itemAsString, null);
            writer.writeAttribute("data-item-class", (Object)ac.getItemStyleClass(), null);
            if (key != null) {
                writer.writeAttribute("data-item-key", (Object)key, null);
            }
            if (ac.isEscape()) {
                writer.writeText(item, null);
            } else {
                writer.write(itemAsString);
            }
        }
        writer.endElement("li");
        if (FacetUtils.shouldRenderFacet(itemtip)) {
            writer.startElement("li", null);
            writer.writeAttribute("class", (Object)"ui-autocomplete-itemtip-content", null);
            itemtip.encodeAll(context);
            writer.endElement("li");
        }
    }

    protected void encodeSuggestionItemsAsTable(FacesContext context, AutoComplete ac, Object item, Converter converter, boolean pojo, String var, String key, int index) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Map requestMap = context.getExternalContext().getRequestMap();
        UIComponent itemtip = ac.getFacet("itemtip");
        boolean hasGroupByTooltip = ac.getValueExpression(AutoCompleteBase.PropertyKeys.groupByTooltip.toString()) != null;
        writer.startElement("tr", null);
        writer.writeAttribute("id", (Object)(ac.getClientId(context) + "_item_" + index), null);
        writer.writeAttribute("class", (Object)"ui-autocomplete-item ui-autocomplete-row ui-widget-content ui-corner-all", null);
        if (pojo) {
            requestMap.put(var, item);
            String value = converter == null ? String.valueOf(ac.getItemValue()) : converter.getAsString(context, (UIComponent)ac, ac.getItemValue());
            writer.writeAttribute("data-item-value", (Object)value, null);
            writer.writeAttribute("data-item-label", (Object)ac.getItemLabel(), null);
            writer.writeAttribute("data-item-class", (Object)ac.getItemStyleClass(), null);
            writer.writeAttribute("data-item-group", ac.getGroupBy(), null);
            if (key != null) {
                writer.writeAttribute("data-item-key", (Object)key, null);
            }
            if (hasGroupByTooltip) {
                writer.writeAttribute("data-item-group-tooltip", (Object)ac.getGroupByTooltip(), null);
            }
        }
        for (int i = 0; i < ac.getColums().size(); ++i) {
            Column column = ac.getColums().get(i);
            if (!column.isRendered()) continue;
            writer.startElement("td", null);
            if (key != null) {
                writer.writeAttribute("data-item-key", (Object)key, null);
            }
            if (column.getStyle() != null) {
                writer.writeAttribute("style", (Object)column.getStyle(), null);
            }
            if (column.getStyleClass() != null) {
                writer.writeAttribute("class", (Object)column.getStyleClass(), null);
            }
            this.encodeIndexedId(context, (UIComponent)column, index);
            writer.endElement("td");
        }
        if (FacetUtils.shouldRenderFacet(itemtip)) {
            writer.startElement("td", null);
            writer.writeAttribute("class", (Object)"ui-autocomplete-itemtip-content", null);
            this.encodeIndexedId(context, itemtip, index);
            writer.endElement("td");
        }
        writer.endElement("tr");
    }

    protected void encodeScript(FacesContext context, AutoComplete ac) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("AutoComplete", ac);
        wb.attr("minLength", ac.getMinQueryLength(), 1).attr("delay", ac.getQueryDelay()).attr("forceSelection", ac.isForceSelection(), false).attr("scrollHeight", ac.getScrollHeight(), Integer.MAX_VALUE).attr("multiple", ac.isMultiple(), false).attr("appendTo", SearchExpressionUtils.resolveOptionalClientIdForClientSide(context, (UIComponent)ac, ac.getAppendTo())).attr("grouping", ac.getValueExpression(AutoCompleteBase.PropertyKeys.groupBy.toString()) != null, false).attr("queryEvent", ac.getQueryEvent(), null).attr("dropdownMode", ac.getDropdownMode(), null).attr("autoHighlight", ac.isAutoHighlight(), true).attr("showEmptyMessage", ac.isShowEmptyMessage(), true).attr("myPos", ac.getMy(), null).attr("atPos", ac.getAt(), null).attr("active", ac.isActive(), true).attr("unique", ac.isUnique(), false).attr("dynamic", ac.isDynamic(), false).attr("autoSelection", ac.isAutoSelection(), true).attr("escape", ac.isEscape(), true).attr("queryMode", ac.getQueryMode()).attr("completeEndpoint", ac.getCompleteEndpoint()).attr("moreText", ac.getMoreText()).attr("hasFooter", FacetUtils.shouldRenderFacet(ac.getFacet("footer")));
        if (ac.isCache()) {
            wb.attr("cache", true).attr("cacheTimeout", ac.getCacheTimeout());
        }
        if (FacetUtils.shouldRenderFacet(ac.getFacet("itemtip"))) {
            wb.attr("itemtip", true, false).attr("itemtipMyPosition", ac.getItemtipMyPosition(), null).attr("itemtipAtPosition", ac.getItemtipAtPosition(), null);
        }
        if (ac.isMultiple()) {
            wb.attr("selectLimit", ac.getSelectLimit(), Integer.MAX_VALUE);
        }
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)ac);
        wb.finish();
    }

    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        AutoComplete ac = (AutoComplete)component;
        boolean isMultiple = ac.isMultiple();
        if (submittedValue == null || submittedValue.equals("") || ac.isMoreTextRequest(context)) {
            return isMultiple ? new ArrayList() : null;
        }
        Converter converter = ComponentUtils.getConverter(context, component);
        if (isMultiple) {
            String[] values = (String[])submittedValue;
            ArrayList<String> list = new ArrayList<String>();
            for (String value : values) {
                String convertedValue;
                if (this.isValueBlank(value)) continue;
                String string = convertedValue = converter != null ? converter.getAsObject(context, (UIComponent)ac, value) : value;
                if (convertedValue == null) continue;
                list.add(convertedValue);
            }
            return list;
        }
        if (converter != null) {
            return converter.getAsObject(context, component, (String)submittedValue);
        }
        return submittedValue;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeMoreText(FacesContext context, AutoComplete ac) throws IOException {
        int colSize = ac.getColums().size();
        String moreText = ac.getMoreText();
        ResponseWriter writer = context.getResponseWriter();
        if (colSize > 0) {
            writer.startElement("tr", null);
            writer.writeAttribute("class", (Object)"ui-autocomplete-item ui-autocomplete-moretext ui-widget-content ui-corner-all", null);
            writer.startElement("td", null);
            writer.writeAttribute("colspan", (Object)colSize, null);
            writer.writeText((Object)moreText, "moreText");
            writer.endElement("td");
            writer.endElement("tr");
        } else {
            writer.startElement("li", null);
            writer.writeAttribute("class", (Object)"ui-autocomplete-item ui-autocomplete-moretext ui-corner-all", null);
            writer.writeText((Object)moreText, "moreText");
            writer.endElement("li");
        }
    }
}

