/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.autoupdate;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletException;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;
import org.primefaces.component.autoupdate.AutoUpdateListener;
import org.primefaces.util.LangUtils;
import org.primefaces.util.Lazy;

public class AutoUpdateTagHandler
extends TagHandler {
    private static final Logger LOGGER = Logger.getLogger(AutoUpdateTagHandler.class.getName());
    private final TagAttribute disabledAttribute;
    private final TagAttribute onAttribute;
    private Lazy<ProjectStage> projectStage = new Lazy(() -> FacesContext.getCurrentInstance().getApplication().getProjectStage());

    public AutoUpdateTagHandler(TagConfig tagConfig) {
        super(tagConfig);
        this.disabledAttribute = this.getAttribute("disabled");
        this.onAttribute = this.getAttribute("on");
    }

    public void apply(FaceletContext faceletContext, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        if (!ComponentHandler.isNew((UIComponent)parent)) {
            return;
        }
        if (LangUtils.isBlank(parent.getRendererType())) {
            if (this.projectStage.get() == ProjectStage.Development) {
                LOGGER.log(Level.WARNING, "Can not auto-update component \"{0}\" with id \"{1}\" without an attached renderer.", new Object[]{parent.getClass().getName(), parent.getClientId()});
            }
            return;
        }
        String on = null;
        if (this.onAttribute != null) {
            on = this.onAttribute.getValue(faceletContext);
        }
        if (this.disabledAttribute == null) {
            AutoUpdateListener.subscribe(parent, on);
        } else if (this.disabledAttribute.isLiteral()) {
            if (!this.disabledAttribute.getBoolean(faceletContext)) {
                AutoUpdateListener.subscribe(parent, on);
            }
        } else {
            AutoUpdateListener.subscribe(parent, this.disabledAttribute.getValueExpression(faceletContext, Boolean.class), on);
        }
    }
}

