/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.charts;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.api.UIChart;
import org.primefaces.context.PrimeRequestContext;
import org.primefaces.model.charts.ChartData;
import org.primefaces.model.charts.ChartDataSet;
import org.primefaces.model.charts.ChartModel;
import org.primefaces.model.charts.ChartOptions;
import org.primefaces.model.charts.axes.cartesian.CartesianAxes;
import org.primefaces.model.charts.axes.cartesian.CartesianScales;
import org.primefaces.model.charts.axes.radial.RadialScales;
import org.primefaces.model.charts.optionconfig.animation.Animation;
import org.primefaces.model.charts.optionconfig.elements.Elements;
import org.primefaces.model.charts.optionconfig.legend.Legend;
import org.primefaces.model.charts.optionconfig.title.Title;
import org.primefaces.model.charts.optionconfig.tooltip.Tooltip;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ChartUtils;
import org.primefaces.util.EscapeUtils;
import org.primefaces.util.LangUtils;

@Deprecated(since="14.0.0", forRemoval=true)
public class ChartRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        super.decodeBehaviors(context, component);
    }

    protected void encodeMarkup(FacesContext context, UIChart chart) throws IOException {
        Title title;
        ChartOptions options;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = chart.getClientId(context);
        String style = chart.getStyle();
        Object styleClass = chart.getStyleClass();
        styleClass = styleClass != null ? "ui-chart " + (String)styleClass : "ui-chart";
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", styleClass, "styleClass");
        writer.startElement("canvas", null);
        writer.writeAttribute("id", (Object)(clientId + "_canvas"), null);
        writer.writeAttribute("role", (Object)"img", null);
        String ariaLabel = chart.getAriaLabel();
        if (LangUtils.isBlank(ariaLabel) && (options = (ChartOptions)chart.getModel().getOptions()) != null && (title = options.getTitle()) != null) {
            ariaLabel = String.valueOf(title.getText());
        }
        writer.writeAttribute("aria-label", (Object)ariaLabel, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        writer.endElement("canvas");
        writer.endElement("div");
    }

    protected void encodeConfig(FacesContext context, ChartModel model) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        ChartData data = model.getData();
        Object options = model.getOptions();
        writer.write(",\"config\":{");
        writer.write("\"type\":\"" + model.getType() + "\"");
        this.encodeData(context, data);
        this.encodeOptions(context, model.getType(), options);
        writer.write("}");
        String extender = model.getExtender();
        if (extender != null) {
            writer.write(",\"extender\":" + extender);
        }
    }

    protected void encodeData(FacesContext context, ChartData data) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (data == null) {
            return;
        }
        List<ChartDataSet> dataSetList = data.getDataSet();
        writer.write(",\"data\":{");
        writer.write("\"datasets\":[");
        for (int i = 0; i < dataSetList.size(); ++i) {
            ChartDataSet dataSet = dataSetList.get(i);
            if (dataSet == null) continue;
            if (i != 0) {
                writer.write(",");
            }
            writer.write(dataSet.encode());
        }
        writer.write("]");
        Object labels = data.getLabels();
        if (labels != null) {
            writer.write(",\"labels\":");
            this.writeLabels(context, labels);
        }
        writer.write("}");
    }

    protected void writeLabels(FacesContext context, Object labels) throws IOException {
        boolean isList = labels instanceof List;
        if (isList) {
            ResponseWriter writer = context.getResponseWriter();
            List labelList = (List)labels;
            writer.write("[");
            for (int i = 0; i < labelList.size(); ++i) {
                Object item;
                if (i != 0) {
                    writer.write(",");
                }
                if ((item = labelList.get(i)) instanceof String) {
                    writer.write("\"" + EscapeUtils.forJavaScript((String)item) + "\"");
                    continue;
                }
                this.writeLabels(context, item);
            }
            writer.write("]");
        }
    }

    protected void encodeOptions(FacesContext context, String type, Object options) throws IOException {
    }

    protected void encodeScales(FacesContext context, String chartName, Object scales, boolean hasComma) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (scales != null) {
            if (hasComma) {
                writer.write(",");
            }
            if (scales instanceof CartesianScales) {
                List<CartesianAxes> yAxes;
                writer.write("\"scales\":{");
                CartesianScales cScales = (CartesianScales)scales;
                StringBuilder scaleAttrs = new StringBuilder(128);
                List<CartesianAxes> xAxes = cScales.getXAxes();
                if (xAxes != null && !xAxes.isEmpty()) {
                    this.encodeAxes(context, chartName, "x", xAxes);
                }
                if ((yAxes = cScales.getYAxes()) != null && !yAxes.isEmpty()) {
                    if (xAxes != null && !xAxes.isEmpty()) {
                        writer.write(",");
                    }
                    this.encodeAxes(context, chartName, "y", yAxes);
                }
                writer.write(scaleAttrs.toString());
                writer.write("}");
            } else if (scales instanceof RadialScales) {
                writer.write("\"scale\":{");
                RadialScales rScales = (RadialScales)scales;
                StringBuilder scaleAttrs = new StringBuilder(128);
                if (rScales.getAngleLines() != null) {
                    this.writeJsonAttribute(scaleAttrs, "angleLines", rScales.getAngleLines().encode());
                }
                if (rScales.getGridLines() != null) {
                    this.writeJsonAttribute(scaleAttrs, "grid", rScales.getGridLines().encode());
                }
                if (rScales.getPointLabels() != null) {
                    this.writeJsonAttribute(scaleAttrs, "pointLabels", rScales.getPointLabels().encode());
                }
                if (rScales.getTicks() != null) {
                    this.writeJsonAttribute(scaleAttrs, "ticks", rScales.getTicks().encode());
                }
                if (rScales.getStartAngle() != null) {
                    this.writeJsonAttribute(scaleAttrs, "startAngle", rScales.getStartAngle().toString());
                }
                writer.write(scaleAttrs.toString());
                writer.write("}");
            }
        }
    }

    private void writeJsonAttribute(StringBuilder stringBuilder, String attributeName, String attributeValue) {
        if (stringBuilder.length() > 0) {
            stringBuilder.append(",");
        }
        stringBuilder.append("\"" + attributeName + "\":" + attributeValue);
    }

    protected void encodeAxes(FacesContext context, String chartName, String defaultAxeId, List<CartesianAxes> axes) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        for (int i = 0; i < axes.size(); ++i) {
            CartesianAxes data;
            if (i > 0) {
                writer.write(",");
            }
            String axeId = (data = axes.get(i)).getId() == null ? defaultAxeId : data.getId();
            writer.write("\"" + axeId + "\": {");
            writer.write(data.encode());
            writer.write("}");
        }
    }

    protected void encodeElements(FacesContext context, Elements elements, boolean hasComma) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (elements != null) {
            if (hasComma) {
                writer.write(",");
            }
            writer.write("\"elements\":{");
            writer.write(elements.encode());
            writer.write("}");
        }
    }

    protected void encodeResponsive(FacesContext context, ChartOptions options, boolean hasComma) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (hasComma) {
            writer.write(",");
        }
        ChartUtils.writeDataValue((Writer)writer, "responsive", options.isResponsive(), false);
        ChartUtils.writeDataValue((Writer)writer, "maintainAspectRatio", options.isMaintainAspectRatio(), true);
        ChartUtils.writeDataValue((Writer)writer, "aspectRatio", options.getAspectRatio(), true);
    }

    protected void encodePlugins(FacesContext context, ChartOptions options, boolean hasComma) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (hasComma) {
            writer.write(",");
        }
        writer.write("\"plugins\":{");
        Title title = options.getTitle();
        Title subtitle = options.getSubtitle();
        Tooltip tooltip = options.getTooltip();
        Legend legend = options.getLegend();
        this.encodeTitle(context, title, "title", false);
        this.encodeTitle(context, subtitle, "subtitle", title != null);
        this.encodeTooltip(context, tooltip, title != null || subtitle != null);
        this.encodeLegend(context, legend, title != null || subtitle != null || tooltip != null);
        writer.write("}");
    }

    protected void encodeTitle(FacesContext context, Title title, String element, boolean hasComma) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (title != null) {
            if (hasComma) {
                writer.write(",");
            }
            writer.write(String.format("\"%s\":{", element));
            writer.write(title.encode());
            writer.write("}");
        }
    }

    protected void encodeTooltip(FacesContext context, Tooltip tooltip, boolean hasComma) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (tooltip != null) {
            if (hasComma) {
                writer.write(",");
            }
            if (PrimeRequestContext.getCurrentInstance(context).isRTL()) {
                tooltip.setRtl(true);
                tooltip.setTextDirection("rtl");
            }
            writer.write("\"tooltip\":{");
            writer.write(tooltip.encode());
            writer.write("}");
        }
    }

    protected void encodeLegend(FacesContext context, Legend legend, boolean hasComma) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (legend != null) {
            if (hasComma) {
                writer.write(",");
            }
            if (PrimeRequestContext.getCurrentInstance(context).isRTL()) {
                legend.setRtl(true);
                legend.setTextDirection("rtl");
            }
            writer.write("\"legend\":{");
            writer.write(legend.encode());
            writer.write("}");
        }
    }

    protected void encodeAnimation(FacesContext context, Animation animation, boolean hasComma) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (animation != null) {
            if (hasComma) {
                writer.write(",");
            }
            writer.write("\"animation\":{");
            writer.write(animation.encode());
            writer.write("}");
        }
    }
}

