/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable.export;

import java.io.IOException;
import javax.faces.context.FacesContext;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.primefaces.component.datatable.export.DataTableExcelXExporter;
import org.primefaces.component.export.ExcelOptions;

public class DataTableExcelXStreamExporter
extends DataTableExcelXExporter {
    @Override
    protected Workbook createDocument(FacesContext context) throws IOException {
        SXSSFWorkbook sxssfWorkbook = new SXSSFWorkbook(100);
        sxssfWorkbook.setCompressTempFiles(true);
        return sxssfWorkbook;
    }

    @Override
    protected void postExport(FacesContext context) throws IOException {
        super.postExport(context);
        SXSSFWorkbook sxssfWorkbook = (SXSSFWorkbook)this.document;
        sxssfWorkbook.dispose();
    }

    @Override
    protected void applyOptions(Sheet sheet) {
        super.applyOptions(sheet);
        SXSSFSheet sxssfSheet = (SXSSFSheet)sheet;
        ExcelOptions options = (ExcelOptions)this.exportConfiguration.getOptions();
        if (options == null || options.isAutoSizeColumn()) {
            sxssfSheet.trackAllColumnsForAutoSizing();
        } else {
            sxssfSheet.untrackAllColumnsForAutoSizing();
        }
    }
}

