/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.export;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.el.MethodExpression;
import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIPanel;
import javax.faces.component.UISelectMany;
import javax.faces.component.ValueHolder;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.component.html.HtmlGraphicImage;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.api.UITable;
import org.primefaces.component.celleditor.CellEditor;
import org.primefaces.component.export.ColumnValue;
import org.primefaces.component.export.TableExporter;
import org.primefaces.component.overlaypanel.OverlayPanel;
import org.primefaces.component.rowtoggler.RowToggler;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.EscapeUtils;
import org.primefaces.util.FacetUtils;
import org.primefaces.util.LangUtils;

@Deprecated(since="14.0.0", forRemoval=true)
public final class ExporterUtils {
    private ExporterUtils() {
    }

    public static String getComponentValue(FacesContext context, UIComponent component) {
        if (component instanceof HtmlCommandLink) {
            HtmlCommandLink link = (HtmlCommandLink)component;
            Object value = link.getValue();
            if (value != null) {
                return String.valueOf(value);
            }
            for (UIComponent child : link.getChildren()) {
                if (!(child instanceof ValueHolder)) continue;
                return ExporterUtils.getComponentValue(context, child);
            }
            return "";
        }
        if (component instanceof ValueHolder) {
            Object submittedValue;
            if (component instanceof EditableValueHolder && (submittedValue = ((EditableValueHolder)component).getSubmittedValue()) != null) {
                return submittedValue.toString();
            }
            ValueHolder valueHolder = (ValueHolder)component;
            Object value = valueHolder.getValue();
            if (value == null) {
                return "";
            }
            Converter converter = valueHolder.getConverter();
            if (converter == null) {
                Class<?> valueType = value.getClass();
                converter = context.getApplication().createConverter(valueType);
            }
            if (converter != null) {
                if (component instanceof UISelectMany) {
                    List<Object> collection = null;
                    if (value instanceof List) {
                        collection = (List<Object>)value;
                    } else if (value.getClass().isArray()) {
                        collection = Arrays.asList(value);
                    } else {
                        throw new FacesException("Value of " + component.getClientId(context) + " must be a List or an Array.");
                    }
                    Converter finalConverter = converter;
                    return collection.stream().map(o -> finalConverter.getAsString(context, component, o)).collect(Collectors.joining(","));
                }
                return converter.getAsString(context, component, value);
            }
            return value.toString();
        }
        if (component instanceof CellEditor) {
            return ExporterUtils.getComponentValue(context, component.getFacet("output"));
        }
        if (component instanceof HtmlGraphicImage) {
            return (String)component.getAttributes().get("alt");
        }
        if (component instanceof OverlayPanel) {
            return "";
        }
        if (component instanceof RowToggler) {
            return "";
        }
        String value = component.toString();
        if (value != null) {
            return value.trim();
        }
        return "";
    }

    public static ColumnValue getColumnValue(FacesContext context, UITable table, UIColumn column, boolean joinComponents) {
        if (column.getExportValue() != null) {
            return ColumnValue.of(column.getExportValue());
        }
        if (column.getExportFunction() != null) {
            MethodExpression exportFunction = column.getExportFunction();
            return ColumnValue.of(exportFunction.invoke(context.getELContext(), new Object[]{column}));
        }
        if (LangUtils.isNotBlank(column.getField())) {
            String value = table.getConvertedFieldValue(context, column);
            return ColumnValue.of(value);
        }
        return ColumnValue.of(column.getChildren().stream().filter(UIComponent::isRendered).map(c -> ExporterUtils.getComponentValue(context, c)).filter(LangUtils::isNotBlank).limit(!joinComponents ? 1L : (long)column.getChildren().size()).collect(Collectors.joining(" ")));
    }

    public static String getComponentFacetValue(FacesContext context, UIComponent parent, String facetname) {
        UIComponent facet = parent.getFacet(facetname);
        if (FacetUtils.shouldRenderFacet(facet)) {
            if (facet instanceof UIPanel) {
                for (UIComponent child : facet.getChildren()) {
                    String value;
                    if (!child.isRendered() || (value = ComponentUtils.getValueToRender(context, child)) == null) continue;
                    return value;
                }
            } else {
                return ComponentUtils.getValueToRender(context, facet);
            }
        }
        return null;
    }

    public static ColumnValue getColumnFacetValue(FacesContext context, UIColumn column, TableExporter.ColumnType columnType) {
        ColumnValue columnValue = ColumnValue.EMPTY_VALUE;
        if (columnType == TableExporter.ColumnType.HEADER) {
            columnValue = ColumnValue.of(Optional.ofNullable(column.getExportHeaderValue()).orElseGet(column::getHeaderText));
        } else if (columnType == TableExporter.ColumnType.FOOTER) {
            columnValue = ColumnValue.of(Optional.ofNullable(column.getExportFooterValue()).orElseGet(column::getFooterText));
        }
        UIComponent facet = column.getFacet(columnType.facet());
        if (LangUtils.isBlank(columnValue.toString()) && FacetUtils.shouldRenderFacet(facet)) {
            columnValue = ColumnValue.of(ExporterUtils.getComponentValue(context, facet));
        }
        return columnValue;
    }

    public static String getColumnExportTag(FacesContext context, UIColumn column) {
        String columnTag = column.getExportTag();
        if (LangUtils.isBlank(columnTag)) {
            columnTag = ExporterUtils.getColumnFacetValue(context, column, TableExporter.ColumnType.HEADER).toString();
        }
        return EscapeUtils.forXmlTag(columnTag.toLowerCase());
    }
}

