/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.fileupload;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.el.MethodExpression;
import javax.faces.application.FacesMessage;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.validator.ValidatorException;
import org.primefaces.component.fileupload.FileUploadBase;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.event.FileUploadEvent;
import org.primefaces.event.FilesUploadEvent;
import org.primefaces.model.file.UploadedFile;
import org.primefaces.model.file.UploadedFiles;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.FileUploadUtils;
import org.primefaces.util.LocaleUtils;
import org.primefaces.util.MessageFactory;
import org.primefaces.validate.FileValidator;
import org.primefaces.virusscan.VirusException;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="fileupload/fileupload.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js"), @ResourceDependency(library="primefaces", name="fileupload/fileupload.js")})
public class FileUpload
extends FileUploadBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.FileUpload";
    public static final String CONTAINER_CLASS = "ui-fileupload ui-widget ui-fileupload-responsive";
    public static final String BUTTON_BAR_CLASS = "ui-fileupload-buttonbar ui-widget-header ui-corner-top";
    public static final String CONTENT_CLASS = "ui-fileupload-content ui-widget-content ui-corner-bottom";
    public static final String FILES_CLASS = "ui-fileupload-files";
    public static final String CHOOSE_BUTTON_CLASS = "ui-fileupload-choose";
    public static final String UPLOAD_BUTTON_CLASS = "ui-fileupload-upload";
    public static final String CANCEL_BUTTON_CLASS = "ui-fileupload-cancel";
    public static final String BUTTON_ICON_ONLY = "ui-fileupload-icon-only";
    public static final String CONTAINER_CLASS_SIMPLE = "ui-fileupload-simple ui-widget";
    public static final String FILENAME_CLASS = "ui-fileupload-filename";
    public static final String WITHDROPZONE_CLASS = "ui-fileupload-withdropzone";

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        MethodExpression me;
        super.broadcast(event);
        FacesContext facesContext = this.getFacesContext();
        if ((event instanceof FileUploadEvent || event instanceof FilesUploadEvent) && (me = this.getListener()) != null) {
            me.invoke(facesContext.getELContext(), new Object[]{event});
        }
    }

    protected void validateValue(FacesContext context, Object newValue) {
        super.validateValue(context, newValue);
        if (this.isValid() && ComponentUtils.isRequestSource((UIComponent)this, context)) {
            boolean hasFileValidator = Arrays.stream(this.getValidators()).anyMatch(v -> v instanceof FileValidator);
            if (!hasFileValidator) {
                try {
                    if (newValue instanceof UploadedFile) {
                        this.tryValidateFile((UploadedFile)newValue);
                    } else if (newValue instanceof UploadedFiles) {
                        this.tryValidateFiles(((UploadedFiles)newValue).getFiles());
                    } else if (newValue != null) {
                        throw new IllegalArgumentException("Argument of type '" + newValue.getClass().getName() + "' not supported");
                    }
                }
                catch (ValidatorException | VirusException e) {
                    this.setValid(false);
                    context.addMessage(this.getClientId(), e instanceof ValidatorException ? ((ValidatorException)((Object)e)).getFacesMessage() : new FacesMessage(FacesMessage.SEVERITY_ERROR, e.getMessage(), ""));
                }
            }
            if (this.isValid()) {
                if (newValue instanceof UploadedFile) {
                    int totalFilesCount = 0;
                    if ("advanced".equals(this.getMode())) {
                        Map params = context.getExternalContext().getRequestParameterMap();
                        totalFilesCount = Integer.parseInt((String)params.get(this.getClientId(context) + "_totalFilesCount"));
                    }
                    this.queueEvent(new FileUploadEvent((UIComponent)this, (UploadedFile)newValue, totalFilesCount));
                } else if (newValue instanceof UploadedFiles) {
                    this.queueEvent(new FilesUploadEvent((UIComponent)this, (UploadedFiles)newValue));
                }
            }
        }
    }

    protected void tryValidateFile(UploadedFile uploadedFile) throws ValidatorException {
        String accept;
        Long sizeLimit = this.getSizeLimit();
        PrimeApplicationContext appContext = PrimeApplicationContext.getCurrentInstance(this.getFacesContext());
        if (sizeLimit != null && uploadedFile.getSize() > sizeLimit) {
            throw new ValidatorException(MessageFactory.getFacesMessage("primefaces.FileValidator.SIZE_LIMIT", FacesMessage.SEVERITY_ERROR, uploadedFile.getFileName(), FileUploadUtils.formatBytes(sizeLimit, LocaleUtils.getCurrentLocale(this.getFacesContext()))));
        }
        String string = accept = this.isValidateContentType() ? this.getAccept() : null;
        if (!FileUploadUtils.isValidType(appContext, uploadedFile, this.getAllowTypes(), accept)) {
            throw new ValidatorException(MessageFactory.getFacesMessage("primefaces.FileValidator.ALLOW_TYPES", FacesMessage.SEVERITY_ERROR, uploadedFile.getFileName(), FileUploadUtils.formatAllowTypes(this.getAllowTypes())));
        }
        if (this.isVirusScan()) {
            FileUploadUtils.performVirusScan(this.getFacesContext(), uploadedFile);
        }
    }

    protected void tryValidateFiles(List<UploadedFile> files) {
        Integer fileLimit = this.getFileLimit();
        if (files != null && files.size() > fileLimit) {
            throw new ValidatorException(MessageFactory.getFacesMessage("primefaces.FileValidator.FILE_LIMIT", FacesMessage.SEVERITY_ERROR, fileLimit));
        }
        long totalPartSize = 0L;
        Long sizeLimit = this.getSizeLimit();
        for (UploadedFile file : files) {
            totalPartSize += file.getSize();
            this.tryValidateFile(file);
        }
        if (sizeLimit != null && totalPartSize > sizeLimit) {
            throw new ValidatorException(MessageFactory.getFacesMessage("primefaces.FileValidator.SIZE_LIMIT", FacesMessage.SEVERITY_ERROR, "*", FileUploadUtils.formatBytes(sizeLimit, LocaleUtils.getCurrentLocale(this.getFacesContext()))));
        }
    }
}

