/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.paginator;

import java.io.IOException;
import java.util.regex.Pattern;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.api.Pageable;
import org.primefaces.component.paginator.PaginatorElementRenderer;

public class CurrentPageReportRenderer
implements PaginatorElementRenderer {
    private static final Pattern PATTERN_CURRENT_PAGE = Pattern.compile("\\{currentPage\\}");
    private static final Pattern PATTERN_TOTAL_PAGES = Pattern.compile("\\{totalPages\\}");
    private static final Pattern PATTERN_TOTAL_RECORDS = Pattern.compile("\\{totalRecords\\}");
    private static final Pattern PATTERN_START_RECORD = Pattern.compile("\\{startRecord\\}");
    private static final Pattern PATTERN_END_RECORD = Pattern.compile("\\{endRecord\\}");

    @Override
    public void render(FacesContext context, Pageable pageable) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String template = pageable.getCurrentPageReportTemplate();
        int currentPage = pageable.getPage() + 1;
        int pageCount = pageable.getPageCount();
        if (pageCount == 0) {
            pageCount = 1;
        }
        String output = template;
        output = PATTERN_CURRENT_PAGE.matcher(output).replaceAll(Integer.toString(currentPage));
        output = PATTERN_TOTAL_PAGES.matcher(output).replaceAll(Integer.toString(pageCount));
        output = PATTERN_TOTAL_RECORDS.matcher(output).replaceAll(Integer.toString(pageable.getRowCount()));
        output = PATTERN_START_RECORD.matcher(output).replaceAll(Integer.toString(Math.min(pageable.getFirst() + 1, pageable.getRowCount())));
        output = PATTERN_END_RECORD.matcher(output).replaceAll(Integer.toString(Math.min(pageable.getFirst() + pageable.getRowsToRender(), pageable.getRowCount())));
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-paginator-current", null);
        writer.writeText((Object)output, null);
        writer.endElement("span");
    }
}

