/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.password;

import java.io.IOException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.password.Password;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;
import org.primefaces.validate.ClientValidator;

public class PasswordRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        Password password = (Password)component;
        if (!this.shouldDecode((UIInput)password)) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)password);
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(password.getClientId(context));
        if (submittedValue != null) {
            password.setSubmittedValue(submittedValue);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Password password = (Password)component;
        this.encodeMarkup(context, password);
        this.encodeScript(context, password);
    }

    protected void encodeScript(FacesContext context, Password password) throws IOException {
        boolean feedback = password.isFeedback();
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Password", password);
        wb.attr("unmaskable", password.isToggleMask(), false);
        if (feedback) {
            wb.attr("feedback", true).attr("inline", password.isInline()).attr("showEvent", password.getShowEvent(), null).attr("hideEvent", password.getHideEvent(), null).attr("promptLabel", password.getPromptLabel(), null).attr("weakLabel", password.getWeakLabel(), null).attr("goodLabel", password.getGoodLabel(), null).attr("strongLabel", password.getStrongLabel(), null);
        }
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, Password password) throws IOException {
        String valueToRender;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = password.getClientId(context);
        boolean toggleMask = password.isToggleMask();
        if (toggleMask) {
            writer.startElement("span", null);
            boolean isRTL = ComponentUtils.isRTL(context, password);
            String positionClass = this.getStyleClassBuilder(context).add("ui-password").add("ui-password-masked").add("ui-inputwrapper").add(isRTL, "ui-input-icon-left", "ui-input-icon-right").build();
            writer.writeAttribute("class", (Object)positionClass, null);
        }
        String inputClass = this.getStyleClassBuilder(context).add(!toggleMask, "ui-password").add(this.createStyleClass((UIInput)password, "ui-inputfield ui-widget ui-state-default ui-corner-all")).build();
        writer.startElement("input", (UIComponent)password);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("type", (Object)"password", null);
        writer.writeAttribute("class", (Object)inputClass, null);
        if (password.getStyle() != null) {
            writer.writeAttribute("style", (Object)password.getStyle(), null);
        }
        if (password.isIgnoreLastPass()) {
            writer.writeAttribute("data-lpignore", (Object)"true", null);
        }
        if (LangUtils.isNotBlank(valueToRender = ComponentUtils.getValueToRender(context, (UIComponent)password)) && password.isRedisplay()) {
            writer.writeAttribute("value", (Object)valueToRender, null);
        }
        this.renderAccessibilityAttributes(context, (UIInput)password);
        this.renderRTLDirection(context, password);
        this.renderPassThruAttributes(context, (UIComponent)password, HTML.INPUT_TEXT_ATTRS_WITHOUT_EVENTS);
        this.renderDomEvents(context, (UIComponent)password, HTML.INPUT_TEXT_EVENTS);
        this.renderValidationMetadata(context, (EditableValueHolder)password, new ClientValidator[0]);
        writer.endElement("input");
        if (toggleMask) {
            writer.startElement("i", null);
            writer.writeAttribute("id", (Object)(clientId + "_mask"), "id");
            writer.writeAttribute("class", (Object)"ui-password-icon", null);
            writer.endElement("i");
            writer.endElement("span");
        }
    }
}

