/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.timeline;

import java.io.IOException;
import java.io.Serializable;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.primefaces.PrimeFaces;
import org.primefaces.component.timeline.Timeline;
import org.primefaces.component.timeline.TimelineRenderer;
import org.primefaces.component.timeline.TimelineUpdater;
import org.primefaces.model.timeline.TimelineEvent;
import org.primefaces.model.timeline.TimelineGroup;
import org.primefaces.model.timeline.TimelineModel;
import org.primefaces.util.CalendarUtils;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.EscapeUtils;
import org.primefaces.util.FastStringWriter;

public class DefaultTimelineUpdater
extends TimelineUpdater
implements PhaseListener {
    private static final long serialVersionUID = 20130317L;
    private static final Logger LOGGER = Logger.getLogger(DefaultTimelineUpdater.class.getName());
    private String widgetVar;
    private List<CrudOperationData> crudOperationDatas;

    @Override
    public void add(TimelineEvent<?> event) {
        if (event == null) {
            return;
        }
        this.checkCrudOperationDataList();
        this.crudOperationDatas.add(new CrudOperationData(CrudOperation.ADD, event));
    }

    @Override
    public void update(TimelineEvent<?> event) {
        if (event == null) {
            return;
        }
        this.checkCrudOperationDataList();
        this.crudOperationDatas.add(new CrudOperationData(CrudOperation.UPDATE, event));
    }

    @Override
    public void delete(String id) {
        this.checkCrudOperationDataList();
        this.crudOperationDatas.add(new CrudOperationData(CrudOperation.DELETE, id));
    }

    @Override
    public void select(String id) {
        this.checkCrudOperationDataList();
        this.crudOperationDatas.add(new CrudOperationData(CrudOperation.SELECT, id));
    }

    @Override
    public void clear() {
        this.checkCrudOperationDataList();
        this.crudOperationDatas.add(new CrudOperationData(CrudOperation.CLEAR));
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    public void beforePhase(PhaseEvent event) {
        if (PhaseId.APPLY_REQUEST_VALUES.equals(event.getPhaseId())) {
            this.populateTimelineUpdater(event.getFacesContext());
        } else if (PhaseId.RENDER_RESPONSE.equals(event.getPhaseId())) {
            this.processCrudOperations(event.getFacesContext());
        }
    }

    private void populateTimelineUpdater(FacesContext context) {
        HashMap<String, DefaultTimelineUpdater> map = (HashMap<String, DefaultTimelineUpdater>)context.getAttributes().get(TimelineUpdater.class.getName());
        if (map == null) {
            map = new HashMap<String, DefaultTimelineUpdater>();
            context.getAttributes().put(TimelineUpdater.class.getName(), map);
        }
        if (!map.containsKey(this.widgetVar)) {
            map.put(this.widgetVar, this);
        }
    }

    private void processCrudOperations(FacesContext context) {
        if (this.crudOperationDatas == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        Timeline timeline = (Timeline)context.getViewRoot().findComponent(this.id);
        TimelineRenderer timelineRenderer = (TimelineRenderer)((Object)ComponentUtils.getUnwrappedRenderer(context, "org.primefaces.component", "org.primefaces.component.TimelineRenderer"));
        TimelineModel<Object, Object> model = timeline.getValue();
        List<TimelineGroup<Object>> groups = timelineRenderer.calculateGroupsFromModel(model);
        UIComponent groupFacet = timeline.getFacet("group");
        HashMap groupsContent = new HashMap();
        UIComponent eventTitleFacet = timeline.getFacet("eventTitle");
        ZoneId zoneId = CalendarUtils.calculateZoneId(timeline.getTimeZone());
        try (FastStringWriter fsw = new FastStringWriter();
             FastStringWriter fswHtml = new FastStringWriter();){
            Consumer<CrudOperationData> updateGroupIfNecessary = data -> {
                TimelineGroup foundGroup = null;
                if (data.getEvent().getGroup() != null) {
                    Integer orderGroup = null;
                    for (int i = 0; i < groups.size(); ++i) {
                        TimelineGroup group = (TimelineGroup)groups.get(i);
                        if (group.getId() == null || !group.getId().equals(data.getEvent().getGroup())) continue;
                        orderGroup = i;
                        foundGroup = group;
                        break;
                    }
                    if (foundGroup != null) {
                        orderGroup = model.getGroups() != null ? orderGroup : null;
                        sb.append(";PF('");
                        sb.append(this.widgetVar);
                        sb.append("').updateGroup(");
                        try {
                            sb.append(timelineRenderer.encodeGroup(context, fsw, fswHtml, timeline, groupFacet, groupsContent, foundGroup, orderGroup));
                        }
                        catch (IOException e) {
                            LOGGER.log(Level.WARNING, e, () -> "Timeline with id " + this.id + " could not be updated, at least one CRUD operation failed");
                        }
                        sb.append(")");
                    }
                }
            };
            boolean renderComponent = false;
            for (CrudOperationData crudOperationData : this.crudOperationDatas) {
                switch (crudOperationData.getCrudOperation()) {
                    case ADD: {
                        updateGroupIfNecessary.accept(crudOperationData);
                        sb.append(";PF('");
                        sb.append(this.widgetVar);
                        sb.append("').addEvent(");
                        sb.append(EscapeUtils.forCDATA(timelineRenderer.encodeEvent(context, fsw, fswHtml, timeline, eventTitleFacet, zoneId, groups, crudOperationData.getEvent())));
                        sb.append(")");
                        renderComponent = true;
                        break;
                    }
                    case UPDATE: {
                        updateGroupIfNecessary.accept(crudOperationData);
                        sb.append(";PF('");
                        sb.append(this.widgetVar);
                        sb.append("').changeEvent(");
                        sb.append(EscapeUtils.forCDATA(timelineRenderer.encodeEvent(context, fsw, fswHtml, timeline, eventTitleFacet, zoneId, groups, crudOperationData.getEvent())));
                        sb.append(")");
                        renderComponent = true;
                        break;
                    }
                    case DELETE: {
                        sb.append(";PF('");
                        sb.append(this.widgetVar);
                        sb.append("').deleteEvent(\"");
                        sb.append(EscapeUtils.forJavaScript(crudOperationData.calculateId()));
                        sb.append("\")");
                        renderComponent = true;
                        break;
                    }
                    case SELECT: {
                        sb.append(";PF('");
                        sb.append(this.widgetVar);
                        sb.append("').setSelection(\"");
                        sb.append(EscapeUtils.forJavaScript(crudOperationData.calculateId()));
                        sb.append("\")");
                        break;
                    }
                    case CLEAR: {
                        sb.append(";PF('");
                        sb.append(this.widgetVar);
                        sb.append("').deleteAllEvents()");
                    }
                }
            }
            if (renderComponent) {
                sb.append(";PF('");
                sb.append(this.widgetVar);
                sb.append("').renderTimeline()");
            }
            PrimeFaces.current().executeScript(sb.toString());
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, e, () -> "Timeline with id " + this.id + " could not be updated, at least one CRUD operation failed");
        }
    }

    public void afterPhase(PhaseEvent event) {
    }

    public String getWidgetVar() {
        return this.widgetVar;
    }

    public void setWidgetVar(String widgetVar) {
        this.widgetVar = widgetVar;
    }

    private void checkCrudOperationDataList() {
        if (this.crudOperationDatas == null) {
            this.crudOperationDatas = new ArrayList<CrudOperationData>();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultTimelineUpdater that = (DefaultTimelineUpdater)o;
        return !(this.widgetVar == null ? that.widgetVar != null : !this.widgetVar.equals(that.widgetVar));
    }

    public int hashCode() {
        return this.widgetVar != null ? this.widgetVar.hashCode() : 0;
    }

    static class CrudOperationData
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final CrudOperation crudOperation;
        private final TimelineEvent<?> event;
        private final String id;

        CrudOperationData(CrudOperation crudOperation) {
            this(crudOperation, null, null);
        }

        CrudOperationData(CrudOperation crudOperation, TimelineEvent<?> event) {
            this(crudOperation, event, event.getId());
        }

        CrudOperationData(CrudOperation crudOperation, String id) {
            this(crudOperation, null, id);
        }

        private CrudOperationData(CrudOperation crudOperation, TimelineEvent<?> event, String id) {
            this.crudOperation = crudOperation;
            this.event = event;
            this.id = id;
        }

        CrudOperation getCrudOperation() {
            return this.crudOperation;
        }

        TimelineEvent<?> getEvent() {
            return this.event;
        }

        String calculateId() {
            return this.id;
        }
    }

    static enum CrudOperation {
        ADD,
        UPDATE,
        DELETE,
        SELECT,
        CLEAR;

    }
}

