/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.timeline;

import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.primefaces.component.timeline.Timeline;
import org.primefaces.model.timeline.TimelineEvent;

public abstract class TimelineUpdater {
    protected String id;

    public static TimelineUpdater getCurrentInstance(String id) {
        FacesContext context = FacesContext.getCurrentInstance();
        Map map = (Map)context.getAttributes().get(TimelineUpdater.class.getName());
        if (map == null) {
            return null;
        }
        UIComponent timeline = context.getViewRoot().findComponent(id);
        if (!(timeline instanceof Timeline)) {
            throw new FacesException("Timeline component with Id " + id + " was not found");
        }
        TimelineUpdater timelineUpdater = (TimelineUpdater)map.get(((Timeline)timeline).resolveWidgetVar(context));
        if (timelineUpdater != null) {
            timelineUpdater.id = id;
        }
        return timelineUpdater;
    }

    public abstract void add(TimelineEvent<?> var1);

    public abstract void update(TimelineEvent<?> var1);

    public abstract void delete(String var1);

    public abstract void select(String var1);

    public abstract void clear();
}

