/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.treetable.export;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.export.ColumnValue;
import org.primefaces.component.export.ExporterOptions;
import org.primefaces.component.export.PDFOptions;
import org.primefaces.component.export.PDFOrientationType;
import org.primefaces.component.treetable.TreeTable;
import org.primefaces.component.treetable.export.TreeTableExporter;
import org.primefaces.util.IOUtils;
import org.primefaces.util.LangUtils;

public class TreeTablePDFExporter
extends TreeTableExporter<Document, PDFOptions> {
    private static final Logger LOGGER = Logger.getLogger(TreeTablePDFExporter.class.getName());
    private Font cellFont;
    private Font facetFont;
    private Color facetBgColor;
    private PdfPTable pdfTable;

    public TreeTablePDFExporter() {
        super(new PDFOptions());
    }

    @Override
    protected Document createDocument(FacesContext context) throws IOException {
        Document document = new Document();
        PDFOptions options = (PDFOptions)this.exportConfiguration.getOptions();
        if (options != null && PDFOrientationType.LANDSCAPE == options.getOrientation()) {
            document.setPageSize(PageSize.A4.rotate());
        }
        try {
            PdfWriter.getInstance((Document)document, (OutputStream)this.os());
        }
        catch (DocumentException e) {
            IOUtils.closeQuietly((AutoCloseable)document, e1 -> LOGGER.warning(e1.getMessage()));
            throw new IOException(e);
        }
        if (!document.isOpen()) {
            document.open();
        }
        String encoding = Objects.toString(this.exportConfiguration.getEncodingType(), "Identity-H");
        if (options != null) {
            this.applyFont(options.getFontName(), encoding);
            this.applyFacetOptions(options);
            this.applyCellOptions(options);
        } else {
            this.applyFont("Times", encoding);
        }
        return document;
    }

    @Override
    protected void exportTable(FacesContext context, TreeTable table, int index) throws IOException {
        try {
            if (index > 0) {
                Paragraph preface = new Paragraph();
                this.addEmptyLine(preface, 3);
                ((Document)this.document).add((Element)preface);
            }
            int columnsCount = this.getExportableColumns(table).size();
            this.pdfTable = new PdfPTable(columnsCount);
            super.exportTable(context, table, index);
            ((Document)this.document).add((Element)this.pdfTable);
        }
        catch (DocumentException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    protected void exportTabletFacetValue(FacesContext context, TreeTable table, String textValue) {
        int colspan = this.getExportableColumns(table).size();
        this.addFacetValue(1, colspan, ColumnValue.of(textValue));
    }

    @Override
    protected void exportColumnFacetValue(FacesContext context, TreeTable table, ColumnValue columnValue, int index) {
        this.addFacetValue(1, 1, columnValue);
    }

    @Override
    protected void exportColumnGroupFacetValue(FacesContext context, TreeTable table, UIColumn column, AtomicInteger colIndex, ColumnValue columnValue) {
        int rowSpan = column.getExportRowspan() != 0 ? column.getExportRowspan() : column.getRowspan();
        int colSpan = column.getExportColspan() != 0 ? column.getExportColspan() : column.getColspan();
        this.addFacetValue(rowSpan, colSpan, columnValue);
    }

    @Override
    protected void exportCellValue(FacesContext context, TreeTable table, UIColumn col, ColumnValue columnValue, int index) {
        PdfPCell cell = this.createCell(col, (Phrase)new Paragraph(columnValue.toString(), this.cellFont));
        this.addCell(this.pdfTable, cell);
    }

    @Override
    public String getContentType() {
        return "application/pdf";
    }

    @Override
    public String getFileExtension() {
        return ".pdf";
    }

    @Override
    protected Object[] getOnTableRenderArgs() {
        return new Object[]{this.document, this.pdfTable};
    }

    protected void addEmptyLine(Paragraph paragraph, int number) {
        for (int i = 0; i < number; ++i) {
            paragraph.add((Element)new Paragraph(" "));
        }
    }

    protected void addCell(PdfPTable table, PdfPCell cell) {
        table.addCell(cell);
    }

    protected void applyFacetOptions(ExporterOptions options) {
        String facetFontSize;
        String facetFontColor;
        String facetBackground = options.getFacetBgColor();
        if (facetBackground != null) {
            this.facetBgColor = Color.decode(facetBackground);
        }
        if ((facetFontColor = options.getFacetFontColor()) != null) {
            this.facetFont.setColor(Color.decode(facetFontColor));
        }
        if ((facetFontSize = options.getFacetFontSize()) != null) {
            this.facetFont.setSize((float)Integer.parseInt(facetFontSize));
        }
        String facetFontStyle = options.getFacetFontStyle();
        this.setFontStyle(this.facetFont, facetFontStyle);
    }

    protected void applyCellOptions(ExporterOptions options) {
        String cellFontSize;
        String cellFontColor = options.getCellFontColor();
        if (cellFontColor != null) {
            this.cellFont.setColor(Color.decode(cellFontColor));
        }
        if ((cellFontSize = options.getCellFontSize()) != null) {
            this.cellFont.setSize((float)Integer.parseInt(cellFontSize));
        }
        String cellFontStyle = options.getCellFontStyle();
        this.setFontStyle(this.cellFont, cellFontStyle);
    }

    protected void setFontStyle(Font cellFont, String cellFontStyle) {
        if (cellFontStyle != null) {
            if ("NORMAL".equalsIgnoreCase(cellFontStyle)) {
                cellFontStyle = "0";
            }
            if ("BOLD".equalsIgnoreCase(cellFontStyle)) {
                cellFontStyle = "1";
            }
            if ("ITALIC".equalsIgnoreCase(cellFontStyle)) {
                cellFontStyle = "2";
            }
            cellFont.setStyle(cellFontStyle);
        }
    }

    protected void applyFont(String fontName, String encoding) {
        String newFont = fontName;
        if (LangUtils.isBlank(newFont)) {
            newFont = "Times";
        }
        this.cellFont = FontFactory.getFont((String)newFont, (String)encoding, (boolean)true);
        this.facetFont = FontFactory.getFont((String)newFont, (String)encoding, (boolean)true, (float)12.0f, (int)1);
    }

    protected PdfPCell createCell(UIColumn column, Phrase phrase) {
        PdfPCell cell = new PdfPCell(phrase);
        return this.applyColumnAlignments(column, cell);
    }

    protected PdfPCell applyColumnAlignments(UIColumn column, PdfPCell cell) {
        String[] styles = new String[]{column.getStyle(), column.getStyleClass()};
        if (LangUtils.containsIgnoreCase(styles, "right")) {
            cell.setHorizontalAlignment(2);
        } else if (LangUtils.containsIgnoreCase(styles, "center")) {
            cell.setHorizontalAlignment(1);
        } else {
            cell.setHorizontalAlignment(0);
        }
        return cell;
    }

    protected void addFacetValue(int rowSpan, int colSpan, ColumnValue columnValue) {
        PdfPCell cell = new PdfPCell((Phrase)new Paragraph(columnValue.toString(), this.facetFont));
        if (this.facetBgColor != null) {
            cell.setBackgroundColor(this.facetBgColor);
        }
        if (rowSpan > 1) {
            cell.setVerticalAlignment(1);
            cell.setRowspan(rowSpan);
        }
        if (colSpan > 1) {
            cell.setHorizontalAlignment(1);
            cell.setColspan(colSpan);
        }
        this.addCell(this.pdfTable, cell);
    }
}

