/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.video;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.video.Video;
import org.primefaces.component.video.VideoType;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.shaded.commons.io.FilenameUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.LangUtils;

public class VideoRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Video media = (Video)component;
        String clientId = media.getClientId(context);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", (UIComponent)media);
        writer.writeAttribute("id", (Object)clientId, "id");
        this.renderPassThruAttributes(context, component, HTML.LABEL_ATTRS_WITHOUT_EVENTS);
        Object styleClass = media.getStyleClass();
        styleClass = styleClass == null ? "ui-media ui-video" : "ui-media ui-video " + (String)styleClass;
        writer.writeAttribute("class", styleClass, null);
        if (LangUtils.isNotBlank(media.getStyle())) {
            writer.writeAttribute("style", (Object)media.getStyle(), null);
        }
        this.encodeVideo(context, media);
        writer.endElement("div");
    }

    public void encodeVideo(FacesContext context, Video media) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = media.getClientId(context) + "_video";
        writer.startElement("video", null);
        writer.writeAttribute("id", (Object)clientId, "id");
        this.renderPassThruAttributes(context, (UIComponent)media, HTML.MEDIA_ATTRS_WITH_EVENTS);
        if (LangUtils.isNotBlank(media.getHeight())) {
            writer.writeAttribute("height", (Object)media.getHeight(), null);
        }
        if (LangUtils.isNotBlank(media.getWidth())) {
            writer.writeAttribute("width", (Object)media.getWidth(), null);
        }
        if (LangUtils.isNotBlank(media.getPreload())) {
            writer.writeAttribute("preload", (Object)media.getPreload(), null);
        }
        if (LangUtils.isNotBlank(media.getPoster())) {
            writer.writeAttribute("poster", (Object)media.getPoster(), null);
        }
        VideoType player = this.resolvePlayer(context, media);
        writer.startElement("source", null);
        writer.writeAttribute("src", (Object)media.resolveSource(context, media), null);
        writer.writeAttribute("type", (Object)player.getMediaType(), null);
        writer.endElement("source");
        this.renderChildren(context, (UIComponent)media);
        writer.endElement("video");
    }

    protected VideoType resolvePlayer(FacesContext context, Video media) {
        if (LangUtils.isNotBlank(media.getPlayer())) {
            return VideoType.valueOf(media.getPlayer().toUpperCase());
        }
        if (media.getValue() instanceof String) {
            String extension = FilenameUtils.getExtension((String)media.getValue());
            for (VideoType mediaType : VideoType.values()) {
                if (!mediaType.getFileExtension().equalsIgnoreCase(extension)) continue;
                return mediaType;
            }
        }
        throw new IllegalArgumentException("Cannot resolve mediaplayer for video component '" + media.getClientId(context) + "', cannot play source:" + media.getValue());
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

