/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.event;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.Behavior;
import javax.faces.context.FacesContext;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.Pageable;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.api.UIData;
import org.primefaces.component.api.UITree;
import org.primefaces.component.celleditor.CellEditor;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.treetable.TreeTable;
import org.primefaces.event.AbstractAjaxBehaviorEvent;
import org.primefaces.util.FacetUtils;

public class CellEditEvent<T>
extends AbstractAjaxBehaviorEvent {
    private static final long serialVersionUID = 1L;
    private T oldValue;
    private T newValue;
    private int rowIndex;
    private String rowKey;
    private UIColumn column;
    private Object rowData;

    public CellEditEvent(UIComponent component, Behavior behavior, int rowIndex, UIColumn column) {
        super(component, behavior);
        this.rowIndex = rowIndex;
        this.column = column;
        this.oldValue = this.resolveValue();
    }

    public CellEditEvent(UIComponent component, Behavior behavior, int rowIndex, UIColumn column, String rowKey) {
        this(component, behavior, rowIndex, column);
        this.rowKey = rowKey;
    }

    public CellEditEvent(UIComponent component, Behavior behavior, UIColumn column, String rowKey) {
        super(component, behavior);
        this.rowKey = rowKey;
        this.column = column;
        this.oldValue = this.resolveValue();
    }

    public T getOldValue() {
        return this.oldValue;
    }

    public T getNewValue() {
        if (this.newValue == null) {
            this.newValue = this.resolveValue();
        }
        return this.newValue;
    }

    public Object getRowData() {
        if (this.rowData == null) {
            this.rowData = this.resolveRowData();
        }
        return this.rowData;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public UIColumn getColumn() {
        return this.column;
    }

    public String getRowKey() {
        return this.rowKey;
    }

    private Object resolveRowData() {
        if (this.source instanceof UIData) {
            DataTable data = (DataTable)this.source;
            data.setRowModel(this.rowIndex);
            return data.getRowData();
        }
        if (this.source instanceof UITree) {
            TreeTable data = (TreeTable)this.source;
            data.setRowKey(data.getValue(), this.rowKey);
            return data.getRowNode();
        }
        return null;
    }

    private T resolveValue() {
        Pageable data;
        if (this.source instanceof UIData) {
            data = (DataTable)this.source;
            ((UIData)((Object)data)).setRowModel(this.rowIndex);
        } else if (this.source instanceof UITree) {
            data = (TreeTable)this.source;
            ((UITree)((Object)data)).setRowKey(((UITree)((Object)data)).getValue(), this.rowKey);
        }
        if (this.column.isDynamic()) {
            DynamicColumn dynamicColumn = (DynamicColumn)this.column;
            dynamicColumn.applyStatelessModel();
        }
        ArrayList value = null;
        for (UIComponent child : this.column.getChildren()) {
            if (!(child instanceof CellEditor)) continue;
            UIComponent inputFacet = child.getFacet("input");
            AtomicBoolean invoked = new AtomicBoolean(false);
            ArrayList values = new ArrayList(1);
            FacetUtils.invokeOnEditableValueHolder(FacesContext.getCurrentInstance(), inputFacet, (ctx, component) -> {
                values.add(((EditableValueHolder)component).getValue());
                invoked.set(true);
            });
            if (!invoked.get()) {
                throw new FacesException("No ValueHolder found inside the 'input' facet of the CellEditor!");
            }
            if (values.isEmpty()) continue;
            value = values.size() > 1 ? values : values.get(0);
        }
        return (T)value;
    }
}

