/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.metadata;

import java.util.Collections;
import java.util.Set;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.el.ValueReference;
import javax.faces.context.FacesContext;
import javax.validation.Validator;
import javax.validation.groups.Default;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.el.ValueExpressionAnalyzer;
import org.primefaces.util.LangUtils;

public class BeanValidationMetadataExtractor {
    private BeanValidationMetadataExtractor() {
    }

    public static Set<ConstraintDescriptor<?>> extractAllConstraintDescriptors(FacesContext context, PrimeApplicationContext applicationContext, ValueExpression ve) {
        PropertyDescriptor propertyDescriptor = BeanValidationMetadataExtractor.extractPropertyDescriptor(context, applicationContext, ve);
        if (propertyDescriptor != null) {
            return propertyDescriptor.getConstraintDescriptors();
        }
        return Collections.emptySet();
    }

    public static Set<ConstraintDescriptor<?>> extractDefaultConstraintDescriptors(FacesContext context, PrimeApplicationContext applicationContext, ValueExpression ve) {
        return BeanValidationMetadataExtractor.extractConstraintDescriptors(context, applicationContext, ve, Default.class);
    }

    public static Set<ConstraintDescriptor<?>> extractConstraintDescriptors(FacesContext context, PrimeApplicationContext applicationContext, ValueExpression ve, Class ... groups) {
        PropertyDescriptor propertyDescriptor = BeanValidationMetadataExtractor.extractPropertyDescriptor(context, applicationContext, ve);
        if (propertyDescriptor != null) {
            return propertyDescriptor.findConstraints().unorderedAndMatchingGroups(groups).getConstraintDescriptors();
        }
        return Collections.emptySet();
    }

    public static PropertyDescriptor extractPropertyDescriptor(FacesContext context, PrimeApplicationContext applicationContext, ValueExpression ve) {
        ELContext elContext;
        ValueReference vr;
        if (ve != null && (vr = ValueExpressionAnalyzer.getReference(elContext = context.getELContext(), ve)) != null) {
            Class unproxied;
            BeanDescriptor beanDescriptor;
            Validator validator = applicationContext.getValidator();
            Object base = vr.getBase();
            Object property = vr.getProperty();
            if (base != null && property != null && (beanDescriptor = validator.getConstraintsForClass(unproxied = LangUtils.getUnproxiedClass(base.getClass()))) != null) {
                return beanDescriptor.getConstraintsForProperty(property.toString());
            }
        }
        return null;
    }
}

