/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import org.primefaces.component.api.UITable;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.model.FilterMeta;
import org.primefaces.model.LazyDataModel;
import org.primefaces.model.SortMeta;
import org.primefaces.model.filter.FilterConstraint;
import org.primefaces.util.Callbacks;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LocaleUtils;
import org.primefaces.util.PropertyDescriptorResolver;
import org.primefaces.util.SortTableComparator;

public class DefaultLazyDataModel<T>
extends LazyDataModel<T> {
    private static final Logger LOGGER = Logger.getLogger(DefaultLazyDataModel.class.getName());
    private String rowKeyField;
    private FilterConstraint filter;
    private Sorter<T> sorter;
    private Callbacks.SerializableSupplier<List<T>> valuesSupplier;
    private Callbacks.SerializableFunction<T, Object> rowKeyProvider;
    private Callbacks.SerializablePredicate<T> skipFiltering;

    @Override
    public int count(Map<String, FilterMeta> filterBy) {
        List values = (List)this.valuesSupplier.get();
        List<T> filteredValues = this.filter(values, filterBy);
        return filteredValues.size();
    }

    @Override
    public List<T> load(int first, int pageSize, Map<String, SortMeta> sortBy, Map<String, FilterMeta> filterBy) {
        List values = (List)this.valuesSupplier.get();
        List<T> filteredValues = this.filter(values, filterBy);
        this.sort(filteredValues);
        if (pageSize == 0) {
            return filteredValues;
        }
        return filteredValues.stream().skip(first).limit(pageSize).collect(Collectors.toList());
    }

    protected void sort(List<T> values) {
        if (values == null || values.isEmpty()) {
            return;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        UIComponent source = UIComponent.getCurrentComponent((FacesContext)context);
        if (source instanceof UITable) {
            values.sort(SortTableComparator.comparingField(context, (UITable)source));
        }
        if (this.sorter != null) {
            values.sort(this.sorter);
        }
    }

    protected List<T> filter(List<T> values, Map<String, FilterMeta> filterBy) {
        if (values == null || values.isEmpty()) {
            return Collections.emptyList();
        }
        FacesContext context = FacesContext.getCurrentInstance();
        PropertyDescriptorResolver propResolver = PrimeApplicationContext.getCurrentInstance(context).getPropertyDescriptorResolver();
        Locale locale = LocaleUtils.getCurrentLocale(context);
        FilterMeta globalFilter = filterBy.get("globalFilter");
        boolean hasGlobalFilter = globalFilter != null && globalFilter.isActive() || this.filter != null;
        return values.stream().filter(obj -> {
            if (this.skipFiltering != null && this.skipFiltering.test(obj)) {
                return true;
            }
            boolean localMatch = true;
            boolean globalMatch = false;
            if (hasGlobalFilter) {
                if (globalFilter != null && globalFilter.isActive()) {
                    globalMatch = globalFilter.getConstraint().isMatching(context, obj, globalFilter.getFilterValue(), locale);
                }
                if (this.filter != null && !globalMatch) {
                    globalMatch = this.filter.isMatching(context, obj, null, locale);
                }
            }
            for (FilterMeta filterMeta : filterBy.values()) {
                if (filterMeta.getField() == null || filterMeta.getFilterValue() == null || filterMeta.isGlobalFilter()) continue;
                Object fieldValue = propResolver.getValue(obj, filterMeta.getField());
                Object filterValue = filterMeta.getFilterValue();
                Object convertedFilterValue = null;
                if (fieldValue != null) {
                    Class<?> filterValueClass = filterValue.getClass();
                    convertedFilterValue = filterValueClass.isArray() || Collection.class.isAssignableFrom(filterValueClass) ? filterValue : ComponentUtils.convertToType(filterValue, fieldValue.getClass(), LOGGER);
                }
                if (localMatch = filterMeta.getConstraint().isMatching(context, fieldValue, convertedFilterValue, locale)) continue;
                break;
            }
            boolean matches = localMatch;
            if (hasGlobalFilter) {
                matches = matches && globalMatch;
            }
            return matches;
        }).collect(Collectors.toList());
    }

    @Override
    public T getRowData(String rowKey) {
        List values = Objects.requireNonNullElseGet((List)this.valuesSupplier.get(), Collections::emptyList);
        for (Object obj : values) {
            if (!Objects.equals(rowKey, this.getRowKey(obj))) continue;
            return (T)obj;
        }
        return null;
    }

    @Override
    public String getRowKey(T obj) {
        return String.valueOf(this.rowKeyProvider.apply(obj));
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    @FunctionalInterface
    public static interface Sorter<T>
    extends Comparator<T>,
    Serializable {
    }

    public static class Builder<T> {
        private final DefaultLazyDataModel<T> model = new DefaultLazyDataModel();

        public Builder<T> valueSupplier(Callbacks.SerializableSupplier<List<T>> valuesSupplier) {
            this.model.valuesSupplier = valuesSupplier;
            return this;
        }

        public Builder<T> rowKeyField(String rowKey) {
            this.model.rowKeyField = rowKey;
            return this;
        }

        public Builder<T> rowKeyProvider(Callbacks.SerializableFunction<T, Object> rowKeyProvider) {
            this.model.rowKeyProvider = rowKeyProvider;
            return this;
        }

        public Builder<T> rowKeyConverter(Converter<T> rowKeyConverter) {
            this.model.rowKeyConverter = rowKeyConverter;
            return this;
        }

        public Builder<T> filter(FilterConstraint filter) {
            this.model.filter = filter;
            return this;
        }

        public Builder<T> skipFiltering(Callbacks.SerializablePredicate<T> skipFiltering) {
            this.model.skipFiltering = skipFiltering;
            return this;
        }

        public Builder<T> sorter(Sorter<T> sorter) {
            this.model.sorter = sorter;
            return this;
        }

        public DefaultLazyDataModel<T> build() {
            boolean requiresRowKeyProvider;
            Objects.requireNonNull(this.model.valuesSupplier, "Value supplier not set");
            boolean bl = requiresRowKeyProvider = this.model.rowKeyProvider == null && (this.model.rowKeyConverter != null || this.model.rowKeyField != null);
            if (requiresRowKeyProvider) {
                if (this.model.rowKeyConverter != null) {
                    this.model.rowKeyProvider = this.model::getRowKeyFromConverter;
                } else {
                    Objects.requireNonNull(this.model.rowKeyField, "rowKeyField is mandatory if no rowKeyProvider nor converter is provided");
                    PropertyDescriptorResolver propResolver = PrimeApplicationContext.getCurrentInstance(FacesContext.getCurrentInstance()).getPropertyDescriptorResolver();
                    this.model.rowKeyProvider = obj -> propResolver.getValue(obj, this.model.rowKeyField);
                }
            }
            return this.model;
        }
    }
}

