/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.primefaces.model.FilterMeta;
import org.primefaces.model.LazyDataModel;
import org.primefaces.model.SortMeta;

public class LazyDataModelIterator<T>
implements Iterator<T> {
    protected LazyDataModel<T> model;
    protected int index;
    protected Map<Integer, List<T>> pages;
    protected List<T> rows;
    protected Map<String, SortMeta> sortBy;
    protected Map<String, FilterMeta> filterBy;

    public LazyDataModelIterator(LazyDataModel<T> model) {
        this.model = model;
        this.index = -1;
        this.pages = new HashMap<Integer, List<T>>();
        this.sortBy = Collections.emptyMap();
        this.filterBy = Collections.emptyMap();
    }

    public LazyDataModelIterator(LazyDataModel<T> model, Map<String, SortMeta> sortBy, Map<String, FilterMeta> filterBy) {
        this(model);
        if (sortBy != null) {
            this.sortBy = sortBy;
        }
        if (filterBy != null) {
            this.filterBy = filterBy;
        }
    }

    @Override
    public boolean hasNext() {
        int nextIndex = this.index + 1;
        int pageSize = this.model.getPageSize();
        if (pageSize > 0) {
            int pageIndex;
            int pageNo = nextIndex / pageSize;
            if (!this.pages.containsKey(pageNo)) {
                List<T> page = this.model.load(nextIndex, pageSize, this.sortBy, this.filterBy);
                if (page == null || page.isEmpty()) {
                    return false;
                }
                this.pages.remove(pageNo - 1);
                this.pages.put(pageNo, page);
            }
            return (pageIndex = nextIndex % pageSize) < this.pages.get(pageNo).size();
        }
        if (this.rows == null) {
            this.rows = this.model.load(0, 0, this.sortBy, this.filterBy);
        }
        return nextIndex < this.rows.size();
    }

    @Override
    public T next() {
        ++this.index;
        int pageSize = this.model.getPageSize();
        if (pageSize > 0) {
            int pageNo = this.index / pageSize;
            int pageIndex = this.index % pageSize;
            List<T> page = this.pages.get(pageNo);
            if (page == null || pageIndex >= page.size()) {
                throw new NoSuchElementException();
            }
            return page.get(pageIndex);
        }
        if (this.rows == null) {
            this.rows = this.model.load(0, 0, this.sortBy, this.filterBy);
        }
        return this.rows.get(this.index);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

