/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model.diagram;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.primefaces.model.diagram.Connection;
import org.primefaces.model.diagram.DiagramModel;
import org.primefaces.model.diagram.Element;
import org.primefaces.model.diagram.ElementList;
import org.primefaces.model.diagram.connector.Connector;
import org.primefaces.model.diagram.endpoint.EndPoint;
import org.primefaces.model.diagram.overlay.Overlay;

public class DefaultDiagramModel
implements DiagramModel,
Serializable {
    private static final long serialVersionUID = 1L;
    private List<Element> elements = new ElementList();
    private List<Connection> connections = new ArrayList<Connection>();
    private Connector defaultConnector;
    private List<Overlay> defaultConnectionOverlays = new ArrayList<Overlay>();
    private boolean connectionsDetachable = true;
    private int maxConnections = 1;
    private boolean containment = true;

    @Override
    public List<Element> getElements() {
        return this.elements;
    }

    @Override
    public void addElement(Element element) {
        this.elements.add(element);
    }

    @Override
    public void removeElement(Element element) {
        this.elements.remove(element);
    }

    public void clear() {
        this.elements.clear();
    }

    @Override
    public void clearElements() {
        this.elements.clear();
    }

    @Override
    public List<Connection> getConnections() {
        return this.connections;
    }

    @Override
    public void connect(Connection connection) {
        this.connections.add(connection);
    }

    @Override
    public void disconnect(Connection connection) {
        this.connections.remove(connection);
    }

    @Override
    public Connector getDefaultConnector() {
        return this.defaultConnector;
    }

    public void setDefaultConnector(Connector defaultConnector) {
        this.defaultConnector = defaultConnector;
    }

    @Override
    public List<Overlay> getDefaultConnectionOverlays() {
        return this.defaultConnectionOverlays;
    }

    @Override
    public boolean isConnectionsDetachable() {
        return this.connectionsDetachable;
    }

    public void setConnectionsDetachable(boolean connectionsDetachable) {
        this.connectionsDetachable = connectionsDetachable;
    }

    @Override
    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    @Override
    public Element findElement(String id) {
        Element element = null;
        if (this.elements != null && !this.elements.isEmpty()) {
            for (int i = 0; i < this.elements.size(); ++i) {
                Element el = this.elements.get(i);
                if (!el.getId().equals(id)) continue;
                element = el;
                break;
            }
        }
        return element;
    }

    @Override
    public EndPoint findEndPoint(Element element, String id) {
        EndPoint endPoint = null;
        List<EndPoint> endPoints = element.getEndPoints();
        if (endPoints != null && !endPoints.isEmpty()) {
            for (int i = 0; i < endPoints.size(); ++i) {
                EndPoint ep = endPoints.get(i);
                if (!ep.getId().equals(id)) continue;
                endPoint = ep;
                break;
            }
        }
        return endPoint;
    }

    @Override
    public boolean isContainment() {
        return this.containment;
    }

    public void setContainment(boolean containment) {
        this.containment = containment;
    }
}

