/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.faces.FacesException;
import org.primefaces.model.file.UploadedFile;
import org.primefaces.shaded.commons.io.input.BoundedInputStream;
import org.primefaces.util.FileUploadUtils;
import org.primefaces.util.IOUtils;

public abstract class AbstractUploadedFile<T>
implements UploadedFile,
Serializable {
    private String filename;
    private byte[] cachedContent;
    private Long sizeLimit;
    private String webKitRelativePath;
    private transient T source;

    protected AbstractUploadedFile() {
    }

    protected AbstractUploadedFile(T source, String filename, Long sizeLimit, String webKitRelativePath) {
        this.source = source;
        this.filename = FileUploadUtils.requireValidFilename(filename);
        this.sizeLimit = sizeLimit;
        this.webKitRelativePath = webKitRelativePath;
    }

    @Override
    public String getFileName() {
        return this.filename;
    }

    @Override
    public String getWebkitRelativePath() {
        return this.webKitRelativePath;
    }

    public T getSource() {
        return this.source;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.sizeLimit == null ? this.getSourceInputStream() : new BoundedInputStream(this.getSourceInputStream(), this.sizeLimit);
    }

    @Override
    public byte[] getContent() {
        if (this.cachedContent != null) {
            return this.cachedContent;
        }
        try (InputStream is = this.getInputStream();){
            this.cachedContent = IOUtils.toByteArray(is);
        }
        catch (IOException ex) {
            throw new FacesException((Throwable)ex);
        }
        return this.cachedContent;
    }

    @Override
    public void write(String filePath) throws Exception {
        File file = new File(filePath, this.filename);
        FileUploadUtils.requireValidFilePath(file.getCanonicalPath(), true);
        this.write(file);
    }

    protected abstract InputStream getSourceInputStream() throws IOException;

    protected abstract void write(File var1) throws IOException;
}

