/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model.timeline;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.UUID;

public class TimelineEvent<T>
implements Serializable {
    private static final long serialVersionUID = 20130316L;
    private String id = UUID.randomUUID().toString();
    private T data;
    private LocalDateTime startDate;
    private LocalDateTime endDate;
    private Boolean editable;
    private Boolean editableTime;
    private Boolean editableGroup;
    private Boolean editableRemove;
    private String group;
    private String subgroup;
    private String title;
    private String styleClass;
    private String type;

    public String getId() {
        return this.id;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public LocalDateTime getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDateTime startDate) {
        this.checkStartDate(startDate);
        this.startDate = startDate;
    }

    public LocalDateTime getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDateTime endDate) {
        this.endDate = endDate;
    }

    public Boolean isEditable() {
        return this.editable;
    }

    public void setEditable(Boolean editable) {
        this.editable = editable;
        this.editableTime = editable;
        this.editableGroup = editable;
        this.editableRemove = editable;
    }

    public Boolean isEditableTime() {
        return this.editableTime;
    }

    public void setEditableTime(Boolean editableTime) {
        this.editableTime = editableTime;
    }

    public Boolean isEditableGroup() {
        return this.editableGroup;
    }

    public void setEditableGroup(Boolean editableGroup) {
        this.editableGroup = editableGroup;
    }

    public Boolean isEditableRemove() {
        return this.editableRemove;
    }

    public void setEditableRemove(Boolean editableRemove) {
        this.editableRemove = editableRemove;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getSubgroup() {
        return this.subgroup;
    }

    public void setSubgroup(String subgroup) {
        this.subgroup = subgroup;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static <T> Builder<T> builder(TimelineEvent<T> event) {
        Builder<T> builder = TimelineEvent.builder();
        builder.id(event.id);
        builder.data(event.data);
        builder.startDate(event.startDate);
        builder.endDate(event.endDate);
        builder.editable(event.editable);
        builder.editableTime(event.editableTime);
        builder.editableGroup(event.editableGroup);
        builder.editableRemove(event.editableRemove);
        builder.group(event.group);
        builder.subgroup(event.subgroup);
        builder.title(event.title);
        builder.styleClass(event.styleClass);
        builder.type(event.type);
        return builder;
    }

    public int hashCode() {
        int hash = 5;
        hash = 79 * hash + Objects.hashCode(this.id);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimelineEvent other = (TimelineEvent)obj;
        return Objects.equals(this.id, other.id);
    }

    public String toString() {
        return "TimelineEvent{id=" + this.id + ", data=" + this.data + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ", editable=" + this.editable + ", group='" + this.group + "', subgroup='" + this.subgroup + "', styleClass='" + this.styleClass + "'}";
    }

    private void checkStartDate(LocalDateTime startDate) {
        if (startDate == null) {
            throw new IllegalArgumentException("Event start date can not be null!");
        }
    }

    public static final class Builder<T> {
        private final TimelineEvent<T> event = new TimelineEvent();

        private Builder() {
        }

        public Builder<T> id(String id) {
            this.event.id = id;
            return this;
        }

        public Builder<T> data(T data) {
            this.event.setData(data);
            return this;
        }

        public Builder<T> startDate(LocalDateTime startDate) {
            this.event.setStartDate(startDate);
            return this;
        }

        public Builder<T> startDate(LocalDate startDate) {
            this.event.setStartDate(startDate.atStartOfDay());
            return this;
        }

        public Builder<T> endDate(LocalDateTime endDate) {
            this.event.setEndDate(endDate);
            return this;
        }

        public Builder<T> endDate(LocalDate endDate) {
            this.event.setEndDate(endDate.atStartOfDay());
            return this;
        }

        public Builder<T> editable(Boolean editable) {
            this.event.setEditable(editable);
            return this;
        }

        public Builder<T> group(String group) {
            this.event.setGroup(group);
            return this;
        }

        public Builder<T> subgroup(String subgroup) {
            this.event.setSubgroup(subgroup);
            return this;
        }

        public Builder<T> styleClass(String styleClass) {
            this.event.setStyleClass(styleClass);
            return this;
        }

        public Builder<T> title(String title) {
            this.event.setTitle(title);
            return this;
        }

        public Builder<T> type(String type) {
            this.event.setType(type);
            return this;
        }

        public Builder<T> editableTime(Boolean editableTime) {
            this.event.setEditableTime(editableTime);
            return this;
        }

        public Builder<T> editableGroup(Boolean editableGroup) {
            this.event.setEditableGroup(editableGroup);
            return this;
        }

        public Builder<T> editableRemove(Boolean editableRemove) {
            this.event.setEditableRemove(editableRemove);
            return this;
        }

        public TimelineEvent<T> build() {
            return this.event;
        }
    }
}

