/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.renderkit;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.component.ContextCallback;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.primefaces.component.api.InputHolder;
import org.primefaces.component.api.UINotification;
import org.primefaces.component.api.UINotifications;
import org.primefaces.expression.SearchExpressionUtils;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.CompositeUtils;
import org.primefaces.util.LangUtils;

public class UINotificationRenderer
extends CoreRenderer {
    protected boolean shouldRender(UINotification component, FacesMessage message, String severityName) {
        String severityLevel = component.getSeverity();
        return !(message.isRendered() && !component.isRedisplay() || severityLevel != null && !severityLevel.contains(severityName));
    }

    protected String getSeverityName(FacesMessage message) {
        int ordinal = message.getSeverity().getOrdinal();
        String severity = null;
        if (ordinal == FacesMessage.SEVERITY_INFO.getOrdinal()) {
            severity = "info";
        } else if (ordinal == FacesMessage.SEVERITY_ERROR.getOrdinal()) {
            severity = "error";
        } else if (ordinal == FacesMessage.SEVERITY_WARN.getOrdinal()) {
            severity = "warn";
        } else if (ordinal == FacesMessage.SEVERITY_FATAL.getOrdinal()) {
            severity = "fatal";
        }
        return severity;
    }

    protected String getClientSideSeverity(String severity) {
        if (severity == null) {
            return "all,error";
        }
        return severity;
    }

    protected boolean hasDisplayableMessage(UINotification component, UIComponent target, FacesContext context) {
        String clientId = target.getClientId(context);
        Iterator msgs = context.getMessages(clientId);
        while (msgs.hasNext()) {
            String severityName;
            FacesMessage msg = (FacesMessage)msgs.next();
            if (!this.shouldRender(component, msg, severityName = this.getSeverityName(msg))) continue;
            return true;
        }
        return false;
    }

    protected String getTooltipTargetId(UIComponent target, FacesContext context) {
        return target instanceof InputHolder ? ((InputHolder)target).getInputClientId() : target.getClientId(context);
    }

    public List<FacesMessage> collectFacesMessages(UINotifications uiMessages, FacesContext context) {
        ArrayList<FacesMessage> messages;
        block16: {
            block15: {
                int i;
                messages = null;
                String _for = uiMessages.getFor();
                if (this.isValueBlank(_for)) break block15;
                String forType = uiMessages.getForType();
                if (forType == null || "key".equals(forType)) {
                    String[] keys;
                    for (String key : keys = context.getApplication().getSearchExpressionHandler().splitExpressions(context, _for)) {
                        Iterator messagesIterator = context.getMessages(key);
                        while (messagesIterator.hasNext()) {
                            if (messages == null) {
                                messages = new ArrayList(5);
                            }
                            messages.add((FacesMessage)messagesIterator.next());
                        }
                    }
                }
                if (forType != null && !"expression".equals(forType)) break block16;
                List<UIComponent> forComponents = SearchExpressionUtils.contextlessResolveComponents(context, (UIComponent)uiMessages, _for, SearchExpressionUtils.HINTS_IGNORE_NO_RESULT);
                ArrayList<String> clientIds = new ArrayList<String>();
                for (i = 0; i < forComponents.size(); ++i) {
                    UIComponent forComponent = forComponents.get(i);
                    clientIds.add(forComponent.getClientId(context));
                    if (!CompositeUtils.isComposite(forComponent)) continue;
                    ContextCallback callback = (fc, comp) -> clientIds.add(comp.getClientId(fc));
                    CompositeUtils.invokeOnDeepestEditableValueHolder(context, forComponent, callback);
                }
                for (i = 0; i < clientIds.size(); ++i) {
                    String forComponentClientId = (String)clientIds.get(i);
                    if (_for.equals(forComponentClientId)) continue;
                    Iterator messagesIterator = context.getMessages(forComponentClientId);
                    while (messagesIterator.hasNext()) {
                        FacesMessage next = (FacesMessage)messagesIterator.next();
                        if (messages == null) {
                            messages = new ArrayList(5);
                        }
                        if (messages.contains(next)) continue;
                        messages.add(next);
                    }
                }
                break block16;
            }
            if (uiMessages.isGlobalOnly()) {
                Iterator messagesIterator = context.getMessages(null);
                while (messagesIterator.hasNext()) {
                    if (messages == null) {
                        messages = new ArrayList<FacesMessage>(5);
                    }
                    messages.add((FacesMessage)messagesIterator.next());
                }
            } else {
                Object[] ignores = uiMessages.getForIgnores() == null ? null : context.getApplication().getSearchExpressionHandler().splitExpressions(context, uiMessages.getForIgnores());
                Iterator keyIterator = context.getClientIdsWithMessages();
                while (keyIterator.hasNext()) {
                    String key = (String)keyIterator.next();
                    if (ignores != null && LangUtils.contains(ignores, key)) continue;
                    Iterator messagesIterator = context.getMessages(key);
                    while (messagesIterator.hasNext()) {
                        if (messages == null) {
                            messages = new ArrayList(5);
                        }
                        messages.add((FacesMessage)messagesIterator.next());
                    }
                }
            }
        }
        return messages;
    }
}

