/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.context.PrimeRequestContext;
import org.primefaces.util.LangUtils;

public class ResourceUtils {
    public static final String RENDERER_SCRIPT = "javax.faces.resource.Script";
    public static final String RENDERER_STYLESHEET = "javax.faces.resource.Stylesheet";
    public static final String RES_NOT_FOUND = "RES_NOT_FOUND";
    private static final Pattern RESOURCE_PATTERN = Pattern.compile("^#\\{resource\\['(.+)']}$");

    private ResourceUtils() {
    }

    public static String getResourceURL(FacesContext context, String value) {
        if (LangUtils.isBlank(value)) {
            return "";
        }
        if (value.contains("/javax.faces.resource")) {
            return value;
        }
        String url = context.getApplication().getViewHandler().getResourceURL(context, value);
        return context.getExternalContext().encodeResourceURL(url);
    }

    public static String encodeResourceURL(FacesContext context, String src, boolean cache) {
        return context.getExternalContext().encodeResourceURL(ResourceUtils.appendCacheBuster(src, cache));
    }

    public static String toBase64(FacesContext context, Resource resource) {
        try {
            return ResourceUtils.toBase64(context, resource.getInputStream(), resource.getContentType());
        }
        catch (IOException e) {
            throw new FacesException("Could not open InputStream from Resource[library=" + resource.getLibraryName() + ", name=" + resource.getResourceName() + "]", (Throwable)e);
        }
    }

    public static String toBase64(FacesContext context, InputStream is) {
        return ResourceUtils.toBase64(context, ResourceUtils.toByteArray(is), null);
    }

    public static String toBase64(FacesContext context, Consumer<OutputStream> writer, String contentType) {
        return ResourceUtils.toBase64(context, ResourceUtils.toByteArray(writer), contentType);
    }

    public static String toBase64(FacesContext context, InputStream is, String contentType) {
        return ResourceUtils.toBase64(context, ResourceUtils.toByteArray(is), contentType);
    }

    public static String toBase64(FacesContext context, byte[] bytes) {
        return ResourceUtils.toBase64(context, bytes, null);
    }

    public static String toBase64(FacesContext context, byte[] bytes, String contentType) {
        String base64 = Base64.getEncoder().withoutPadding().encodeToString(bytes);
        if (contentType == null) {
            if (base64.startsWith("R0lGOD")) {
                contentType = "image/gif";
            } else if (base64.startsWith("iVBORw")) {
                contentType = "image/png";
            } else if (base64.startsWith("/9j/")) {
                contentType = "image/jpeg";
            } else if (base64.startsWith("UklGR")) {
                contentType = "image/webp";
            }
        }
        return "data:" + contentType + ";base64," + base64;
    }

    public static byte[] toByteArray(Consumer<OutputStream> os) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        os.accept(buffer);
        return buffer.toByteArray();
    }

    public static byte[] toByteArray(InputStream is) {
        try {
            byte[] byArray;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            try {
                int nRead;
                byte[] data = new byte[16384];
                while ((nRead = is.read(data, 0, data.length)) != -1) {
                    buffer.write(data, 0, nRead);
                }
                buffer.flush();
                byArray = buffer.toByteArray();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        buffer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new FacesException("Could not read InputStream to byte[]", (Throwable)e);
                }
            }
            buffer.close();
            return byArray;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void addNoCacheControl(ExternalContext externalContext) {
        ResourceUtils.addNoCacheControl(externalContext, false);
    }

    public static void addNoCacheControl(ExternalContext externalContext, boolean store) {
        String cacheControl = "no-cache, no-store, must-revalidate";
        if (store) {
            cacheControl = "no-cache, must-revalidate";
        }
        externalContext.setResponseHeader("Cache-Control", cacheControl);
        externalContext.setResponseHeader("Pragma", "no-cache");
        externalContext.setResponseHeader("Expires", "0");
    }

    public static void addResponseCookie(FacesContext context, String name, String value, Map<String, Object> properties) {
        if (properties == null) {
            properties = new HashMap<String, Object>(3);
        }
        PrimeRequestContext requestContext = PrimeRequestContext.getCurrentInstance(context);
        PrimeApplicationContext applicationContext = requestContext.getApplicationContext();
        boolean isSecure = requestContext.isSecure() && applicationContext.getConfig().isCookiesSecure();
        boolean isJsf40OrHigher = applicationContext.getEnvironment().isAtLeastJsf40();
        if (isSecure) {
            properties.put("secure", true);
            if (isJsf40OrHigher) {
                properties.put("SameSite", applicationContext.getConfig().getCookiesSameSite());
            }
        } else if (isJsf40OrHigher) {
            properties.put("SameSite", "None");
        }
        context.getExternalContext().addResponseCookie(name, value, properties);
    }

    public static String appendCacheBuster(String url, boolean cache) {
        if (url == null) {
            return url;
        }
        url = (String)url + (((String)url).contains("?") ? "&" : "?");
        url = (String)url + "pfdrid_c=" + cache;
        if (!cache) {
            url = (String)url + "&uid=" + UUID.randomUUID().toString();
        }
        return url;
    }

    public static String getResourceRequestPath(FacesContext context, String resourceName) {
        Resource resource = context.getApplication().getResourceHandler().createResource(resourceName, "primefaces");
        return resource.getRequestPath();
    }

    public static void addComponentResource(FacesContext context, String name, String library, String target) {
        Application application = context.getApplication();
        UIComponent componentResource = application.createComponent("javax.faces.Output");
        componentResource.setRendererType(application.getResourceHandler().getRendererTypeForResourceName(name));
        componentResource.getAttributes().put("name", name);
        componentResource.getAttributes().put("library", library);
        componentResource.getAttributes().put("target", target);
        context.getViewRoot().addComponentResource(context, componentResource, target);
    }

    public static void addComponentResource(FacesContext context, String name, String library) {
        ResourceUtils.addComponentResource(context, name, library, "head");
    }

    public static void addComponentResource(FacesContext context, String name) {
        ResourceUtils.addComponentResource(context, name, "primefaces", "head");
    }

    public static boolean isScript(UIComponent component) {
        return RENDERER_SCRIPT.equals(component.getRendererType());
    }

    public static boolean isStylesheet(UIComponent component) {
        return RENDERER_STYLESHEET.equals(component.getRendererType());
    }

    public static String getResourceName(UIComponent component) {
        return (String)component.getAttributes().get("name");
    }

    public static String getResourceLibrary(UIComponent component) {
        return (String)component.getAttributes().get("library");
    }

    public static boolean isInline(UIComponent component) {
        if (component != null) {
            return LangUtils.isBlank(ResourceUtils.getResourceName(component)) && LangUtils.isBlank(ResourceUtils.getResourceLibrary(component));
        }
        return false;
    }

    public static String getMonitorKeyCookieName(FacesContext context, ValueExpression monitorKey) {
        String evaluated;
        Object monitorKeyCookieName = "primefaces.download" + context.getViewRoot().getViewId();
        monitorKeyCookieName = ((String)monitorKeyCookieName).replace('/', '_');
        monitorKeyCookieName = ((String)monitorKeyCookieName).substring(0, ((String)monitorKeyCookieName).lastIndexOf(46));
        if (monitorKey != null && LangUtils.isNotBlank(evaluated = (String)monitorKey.getValue(context.getELContext()))) {
            monitorKeyCookieName = (String)monitorKeyCookieName + "_" + evaluated;
        }
        return monitorKeyCookieName;
    }

    public static boolean isResourceNotFound(Resource resource) {
        return resource != null && (RES_NOT_FOUND.equals(resource.toString()) || RES_NOT_FOUND.equals(resource.getRequestPath()));
    }

    public static Resource evaluateResourceExpression(FacesContext facesContext, ValueExpression valueExpression) {
        String expressionString;
        Matcher matcher;
        Resource resource = null;
        if (valueExpression != null && (matcher = RESOURCE_PATTERN.matcher(expressionString = valueExpression.getExpressionString())).find()) {
            String[] resourceInfo = matcher.group(1).split(":");
            Application application = facesContext.getApplication();
            ResourceHandler resourceHandler = application.getResourceHandler();
            if (resourceInfo.length == 2) {
                String resourceLibrary = resourceInfo[0];
                String resourceName = resourceInfo[1];
                resource = resourceHandler.createResource(resourceName, resourceLibrary);
            } else {
                String resourceName = resourceInfo[0];
                resource = resourceHandler.createResource(resourceName);
            }
        }
        return !ResourceUtils.isResourceNotFound(resource) ? resource : null;
    }
}

