/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import java.security.Principal;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import javax.faces.context.FacesContext;

public final class SecurityUtils {
    private SecurityUtils() {
    }

    public static boolean ifGranted(String role) {
        return FacesContext.getCurrentInstance().getExternalContext().isUserInRole(role);
    }

    public static boolean ifAllGranted(Object value) {
        return SecurityUtils.convertRoles(value).allMatch(SecurityUtils::ifGranted);
    }

    public static boolean ifAnyGranted(Object value) {
        return SecurityUtils.convertRoles(value).anyMatch(SecurityUtils::ifGranted);
    }

    public static boolean ifNoneGranted(Object value) {
        return SecurityUtils.convertRoles(value).noneMatch(SecurityUtils::ifGranted);
    }

    public static String remoteUser() {
        return FacesContext.getCurrentInstance().getExternalContext().getRemoteUser();
    }

    public static Principal userPrincipal() {
        return FacesContext.getCurrentInstance().getExternalContext().getUserPrincipal();
    }

    static Stream<String> convertRoles(Object value) {
        Objects.requireNonNull(value, "Roles value can't be null");
        Stream<Object> results = null;
        results = value instanceof String ? Stream.of(((String)value).split(",")).map(String::trim) : (value instanceof Object[] ? Stream.of((Object[])value) : (value instanceof Collection ? ((Collection)value).stream() : Stream.of(value)));
        return results.map(Object::toString);
    }
}

