/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import java.text.Collator;
import java.util.Collection;
import java.util.Comparator;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.primefaces.component.api.UITable;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.model.SortMeta;
import org.primefaces.model.TreeNode;
import org.primefaces.util.PropertyDescriptorResolver;

public class SortTableComparator
implements Comparator<Object> {
    public static final BeanPropertyMapper SORT_BY_VE_MAPPER = new SortByVEMapper();
    public static final BeanPropertyMapper FIELD_MAPPER = new FieldMapper();
    public static final BeanPropertyMapper TREE_NODE_MAPPER = new TreeNodeSortByVEMapper();
    private final FacesContext context;
    private final Collection<SortMeta> sortBy;
    private final UITable<?> table;
    private final Locale locale;
    private final String var;
    private final Collator collator;
    private final BeanPropertyMapper mapper;
    private final AtomicInteger compareResult = new AtomicInteger(0);

    public SortTableComparator(FacesContext context, UITable<?> table, BeanPropertyMapper mapper) {
        this.context = context;
        this.table = table;
        this.sortBy = table.getActiveSortMeta().values();
        this.var = table.getVar();
        this.locale = table.resolveDataLocale(context);
        this.collator = Collator.getInstance(this.locale);
        this.mapper = Objects.requireNonNull(mapper, "mapper is necessary to extract property value");
    }

    @Override
    public int compare(Object o1, Object o2) {
        this.compareResult.set(0);
        for (SortMeta sortMeta : this.sortBy) {
            if (this.mapper.isValueExprBased() && sortMeta.isDynamic()) {
                this.table.invokeOnColumn(sortMeta.getColumnKey(), column -> this.compareResult.set(this.compareWithMapper(sortMeta, o1, o2)));
            } else {
                this.compareResult.set(this.compareWithMapper(sortMeta, o1, o2));
            }
            if (this.compareResult.get() == 0) continue;
            return this.compareResult.get();
        }
        return 0;
    }

    private int compareWithMapper(SortMeta sortMeta, Object o1, Object o2) {
        Object fv1 = this.mapper.map(this.context, this.var, sortMeta, o1);
        Object fv2 = this.mapper.map(this.context, this.var, sortMeta, o2);
        return SortTableComparator.compare(this.context, sortMeta, fv1, fv2, this.collator, this.locale);
    }

    public static int compare(FacesContext context, SortMeta sortMeta, Object value1, Object value2, Collator collator, Locale locale) {
        try {
            int result;
            if (sortMeta.getFunction() == null) {
                if (value1 == null && value2 == null) {
                    result = 0;
                } else if (value1 == null) {
                    result = sortMeta.getNullSortOrder();
                } else if (value2 == null) {
                    result = -1 * sortMeta.getNullSortOrder();
                } else if (value1 instanceof String && value2 instanceof String) {
                    if (sortMeta.isCaseSensitiveSort()) {
                        result = collator.compare(value1, value2);
                    } else {
                        String str1 = ((String)value1).toLowerCase(locale);
                        String str2 = ((String)value2).toLowerCase(locale);
                        result = collator.compare(str1, str2);
                    }
                } else {
                    result = ((Comparable)value1).compareTo(value2);
                }
            } else {
                result = (Integer)sortMeta.getFunction().invoke(context.getELContext(), new Object[]{value1, value2, sortMeta});
            }
            return sortMeta.getOrder().isAscending() ? result : -1 * result;
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }

    public static Comparator<Object> comparingSortByVE(FacesContext context, UITable<?> table) {
        return new SortTableComparator(context, table, SORT_BY_VE_MAPPER);
    }

    public static Comparator<Object> comparingField(FacesContext context, UITable<?> table) {
        return new SortTableComparator(context, table, FIELD_MAPPER);
    }

    public static Comparator<Object> comparingTreeNodeSortByVE(FacesContext context, UITable<?> table) {
        return new SortTableComparator(context, table, TREE_NODE_MAPPER);
    }

    public static interface BeanPropertyMapper {
        public boolean isValueExprBased();

        public Object map(FacesContext var1, String var2, SortMeta var3, Object var4);
    }

    public static class SortByVEMapper
    implements BeanPropertyMapper {
        @Override
        public boolean isValueExprBased() {
            return true;
        }

        @Override
        public Object map(FacesContext context, String var, SortMeta sortMeta, Object obj) {
            ValueExpression ve = sortMeta.getSortBy();
            context.getExternalContext().getRequestMap().put(var, obj);
            return ve.getValue(context.getELContext());
        }
    }

    public static class FieldMapper
    implements BeanPropertyMapper {
        @Override
        public boolean isValueExprBased() {
            return false;
        }

        @Override
        public Object map(FacesContext context, String var, SortMeta sortMeta, Object obj) {
            PropertyDescriptorResolver propResolver = PrimeApplicationContext.getCurrentInstance(context).getPropertyDescriptorResolver();
            return propResolver.getValue(obj, sortMeta.getField());
        }
    }

    public static class TreeNodeSortByVEMapper
    extends SortByVEMapper {
        @Override
        public Object map(FacesContext context, String var, SortMeta sortMeta, Object obj) {
            return super.map(context, var, sortMeta, ((TreeNode)obj).getData());
        }
    }
}

