/*
 * The MIT License
 *
 * Copyright (c) 2009-2025 PrimeTek Informatics
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package org.primefaces.component.photocam;

import org.primefaces.component.api.Widget;

import javax.faces.component.UIInput;

public abstract class PhotoCamBase extends UIInput implements Widget {

    public static final String COMPONENT_FAMILY = "org.primefaces.component";

    public static final String DEFAULT_RENDERER = "org.primefaces.component.PhotoCamRenderer";

    public enum PropertyKeys {

        widgetVar,
        style,
        styleClass,
        process,
        update,
        listener,
        width,
        height,
        photoWidth,
        photoHeight,
        format,
        jpegQuality,
        autoStart,
        device,
        onCameraError
    }

    public PhotoCamBase() {
        setRendererType(DEFAULT_RENDERER);
    }

    @Override
    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getWidgetVar() {
        return (String) getStateHelper().eval(PropertyKeys.widgetVar, null);
    }

    public void setWidgetVar(String widgetVar) {
        getStateHelper().put(PropertyKeys.widgetVar, widgetVar);
    }

    public String getStyle() {
        return (String) getStateHelper().eval(PropertyKeys.style, null);
    }

    public void setStyle(String style) {
        getStateHelper().put(PropertyKeys.style, style);
    }

    public String getStyleClass() {
        return (String) getStateHelper().eval(PropertyKeys.styleClass, null);
    }

    public void setStyleClass(String styleClass) {
        getStateHelper().put(PropertyKeys.styleClass, styleClass);
    }

    public String getProcess() {
        return (String) getStateHelper().eval(PropertyKeys.process, null);
    }

    public void setProcess(String process) {
        getStateHelper().put(PropertyKeys.process, process);
    }

    public String getUpdate() {
        return (String) getStateHelper().eval(PropertyKeys.update, null);
    }

    public void setUpdate(String update) {
        getStateHelper().put(PropertyKeys.update, update);
    }

    public javax.el.MethodExpression getListener() {
        return (javax.el.MethodExpression) getStateHelper().eval(PropertyKeys.listener, null);
    }

    public void setListener(javax.el.MethodExpression listener) {
        getStateHelper().put(PropertyKeys.listener, listener);
    }

    public int getWidth() {
        return (Integer) getStateHelper().eval(PropertyKeys.width, 320);
    }

    public void setWidth(int width) {
        getStateHelper().put(PropertyKeys.width, width);
    }

    public int getHeight() {
        return (Integer) getStateHelper().eval(PropertyKeys.height, 240);
    }

    public void setHeight(int height) {
        getStateHelper().put(PropertyKeys.height, height);
    }

    public int getPhotoWidth() {
        return (Integer) getStateHelper().eval(PropertyKeys.photoWidth, 320);
    }

    public void setPhotoWidth(int photoWidth) {
        getStateHelper().put(PropertyKeys.photoWidth, photoWidth);
    }

    public int getPhotoHeight() {
        return (Integer) getStateHelper().eval(PropertyKeys.photoHeight, 240);
    }

    public void setPhotoHeight(int photoHeight) {
        getStateHelper().put(PropertyKeys.photoHeight, photoHeight);
    }

    public String getFormat() {
        return (String) getStateHelper().eval(PropertyKeys.format, null);
    }

    public void setFormat(String format) {
        getStateHelper().put(PropertyKeys.format, format);
    }

    public int getJpegQuality() {
        return (Integer) getStateHelper().eval(PropertyKeys.jpegQuality, 90);
    }

    public void setJpegQuality(int jpegQuality) {
        getStateHelper().put(PropertyKeys.jpegQuality, jpegQuality);
    }

    public boolean isAutoStart() {
        return (Boolean) getStateHelper().eval(PropertyKeys.autoStart, true);
    }

    public void setAutoStart(boolean autoStart) {
        getStateHelper().put(PropertyKeys.autoStart, autoStart);
    }

    public String getDevice() {
        return (String) getStateHelper().eval(PropertyKeys.device, null);
    }

    public void setDevice(String device) {
        getStateHelper().put(PropertyKeys.device, device);
    }

    public String getOnCameraError() {
        return (String) getStateHelper().eval(PropertyKeys.onCameraError, null);
    }

    public void setOnCameraError(String onCameraError) {
        getStateHelper().put(PropertyKeys.onCameraError, onCameraError);
    }

}