/*
 * The MIT License
 *
 * Copyright (c) 2009-2025 PrimeTek Informatics
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package org.primefaces.model.diagram.endpoint;

import org.primefaces.model.diagram.overlay.Overlay;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public abstract class EndPoint implements Serializable {

    private static final long serialVersionUID = 1L;

    private String id;
    private EndPointAnchor anchor;
    private int maxConnections = 1;
    private String styleClass;
    private String hoverStyleClass;
    private String style;
    private String hoverStyle;
    private boolean source;
    private boolean target;
    private List<Overlay> overlays;
    private String scope;

    public EndPoint() {
        overlays = new ArrayList<>();
    }

    public EndPoint(EndPointAnchor anchor) {
        this();
        this.anchor = anchor;
    }

    public abstract String getType();

    public abstract String toJS(StringBuilder sb);

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public EndPointAnchor getAnchor() {
        return anchor;
    }

    public void setAnchor(EndPointAnchor anchor) {
        this.anchor = anchor;
    }

    public int getMaxConnections() {
        return maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public String getStyleClass() {
        return styleClass;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public String getHoverStyleClass() {
        return hoverStyleClass;
    }

    public void setHoverStyleClass(String hoverStyleClass) {
        this.hoverStyleClass = hoverStyleClass;
    }

    public boolean isSource() {
        return source;
    }

    public void setSource(boolean source) {
        this.source = source;
    }

    public boolean isTarget() {
        return target;
    }

    public void setTarget(boolean target) {
        this.target = target;
    }

    public String getStyle() {
        return style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getHoverStyle() {
        return hoverStyle;
    }

    public void setHoverStyle(String hoverStyle) {
        this.hoverStyle = hoverStyle;
    }

    public List<Overlay> getOverlays() {
        return overlays;
    }

    public void setOverlays(List<Overlay> overlays) {
        this.overlays = overlays;
    }

    public String getScope() {
        return scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        EndPoint endPoint = (EndPoint) o;
        return Objects.equals(id, endPoint.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }
}
