/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.application.resource;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.application.ResourceHandlerWrapper;
import javax.faces.context.FacesContext;
import org.primefaces.application.resource.DynamicContentHandler;
import org.primefaces.application.resource.DynamicContentType;
import org.primefaces.application.resource.PrimeResource;
import org.primefaces.application.resource.StreamedContentHandler;
import org.primefaces.component.barcode.BarcodeHandler;
import org.primefaces.util.LangUtils;

public class PrimeResourceHandler
extends ResourceHandlerWrapper {
    private static final Logger LOGGER = Logger.getLogger(PrimeResourceHandler.class.getName());
    private final Map<String, DynamicContentHandler> handlers = new HashMap<String, DynamicContentHandler>();

    public PrimeResourceHandler(ResourceHandler wrapped) {
        super(wrapped);
        this.handlers.put(DynamicContentType.STREAMED_CONTENT.toString(), new StreamedContentHandler());
        if (LangUtils.isClassAvailable("uk.org.okapibarcode.output.SvgRenderer")) {
            this.handlers.put(DynamicContentType.BARCODE.toString(), new BarcodeHandler());
            this.handlers.put(DynamicContentType.QR_CODE.toString(), new BarcodeHandler());
        }
    }

    public Resource createResource(String resourceName, String libraryName) {
        Resource resource = super.createResource(resourceName, libraryName);
        return this.wrapResource(resource, libraryName);
    }

    public Resource createResource(String resourceName, String libraryName, String contentType) {
        Resource resource = super.createResource(resourceName, libraryName, contentType);
        return this.wrapResource(resource, libraryName);
    }

    public void handleResourceRequest(FacesContext context) throws IOException {
        Map params = context.getExternalContext().getRequestParameterMap();
        String handlerType = (String)params.get("pfdrt");
        if (LangUtils.isBlank(handlerType)) {
            super.handleResourceRequest(context);
        } else {
            DynamicContentHandler handler = this.handlers.get(handlerType);
            if (handler == null) {
                LOGGER.log(Level.WARNING, "No dynamic resource handler registered for: [{0}]. Are you missing a dependency?", new Object[]{handlerType});
                super.handleResourceRequest(context);
            } else {
                handler.handle(context);
            }
        }
    }

    private Resource wrapResource(Resource resource, String libraryName) {
        if (resource != null && libraryName != null && libraryName.toLowerCase().startsWith("primefaces")) {
            return new PrimeResource(resource);
        }
        return resource;
    }
}

