/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.behavior.base;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.component.StateHelper;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.view.AttachedObjectHandler;
import javax.faces.view.AttachedObjectTarget;
import javax.faces.view.BehaviorHolderAttachedObjectHandler;
import javax.faces.view.BehaviorHolderAttachedObjectTarget;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagException;
import javax.faces.view.facelets.TagHandler;
import org.primefaces.behavior.base.AbstractBehavior;
import org.primefaces.behavior.base.BehaviorAttribute;
import org.primefaces.config.PrimeEnvironment;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.el.ValueExpressionStateHelper;
import org.primefaces.util.LangUtils;

public abstract class AbstractBehaviorHandler<E extends AbstractBehavior>
extends TagHandler
implements BehaviorHolderAttachedObjectHandler {
    protected static final String MOJARRA_ATTACHED_OBJECT_HANDLERS_KEY = "javax.faces.view.AttachedObjectHandlers";
    protected static final Method MYFACES_GET_COMPOSITION_CONTEXT_INSTANCE;
    protected static final Method MYFACES_ADD_ATTACHED_OBJECT_HANDLER;
    private static final Logger LOGGER;
    private final TagAttribute event = this.getAttribute("event");

    protected AbstractBehaviorHandler(TagConfig config) {
        super(config);
    }

    public void apply(FaceletContext faceletContext, UIComponent parent) throws IOException {
        if (!ComponentHandler.isNew((UIComponent)parent)) {
            return;
        }
        String eventName = this.getEventName();
        if (UIComponent.isCompositeComponent((UIComponent)parent)) {
            BeanInfo componentBeanInfo;
            boolean tagApplied = false;
            if (parent instanceof ClientBehaviorHolder) {
                this.applyAttachedObject(faceletContext, parent);
                tagApplied = true;
            }
            if (null == (componentBeanInfo = (BeanInfo)parent.getAttributes().get("javax.faces.component.BEANINFO_KEY"))) {
                throw new TagException(this.tag, "Composite component does not have BeanInfo attribute");
            }
            BeanDescriptor componentDescriptor = componentBeanInfo.getBeanDescriptor();
            if (null == componentDescriptor) {
                throw new TagException(this.tag, "Composite component BeanInfo does not have BeanDescriptor");
            }
            List targetList = (List)componentDescriptor.getValue("javax.faces.view.AttachedObjectTargets");
            if (null == targetList && !tagApplied) {
                throw new TagException(this.tag, "Composite component does not support behavior events");
            }
            boolean supportedEvent = false;
            if (targetList != null) {
                for (int i = 0; i < targetList.size(); ++i) {
                    AttachedObjectTarget target = (AttachedObjectTarget)targetList.get(i);
                    if (!(target instanceof BehaviorHolderAttachedObjectTarget)) continue;
                    BehaviorHolderAttachedObjectTarget behaviorTarget = (BehaviorHolderAttachedObjectTarget)target;
                    if ((null == eventName || !eventName.equals(behaviorTarget.getName())) && (null != eventName || !behaviorTarget.isDefaultEvent())) continue;
                    supportedEvent = true;
                    break;
                }
            }
            if (supportedEvent) {
                FacesContext context = FacesContext.getCurrentInstance();
                PrimeEnvironment environment = PrimeApplicationContext.getCurrentInstance(context).getEnvironment();
                if (environment.isMojarra()) {
                    this.addAttachedObjectHandlerToMojarra(environment, parent);
                } else {
                    this.addAttachedObjectHandlerToMyFaces(parent, faceletContext);
                }
            } else if (!tagApplied) {
                throw new TagException(this.tag, "Composite component does not support event " + eventName);
            }
        } else if (parent instanceof ClientBehaviorHolder) {
            this.applyAttachedObject(faceletContext, parent);
        } else {
            throw new TagException(this.tag, "Unable to attach behavior to non-ClientBehaviorHolder parent");
        }
    }

    public String getEventName() {
        if (this.event == null) {
            return null;
        }
        if (this.event.isLiteral()) {
            return this.event.getValue();
        }
        FaceletContext faceletContext = this.getFaceletContext(FacesContext.getCurrentInstance());
        ValueExpression expression = this.event.getValueExpression(faceletContext, String.class);
        return (String)expression.getValue((ELContext)faceletContext);
    }

    protected void setBehaviorAttribute(FaceletContext ctx, E behavior, TagAttribute attr, Class<?> type) {
        if (attr != null) {
            String attributeName = attr.getLocalName();
            StateHelper stateHelper = ((AbstractBehavior)((Object)behavior)).getStateHelper();
            if (!(stateHelper instanceof ValueExpressionStateHelper) || attr.isLiteral()) {
                stateHelper.put((Serializable)((Object)attributeName), attr.getObject(ctx, type));
                return;
            }
            ValueExpressionStateHelper veStateHelper = (ValueExpressionStateHelper)stateHelper;
            veStateHelper.setBinding(attributeName, attr.getValueExpression(ctx, type));
        }
    }

    protected FaceletContext getFaceletContext(FacesContext context) {
        FaceletContext faceletContext = (FaceletContext)context.getAttributes().get(FaceletContext.FACELET_CONTEXT_KEY);
        if (faceletContext == null) {
            faceletContext = (FaceletContext)context.getAttributes().get("com.sun.faces.facelets.FACELET_CONTEXT");
        }
        return faceletContext;
    }

    public void applyAttachedObject(FacesContext context, UIComponent parent) {
        FaceletContext faceletContext = this.getFaceletContext(context);
        this.applyAttachedObject(faceletContext, parent);
    }

    public void applyAttachedObject(FaceletContext faceletContext, UIComponent parent) {
        ClientBehaviorHolder holder = (ClientBehaviorHolder)parent;
        String eventName = this.getEventName();
        if (null == eventName) {
            eventName = holder.getDefaultEventName();
            if (null == eventName) {
                throw new TagException(this.tag, "Event attribute could not be determined: " + eventName);
            }
        } else {
            Collection eventNames = holder.getEventNames();
            if (!eventNames.contains(eventName)) {
                throw new TagException(this.tag, "Event:" + eventName + " is not supported.");
            }
        }
        Application application = faceletContext.getFacesContext().getApplication();
        AbstractBehavior behavior = (AbstractBehavior)application.createBehavior(this.getBehaviorId());
        this.init(faceletContext, behavior, eventName, parent);
        holder.addClientBehavior(eventName, (ClientBehavior)behavior);
    }

    public abstract String getBehaviorId();

    public String getFor() {
        return null;
    }

    protected void addAttachedObjectHandlerToMojarra(PrimeEnvironment environment, UIComponent component) {
        Map attrs = component.getAttributes();
        List result = (List)attrs.computeIfAbsent(MOJARRA_ATTACHED_OBJECT_HANDLERS_KEY, k -> new ArrayList(5));
        result.add(this);
    }

    protected void addAttachedObjectHandlerToMyFaces(UIComponent component, FaceletContext ctx) {
        try {
            Object faceletCompositionContextInstance = MYFACES_GET_COMPOSITION_CONTEXT_INSTANCE.invoke(null, ctx);
            MYFACES_ADD_ATTACHED_OBJECT_HANDLER.invoke(faceletCompositionContextInstance, new Object[]{component, this});
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Could not add AttachedObjectHandler to MyFaces!", ex);
        }
    }

    protected void init(FaceletContext ctx, E behavior, String eventName, UIComponent parent) {
        for (BehaviorAttribute attr : ((AbstractBehavior)((Object)behavior)).getAllAttributes()) {
            TagAttribute tag = this.getAttribute(attr.getName());
            this.setBehaviorAttribute(ctx, behavior, tag, attr.getExpectedType());
        }
    }

    static {
        LOGGER = Logger.getLogger(AbstractBehaviorHandler.class.getName());
        Class clazz = LangUtils.tryToLoadClassForName("org.apache.myfaces.view.facelets.FaceletCompositionContext");
        if (clazz != null) {
            MYFACES_GET_COMPOSITION_CONTEXT_INSTANCE = LangUtils.tryToLoadMethodForName(clazz, "getCurrentInstance", FaceletContext.class);
            MYFACES_ADD_ATTACHED_OBJECT_HANDLER = LangUtils.tryToLoadMethodForName(clazz, "addAttachedObjectHandler", UIComponent.class, AttachedObjectHandler.class);
        } else {
            MYFACES_GET_COMPOSITION_CONTEXT_INSTANCE = null;
            MYFACES_ADD_ATTACHED_OBJECT_HANDLER = null;
        }
    }
}

