/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.behavior.confirm;

import java.io.Serializable;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.context.FacesContext;
import org.primefaces.behavior.base.AbstractBehavior;
import org.primefaces.behavior.base.BehaviorAttribute;
import org.primefaces.component.api.Confirmable;
import org.primefaces.shaded.json.JSONObject;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.FacetUtils;

public class ConfirmBehavior
extends AbstractBehavior {
    public static final String BEHAVIOR_ID = "org.primefaces.behavior.ConfirmBehavior";

    public String getScript(ClientBehaviorContext behaviorContext) {
        FacesContext context = behaviorContext.getFacesContext();
        UIComponent component = behaviorContext.getComponent();
        if (this.isDisabled()) {
            if (component instanceof Confirmable) {
                ((Confirmable)component).setConfirmationScript(null);
            }
            return null;
        }
        String source = this.getSource();
        String type = JSONObject.quote(this.getType());
        String headerText = JSONObject.quote(this.getHeader());
        UIComponent messageFacetComponent = component.getFacet("confirmMessage");
        String messageText = FacetUtils.shouldRenderFacet(messageFacetComponent) ? JSONObject.quote(ComponentUtils.encodeComponent(messageFacetComponent, context)) : JSONObject.quote(this.getMessage());
        String beforeShow = JSONObject.quote(this.getBeforeShow());
        String yesButtonClass = JSONObject.quote(this.getYesButtonClass());
        String yesButtonLabel = JSONObject.quote(this.getYesButtonLabel());
        String yesButtonIcon = JSONObject.quote(this.getYesButtonIcon());
        String noButtonClass = JSONObject.quote(this.getNoButtonClass());
        String noButtonLabel = JSONObject.quote(this.getNoButtonLabel());
        String noButtonIcon = JSONObject.quote(this.getNoButtonIcon());
        String string = source = source == null ? component.getClientId(context) : source;
        if (component instanceof Confirmable) {
            String sourceProperty = source == null || "this".equals(source) ? "source:this" : "source:\"" + source + "\"";
            String icon = this.getIcon();
            String script = "PrimeFaces.confirm({" + sourceProperty + ",type:" + type + ",escape:" + this.isEscape() + ",header:" + headerText + ",message:" + messageText + ",yesButtonClass:" + yesButtonClass + ",yesButtonLabel:" + yesButtonLabel + ",yesButtonIcon:" + yesButtonIcon + ",noButtonClass:" + noButtonClass + ",noButtonLabel:" + noButtonLabel + ",noButtonIcon:" + noButtonIcon + ",icon:\"" + (icon == null ? "" : icon) + "\",beforeShow:" + beforeShow + "});return false;";
            ((Confirmable)component).setConfirmationScript(script);
            return null;
        }
        throw new FacesException("Component " + source + " is not a Confirmable. ConfirmBehavior can only be attached to components that implement " + Confirmable.class.getName() + " interface");
    }

    @Override
    protected BehaviorAttribute[] getAllAttributes() {
        return PropertyKeys.values();
    }

    public String getSource() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.source), null);
    }

    public void setSource(String source) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.source), (Object)source);
    }

    public String getType() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.type), (Object)"dialog");
    }

    public void setType(String type) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.type), (Object)type);
    }

    public String getHeader() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.header), null);
    }

    public void setHeader(String header) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.header), (Object)header);
    }

    public String getMessage() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.message), null);
    }

    public void setMessage(String message) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.message), (Object)message);
    }

    public String getIcon() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.icon), null);
    }

    public void setIcon(String icon) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.icon), (Object)icon);
    }

    public boolean isDisabled() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.disabled), (Object)Boolean.FALSE);
    }

    public void setDisabled(boolean disabled) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.disabled), (Object)disabled);
    }

    public String getBeforeShow() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.beforeShow), null);
    }

    public void setBeforeShow(String beforeShow) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.beforeShow), (Object)beforeShow);
    }

    public boolean isEscape() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.escape), (Object)Boolean.TRUE);
    }

    public void setEscape(boolean escape) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.escape), (Object)escape);
    }

    public String getYesButtonLabel() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.yesButtonLabel), null);
    }

    public void setYesButtonLabel(String yesButtonLabel) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.yesButtonLabel), (Object)yesButtonLabel);
    }

    public String getYesButtonClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.yesButtonClass), null);
    }

    public void setYesButtonClass(String yesButtonClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.yesButtonClass), (Object)yesButtonClass);
    }

    public String getYesButtonIcon() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.yesButtonIcon), null);
    }

    public void setYesButtonIcon(String yesButtonIcon) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.yesButtonIcon), (Object)yesButtonIcon);
    }

    public String getNoButtonLabel() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.noButtonLabel), null);
    }

    public void setNoButtonLabel(String noButtonLabel) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.noButtonLabel), (Object)noButtonLabel);
    }

    public String getNoButtonClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.noButtonClass), null);
    }

    public void setNoButtonClass(String noButtonClass) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.noButtonClass), (Object)noButtonClass);
    }

    public String getNoButtonIcon() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.noButtonIcon), null);
    }

    public void setNoButtonIcon(String noButtonIcon) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.noButtonIcon), (Object)noButtonIcon);
    }

    public static enum PropertyKeys implements BehaviorAttribute
    {
        source(String.class),
        type(String.class),
        header(String.class),
        message(String.class),
        icon(String.class),
        yesButtonLabel(String.class),
        yesButtonClass(String.class),
        yesButtonIcon(String.class),
        noButtonLabel(String.class),
        noButtonClass(String.class),
        noButtonIcon(String.class),
        disabled(Boolean.class),
        beforeShow(String.class),
        escape(Boolean.class);

        private final Class<?> expectedType;

        private PropertyKeys(Class<?> expectedType) {
            this.expectedType = expectedType;
        }

        @Override
        public Class<?> getExpectedType() {
            return this.expectedType;
        }
    }
}

