/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.accordionpanel;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.BehaviorEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.PrimeFaces;
import org.primefaces.component.accordionpanel.AccordionPanelBase;
import org.primefaces.component.accordionpanel.AccordionState;
import org.primefaces.component.tabview.Tab;
import org.primefaces.el.ValueExpressionAnalyzer;
import org.primefaces.event.TabChangeEvent;
import org.primefaces.event.TabCloseEvent;
import org.primefaces.event.TabEvent;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.MapBuilder;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js")})
public class AccordionPanel
extends AccordionPanelBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.AccordionPanel";
    public static final String CONTAINER_CLASS = "ui-accordion ui-widget ui-helper-reset ui-hidden-container";
    public static final String ACTIVE_TAB_HEADER_CLASS = "ui-accordion-header ui-helper-reset ui-state-default ui-state-active";
    public static final String TAB_HEADER_CLASS = "ui-accordion-header ui-helper-reset ui-state-default";
    public static final String TAB_HEADER_ICON_CLASS = "ui-icon ui-icon-triangle-1-e";
    public static final String TAB_HEADER_ICON_RTL_CLASS = "ui-icon ui-icon-triangle-1-w";
    public static final String ACTIVE_TAB_HEADER_ICON_CLASS = "ui-icon ui-icon-triangle-1-s";
    public static final String ACTIVE_TAB_CONTENT_CLASS = "ui-accordion-content ui-helper-reset ui-widget-content";
    public static final String INACTIVE_TAB_CONTENT_CLASS = "ui-accordion-content ui-helper-reset ui-widget-content ui-helper-hidden";
    private static final String DEFAULT_EVENT = "tabChange";
    private static final Map<String, Class<? extends BehaviorEvent>> BEHAVIOR_EVENT_MAPPING = MapBuilder.builder().put("tabChange", TabChangeEvent.class).put("tabClose", TabCloseEvent.class).build();
    private static final Collection<String> EVENT_NAMES = BEHAVIOR_EVENT_MAPPING.keySet();

    @Override
    public Map<String, Class<? extends BehaviorEvent>> getBehaviorEventMapping() {
        return BEHAVIOR_EVENT_MAPPING;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public String getDefaultEventName() {
        return DEFAULT_EVENT;
    }

    public boolean isContentLoadRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_contentLoad");
    }

    public Tab findTab(String tabClientId) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            UIComponent child = (UIComponent)this.getChildren().get(i);
            if (!child.getClientId().equals(tabClientId)) continue;
            return (Tab)child;
        }
        return null;
    }

    @Override
    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        if (ComponentUtils.isRequestSource((UIComponent)this, context) && event instanceof AjaxBehaviorEvent) {
            TabEvent changeEvent;
            Tab tab;
            Map params = context.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("javax.faces.behavior.event");
            String clientId = this.getClientId(context);
            boolean repeating = this.isRepeating();
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            String tabClientId = (String)params.get(clientId + "_currentTab");
            int tabindex = Integer.parseInt((String)params.get(clientId + "_tabindex"));
            if (repeating) {
                this.setIndex(tabindex);
            }
            Object data = repeating ? this.getIndexData() : null;
            Tab tab2 = tab = repeating ? this.getDynamicTab() : this.findTab(tabClientId);
            if (DEFAULT_EVENT.equals(eventName)) {
                changeEvent = new TabChangeEvent<Object>((UIComponent)this, behaviorEvent.getBehavior(), tab, data, eventName, tabindex);
            } else if ("tabClose".equals(eventName)) {
                changeEvent = new TabCloseEvent<Object>((UIComponent)this, behaviorEvent.getBehavior(), tab, data, eventName, tabindex);
            } else {
                throw new FacesException("Unsupported event: " + eventName);
            }
            changeEvent.setPhaseId(behaviorEvent.getPhaseId());
            super.queueEvent((FacesEvent)changeEvent);
            if (repeating) {
                this.setIndex(-1);
            }
        } else {
            super.queueEvent(event);
        }
    }

    @Override
    public void processUpdates(FacesContext context) {
        if (!this.isRendered()) {
            return;
        }
        super.processUpdates(context);
        ELContext elContext = this.getFacesContext().getELContext();
        ValueExpression expr = ValueExpressionAnalyzer.getExpression(elContext, this.getValueExpression(AccordionPanelBase.PropertyKeys.activeIndex.toString()), true);
        if (expr != null && !expr.isReadOnly(elContext)) {
            expr.setValue(elContext, (Object)this.getActiveIndex());
            this.resetActiveIndex();
        }
    }

    protected void resetActiveIndex() {
        this.getStateHelper().remove((Serializable)((Object)AccordionPanelBase.PropertyKeys.activeIndex));
    }

    @Override
    public void broadcast(FacesEvent event) throws AbortProcessingException {
        MethodExpression me;
        super.broadcast(event);
        if (event instanceof TabEvent && (me = this.getTabController()) != null) {
            boolean retVal = (Boolean)me.invoke(this.getFacesContext().getELContext(), new Object[]{event});
            PrimeFaces.current().ajax().addCallbackParam("access", retVal);
        }
    }

    @Override
    public void restoreMultiViewState() {
        AccordionState as = this.getMultiViewState(false);
        if (as != null) {
            this.setActiveIndex(as.getActiveIndex());
        }
    }

    @Override
    public AccordionState getMultiViewState(boolean create) {
        FacesContext fc = this.getFacesContext();
        String viewId = fc.getViewRoot().getViewId();
        return PrimeFaces.current().multiViewState().get(viewId, this.getClientId(fc), create, AccordionState::new);
    }

    @Override
    public void resetMultiViewState() {
        this.setActiveIndex(null);
    }
}

