/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.api;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitContextWrapper;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.column.Column;
import org.primefaces.component.columngroup.ColumnGroup;
import org.primefaces.component.columns.Columns;
import org.primefaces.component.patch.UIDataPatch;
import org.primefaces.model.LazyDataModel;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.ELUtils;

public class PrimeUIData
extends UIDataPatch {
    private static final Logger LOGGER = Logger.getLogger(PrimeUIData.class.getName());

    public boolean isLazy() {
        return ComponentUtils.eval(this.getStateHelper(), (Serializable)((Object)PropertyKeys.lazy), () -> {
            boolean lazy = false;
            FacesContext context = this.getFacesContext();
            try {
                Class<?> type = ELUtils.getType(context, this.getValueExpression("value"), () -> ((PrimeUIData)this).getValue());
                if (type == null) {
                    if (LOGGER.isLoggable(Level.WARNING) && context.isProjectStage(ProjectStage.Development)) {
                        LOGGER.warning("Unable to automatically determine the `lazy` attribute, fallback to false. Either define the `lazy` attribute on the component or make sure the `value` attribute doesn't resolve to `null`. clientId: " + this.getClientId());
                    }
                } else {
                    lazy = LazyDataModel.class.isAssignableFrom(type);
                }
            }
            catch (Exception e) {
                LOGGER.severe("Exception occurred while determining the `lazy` attribute, fallback to false. To prevent this error set the `lazy` property directly on the component. Error: " + e.getMessage() + ". clientId: " + this.getClientId());
            }
            this.setLazy(lazy);
            return lazy;
        });
    }

    public void setLazy(boolean lazy) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.lazy), (Object)lazy);
    }

    public String getRowIndexVar() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.rowIndexVar), null);
    }

    public void setRowIndexVar(String rowIndexVar) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.rowIndexVar), (Object)rowIndexVar);
    }

    @Override
    protected void iterate(FacesContext context, PhaseId phaseId) {
        this.processFacets(context, phaseId);
        if (this.requiresColumns()) {
            this.processColumnFacets(context, phaseId);
        }
        if (this.shouldSkipChildren(context)) {
            return;
        }
        this.setRowIndex(-1);
        this.processChildren(context, phaseId);
        this.setRowIndex(-1);
    }

    protected void processFacets(FacesContext context, PhaseId phaseId) {
        if (this.getFacetCount() > 0) {
            for (UIComponent facet : this.getFacets().values()) {
                this.process(context, facet, phaseId);
            }
        }
    }

    protected void processColumnFacets(FacesContext context, PhaseId phaseId) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            UIComponent child = (UIComponent)this.getChildren().get(i);
            if (!child.isRendered() || child.getFacetCount() <= 0) continue;
            for (UIComponent facet : child.getFacets().values()) {
                this.process(context, facet, phaseId);
            }
        }
    }

    protected boolean shouldProcessChild(FacesContext context, int rowIndex, PhaseId phaseId) {
        return true;
    }

    protected void processChildren(FacesContext context, PhaseId phaseId) {
        int first = this.getFirst();
        int rows = this.getRows();
        int last = rows == 0 ? this.getRowCount() : first + rows;
        List<UIComponent> iterableChildren = null;
        for (int rowIndex = first; rowIndex < last; ++rowIndex) {
            this.setRowIndex(rowIndex);
            if (!this.isRowAvailable()) break;
            if (!this.shouldProcessChild(context, rowIndex, phaseId)) continue;
            if (iterableChildren == null) {
                iterableChildren = this.getIterableChildren();
            }
            for (int i = 0; i < iterableChildren.size(); ++i) {
                UIComponent child = iterableChildren.get(i);
                if (!child.isRendered()) continue;
                if (child instanceof Column) {
                    for (UIComponent grandkid : child.getChildren()) {
                        this.process(context, grandkid, phaseId);
                    }
                    continue;
                }
                this.process(context, child, phaseId);
            }
        }
    }

    protected void process(FacesContext context, UIComponent component, PhaseId phaseId) {
        if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
            component.processDecodes(context);
        } else if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
            component.processValidators(context);
        } else if (phaseId == PhaseId.UPDATE_MODEL_VALUES) {
            component.processUpdates(context);
        }
    }

    @Override
    protected void setRowIndexWithoutRowStatePreserved(int rowIndex) {
        this.saveDescendantState();
        this.setRowModel(rowIndex);
        this.restoreDescendantState();
    }

    public void setRowModel(int rowIndex) {
        String var;
        this.getStateHelper().put((Serializable)((Object)UIDataPatch.PropertyKeys.rowIndex), (Object)rowIndex);
        this.getDataModel().setRowIndex(rowIndex);
        if (rowIndex == -1) {
            this.setDataModel(null);
        }
        if ((var = this.getVar()) != null) {
            String rowIndexVar = this.getRowIndexVar();
            Map requestMap = this.getFacesContext().getExternalContext().getRequestMap();
            if (rowIndex == -1) {
                this.oldVar = requestMap.remove(var);
                if (rowIndexVar != null) {
                    requestMap.remove(rowIndexVar);
                }
            } else if (this.isRowAvailable()) {
                requestMap.put(var, this.getRowData());
                if (rowIndexVar != null) {
                    requestMap.put(rowIndexVar, rowIndex);
                }
            } else {
                requestMap.remove(var);
                if (rowIndexVar != null) {
                    requestMap.put(rowIndexVar, rowIndex);
                }
                if (this.oldVar != null) {
                    requestMap.put(var, this.oldVar);
                    this.oldVar = null;
                }
            }
        }
    }

    @Override
    protected void saveDescendantState() {
        FacesContext context = this.getFacesContext();
        if (this.getChildCount() > 0) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                UIComponent kid = (UIComponent)this.getChildren().get(i);
                this.saveDescendantState(kid, context);
            }
        }
        if (this.getFacetCount() > 0) {
            for (UIComponent facet : this.getFacets().values()) {
                this.saveDescendantState(facet, context);
            }
        }
    }

    @Override
    protected void restoreDescendantState() {
        FacesContext context = this.getFacesContext();
        if (this.getChildCount() > 0) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                UIComponent kid = (UIComponent)this.getChildren().get(i);
                this.restoreDescendantState(kid, context);
            }
        }
        if (this.getFacetCount() > 0) {
            for (UIComponent facet : this.getFacets().values()) {
                this.restoreDescendantState(facet, context);
            }
        }
    }

    protected boolean shouldSkipChildren(FacesContext context) {
        return false;
    }

    @Override
    public boolean visitTree(VisitContext context, VisitCallback callback) {
        return super.visitTree((VisitContext)new VisitContextImpl(context), callback);
    }

    @Override
    protected boolean visitColumnsAndColumnFacets(VisitContext context, VisitCallback callback, boolean visitRows) {
        if (!this.requiresColumns()) {
            return false;
        }
        if (visitRows) {
            this.setRowIndex(-1);
        }
        if (this.getChildCount() > 0) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                UIComponent child = (UIComponent)this.getChildren().get(i);
                VisitResult result = context.invokeVisitCallback(child, callback);
                if (result == VisitResult.COMPLETE) {
                    return true;
                }
                if (result == VisitResult.REJECT) continue;
                if (child instanceof UIColumn) {
                    if (child.getFacetCount() <= 0) continue;
                    if (child instanceof Columns) {
                        Columns columns = (Columns)child;
                        for (int j = 0; j < columns.getRowCount(); ++j) {
                            columns.setRowIndex(j);
                            boolean value = this.visitColumnFacets(context, callback, child);
                            if (!value) continue;
                            return true;
                        }
                        columns.setRowIndex(-1);
                        continue;
                    }
                    boolean value = this.visitColumnFacets(context, callback, child);
                    if (!value) continue;
                    return true;
                }
                if (!(child instanceof ColumnGroup)) continue;
                this.visitColumnGroup(context, callback, (ColumnGroup)child);
            }
        }
        return false;
    }

    protected boolean visitColumnGroup(VisitContext context, VisitCallback callback, ColumnGroup group) {
        if (group.getChildCount() > 0) {
            for (int i = 0; i < group.getChildCount(); ++i) {
                UIComponent row = (UIComponent)group.getChildren().get(i);
                if (row.getChildCount() <= 0) continue;
                for (int j = 0; j < row.getChildCount(); ++j) {
                    UIComponent col = (UIComponent)row.getChildren().get(j);
                    if (col instanceof Column) {
                        boolean value = this.visitColumnFacets(context, callback, col);
                        if (!value) continue;
                        return true;
                    }
                    if (!(col instanceof Columns) || col.getFacetCount() <= 0) continue;
                    Columns columns = (Columns)col;
                    for (int k = 0; k < columns.getRowCount(); ++k) {
                        columns.setRowIndex(k);
                        boolean value = this.visitColumnFacets(context, callback, (UIComponent)columns);
                        if (!value) continue;
                        columns.setRowIndex(-1);
                        return true;
                    }
                    columns.setRowIndex(-1);
                }
            }
        }
        return false;
    }

    protected boolean visitColumnFacets(VisitContext context, VisitCallback callback, UIComponent component) {
        if (component.getFacetCount() > 0) {
            for (UIComponent columnFacet : component.getFacets().values()) {
                if (!columnFacet.visitTree(context, callback)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean visitRows(VisitContext context, VisitCallback callback, boolean visitRows) {
        if (!(context instanceof VisitContextImpl)) {
            throw new FacesException();
        }
        boolean requiresColumns = this.requiresColumns();
        int processed = 0;
        int rowIndex = 0;
        int rows = 0;
        if (visitRows) {
            rowIndex = this.getFirst() - 1;
            rows = this.getRows();
        }
        do {
            if (visitRows) {
                if (rows > 0 && ++processed > rows) break;
                this.setRowIndex(++rowIndex);
                if (!this.isRowAvailable()) break;
            }
            if (this.getChildCount() <= 0) continue;
            for (int i = 0; i < this.getChildCount(); ++i) {
                UIComponent kid = (UIComponent)this.getChildren().get(i);
                if (((VisitContextImpl)context).isRejected(kid)) continue;
                if (requiresColumns) {
                    if (kid instanceof Columns) {
                        Columns columns = (Columns)kid;
                        for (int j = 0; j < columns.getRowCount(); ++j) {
                            columns.setRowIndex(j);
                            boolean value = this.visitColumnContent(context, callback, (UIComponent)columns);
                            if (!value) continue;
                            columns.setRowIndex(-1);
                            return true;
                        }
                        columns.setRowIndex(-1);
                        continue;
                    }
                    boolean value = this.visitColumnContent(context, callback, kid);
                    if (!value) continue;
                    return true;
                }
                if (!kid.visitTree(context, callback)) continue;
                return true;
            }
        } while (visitRows);
        return false;
    }

    protected boolean visitColumnContent(VisitContext context, VisitCallback callback, UIComponent component) {
        if (component.getChildCount() > 0) {
            for (int i = 0; i < component.getChildCount(); ++i) {
                UIComponent grandkid = (UIComponent)component.getChildren().get(i);
                if (!grandkid.visitTree(context, callback)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean requiresColumns() {
        return false;
    }

    protected List<UIComponent> getIterableChildren() {
        return this.getChildren();
    }

    @Override
    protected Boolean isNestedWithinIterator() {
        if (this.isNested == null) {
            this.isNested = ComponentUtils.isNestedWithinIterator((UIComponent)this);
        }
        return this.isNested;
    }

    public static enum PropertyKeys {
        rowIndexVar,
        lazy;

    }

    private static class VisitContextImpl
    extends VisitContextWrapper {
        private Set<UIComponent> rejectedChildren;

        public VisitContextImpl(VisitContext wrapped) {
            super(wrapped);
        }

        public VisitResult invokeVisitCallback(UIComponent component, VisitCallback callback) {
            VisitResult result = super.invokeVisitCallback(component, callback);
            if (result == VisitResult.REJECT) {
                if (this.rejectedChildren == null) {
                    this.rejectedChildren = new HashSet<UIComponent>();
                }
                this.rejectedChildren.add(component);
            }
            return result;
        }

        public boolean isRejected(UIComponent component) {
            return this.rejectedChildren != null && this.rejectedChildren.contains(component);
        }
    }
}

