/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.autocomplete;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.el.MethodExpression;
import javax.faces.FacesException;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.component.api.AbstractPrimeHtmlInputText;
import org.primefaces.component.autocomplete.AutoCompleteBase;
import org.primefaces.component.column.Column;
import org.primefaces.event.AutoCompleteEvent;
import org.primefaces.event.SelectEvent;
import org.primefaces.event.UnselectEvent;
import org.primefaces.model.FilterMeta;
import org.primefaces.model.LazyDataModel;
import org.primefaces.model.MatchMode;
import org.primefaces.model.SortMeta;
import org.primefaces.model.SortOrder;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LangUtils;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js")})
public class AutoComplete
extends AutoCompleteBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.AutoComplete";
    public static final String STYLE_CLASS = "ui-autocomplete";
    public static final String MULTIPLE_STYLE_CLASS = "ui-autocomplete ui-autocomplete-multiple";
    public static final String DROPDOWN_SYLE_CLASS = "ui-autocomplete-dd";
    public static final String INPUT_CLASS = "ui-autocomplete-input ui-inputfield ui-widget ui-state-default";
    public static final String INPUT_WITH_DROPDOWN_CLASS = "ui-autocomplete-input ui-autocomplete-dd-input ui-inputfield ui-widget ui-state-default";
    public static final String DROPDOWN_CLASS = "ui-autocomplete-dropdown ui-button ui-widget ui-state-default ui-button-icon-only";
    public static final String PANEL_CLASS = "ui-autocomplete-panel ui-widget-content ui-helper-hidden ui-shadow ui-input-overlay";
    public static final String LIST_CLASS = "ui-autocomplete-items ui-autocomplete-list ui-widget-content ui-widget ui-helper-reset";
    public static final String TABLE_CLASS = "ui-autocomplete-items ui-autocomplete-table ui-widget-content ui-widget ui-helper-reset";
    public static final String ITEM_CLASS = "ui-autocomplete-item ui-autocomplete-list-item";
    public static final String ROW_CLASS = "ui-autocomplete-item ui-autocomplete-row ui-widget-content";
    public static final String TOKEN_DISPLAY_CLASS = "ui-autocomplete-token ui-state-active";
    public static final String TOKEN_LABEL_CLASS = "ui-autocomplete-token-label";
    public static final String TOKEN_LABEL_DISABLED_CLASS = "ui-autocomplete-token-label-disabled";
    public static final String TOKEN_ICON_CLASS = "ui-autocomplete-token-icon ui-icon ui-icon-close";
    public static final String TOKEN_INPUT_CLASS = "ui-autocomplete-input-token";
    public static final String MULTIPLE_CONTAINER_CLASS = "ui-autocomplete-multiple-container ui-widget ui-inputfield ui-state-default";
    public static final String MULTIPLE_CONTAINER_WITH_DROPDOWN_CLASS = "ui-autocomplete-multiple-container ui-autocomplete-dd-multiple-container ui-widget ui-inputfield ui-state-default";
    public static final String ITEMTIP_CONTENT_CLASS = "ui-autocomplete-itemtip-content";
    public static final String MORE_TEXT_LIST_CLASS = "ui-autocomplete-item ui-autocomplete-moretext";
    public static final String MORE_TEXT_TABLE_CLASS = "ui-autocomplete-item ui-autocomplete-moretext ui-widget-content";
    protected static final List<String> UNOBSTRUSIVE_EVENT_NAMES = LangUtils.unmodifiableList("itemSelect", "itemUnselect", "query", "moreTextSelect", "emptyMessageSelect", "clear");
    protected static final Collection<String> EVENT_NAMES = LangUtils.concat(AbstractPrimeHtmlInputText.EVENT_NAMES, UNOBSTRUSIVE_EVENT_NAMES);
    private Object suggestions;
    private Integer suggestionsCount;

    @Override
    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    @Override
    public Collection<String> getUnobstrusiveEventNames() {
        return UNOBSTRUSIVE_EVENT_NAMES;
    }

    public boolean isMoreTextRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_moreText");
    }

    public boolean isDynamicLoadRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_dynamicload");
    }

    public boolean isClientCacheRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_clientCache");
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        Map params = context.getExternalContext().getRequestParameterMap();
        String eventName = (String)params.get("javax.faces.behavior.event");
        if (eventName != null && event instanceof AjaxBehaviorEvent) {
            AjaxBehaviorEvent ajaxBehaviorEvent = (AjaxBehaviorEvent)event;
            if ("itemSelect".equals(eventName)) {
                Object selectedItemValue = ComponentUtils.getConvertedValue(context, (UIComponent)this, params.get(this.getClientId(context) + "_itemSelect"));
                SelectEvent<Object> selectEvent = new SelectEvent<Object>((UIComponent)this, ajaxBehaviorEvent.getBehavior(), selectedItemValue);
                selectEvent.setPhaseId(ajaxBehaviorEvent.getPhaseId());
                super.queueEvent(selectEvent);
            } else if ("itemUnselect".equals(eventName)) {
                Object unselectedItemValue = ComponentUtils.getConvertedValue(context, (UIComponent)this, params.get(this.getClientId(context) + "_itemUnselect"));
                UnselectEvent<Object> unselectEvent = new UnselectEvent<Object>((UIComponent)this, ajaxBehaviorEvent.getBehavior(), unselectedItemValue);
                unselectEvent.setPhaseId(ajaxBehaviorEvent.getPhaseId());
                super.queueEvent(unselectEvent);
            } else if ("moreTextSelect".equals(eventName) || "emptyMessageSelect".equals(eventName) || "clear".equals(eventName)) {
                ajaxBehaviorEvent.setPhaseId(event.getPhaseId());
                super.queueEvent((FacesEvent)ajaxBehaviorEvent);
            } else {
                super.queueEvent(event);
            }
        } else {
            super.queueEvent(event);
        }
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (!(event instanceof AutoCompleteEvent)) {
            return;
        }
        String query = ((AutoCompleteEvent)event).getQuery();
        LazyDataModel lazyModel = this.getLazyModel();
        if (lazyModel != null) {
            String field = this.getLazyField();
            if (LangUtils.isEmpty(field)) {
                throw new FacesException("lazyField is required with lazyModel");
            }
            HashMap<String, FilterMeta> searchFilter = new HashMap<String, FilterMeta>();
            searchFilter.put(field, FilterMeta.builder().field(field).filterValue(query).matchMode(MatchMode.CONTAINS).build());
            HashMap<String, SortMeta> sortBy = new HashMap<String, SortMeta>();
            sortBy.put(field, SortMeta.builder().field(field).order(SortOrder.ASCENDING).build());
            this.suggestions = lazyModel.load(0, this.getMaxResults(), sortBy, searchFilter);
            this.suggestionsCount = lazyModel.count(searchFilter);
        } else {
            FacesContext facesContext = this.getFacesContext();
            MethodExpression me = this.getCompleteMethod();
            if (me != null) {
                this.suggestions = me.invoke(facesContext.getELContext(), new Object[]{query});
                if (this.suggestions == null) {
                    this.suggestions = this.isServerQueryMode() ? Collections.emptyList() : Collections.emptyMap();
                }
                facesContext.renderResponse();
            }
        }
    }

    protected boolean hasMoreSuggestions() {
        int count = this.suggestionsCount != null ? this.suggestionsCount.intValue() : ((List)this.getSuggestions()).size();
        return count > this.getMaxResults();
    }

    public List<Column> getColums() {
        ArrayList<Column> columns = new ArrayList<Column>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            UIComponent child = (UIComponent)this.getChildren().get(i);
            if (!(child instanceof Column)) continue;
            columns.add((Column)child);
        }
        return columns;
    }

    public Object getSuggestions() {
        return this.suggestions;
    }

    public boolean isServerQueryMode() {
        return "server".equals(this.getQueryMode());
    }

    public boolean isClientQueryMode() {
        return "client".equals(this.getQueryMode());
    }

    public boolean isHybridQueryMode() {
        return "hybrid".equals(this.getQueryMode());
    }

    @Override
    public String getInputClientId() {
        return this.getClientId(this.getFacesContext()) + "_input";
    }

    @Override
    public String getValidatableInputClientId() {
        return this.getInputClientId();
    }

    @Override
    public String getLabelledBy() {
        return (String)this.getStateHelper().get((Serializable)((Object)"labelledby"));
    }

    @Override
    public void setLabelledBy(String labelledBy) {
        this.getStateHelper().put((Serializable)((Object)"labelledby"), (Object)labelledBy);
    }

    public Object saveState(FacesContext context) {
        this.suggestions = null;
        this.suggestionsCount = null;
        return super.saveState(context);
    }
}

