/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.breadcrumb;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.api.UIOutcomeTarget;
import org.primefaces.component.breadcrumb.BreadCrumb;
import org.primefaces.component.menu.AbstractMenu;
import org.primefaces.component.menu.BaseMenuRenderer;
import org.primefaces.model.menu.MenuElement;
import org.primefaces.model.menu.MenuItem;
import org.primefaces.model.seo.JsonLDItem;
import org.primefaces.model.seo.JsonLDModel;
import org.primefaces.seo.JsonLD;
import org.primefaces.util.FacetUtils;
import org.primefaces.util.WidgetBuilder;

public class BreadCrumbRenderer
extends BaseMenuRenderer {
    @Override
    protected void encodeMarkup(FacesContext context, AbstractMenu menu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        BreadCrumb breadCrumb = (BreadCrumb)menu;
        String clientId = breadCrumb.getClientId(context);
        String styleClass = this.getStyleClassBuilder(context).add("ui-breadcrumb ui-module ui-widget ui-widget-header ui-helper-clearfix").add(breadCrumb.getStyleClass()).build();
        int elementCount = menu.getElementsCount();
        List<MenuElement> menuElements = menu.getElements();
        boolean isIconHome = breadCrumb.getHomeDisplay().equals("icon");
        boolean isOnlyHomeIcon = isIconHome && elementCount == 1;
        String wrapper = "nav";
        String listType = "ol";
        boolean isSEO = breadCrumb.isSeo();
        ArrayList<JsonLDItem> ldItems = new ArrayList<JsonLDItem>();
        if (isIconHome && elementCount > 0) {
            String icon = breadCrumb.getHomeIcon();
            String iconStyleClass = this.getStyleClassBuilder(context).add("ui-breadcrumb-home-icon").add(icon).add(isOnlyHomeIcon && breadCrumb.isLastItemDisabled(), "ui-state-disabled").build();
            MenuItem home = (MenuItem)menuElements.get(0);
            home.setStyleClass(iconStyleClass);
        }
        writer.startElement(wrapper, null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.writeAttribute("aria-label", (Object)"Breadcrumb", null);
        if (breadCrumb.getStyle() != null) {
            writer.writeAttribute("style", (Object)breadCrumb.getStyle(), null);
        }
        if (elementCount > 0) {
            writer.startElement(listType, null);
            writer.writeAttribute("class", (Object)"ui-breadcrumb-items", null);
            for (int i = 0; i < elementCount; ++i) {
                boolean last;
                MenuElement element = menuElements.get(i);
                if (!element.isRendered() || !(element instanceof MenuItem)) continue;
                MenuItem item = (MenuItem)element;
                if (isSEO) {
                    ldItems.add(new JsonLDItem("ListItem", ldItems.size() + 1, item.getValue(), this.getTargetRequestURL(context, (UIOutcomeTarget)((Object)item))));
                }
                writer.startElement("li", null);
                boolean bl = last = i + 1 == elementCount;
                if (item.isDisabled() || breadCrumb.isLastItemDisabled() && last) {
                    if (isOnlyHomeIcon) {
                        this.encodeMenuItem(context, menu, item, menu.getTabindex(), null);
                    } else {
                        this.encodeDisabledMenuItem(context, item);
                    }
                } else {
                    AbstractMap.SimpleEntry<String, String> attr = null;
                    if (last) {
                        attr = new AbstractMap.SimpleEntry<String, String>("aria-current", "page");
                    }
                    this.encodeMenuItem(context, menu, item, menu.getTabindex(), attr);
                }
                writer.endElement("li");
            }
            UIComponent optionsFacet = menu.getFacet("options");
            if (FacetUtils.shouldRenderFacet(optionsFacet)) {
                writer.startElement("li", null);
                writer.writeAttribute("class", (Object)"ui-breadcrumb-options", null);
                optionsFacet.encodeAll(context);
                writer.endElement("li");
            }
            writer.endElement(listType);
        }
        writer.endElement(wrapper);
        if (isSEO) {
            JsonLDModel ldModel = new JsonLDModel("https://schema.org", "BreadcrumbList", "itemListElement", ldItems);
            JsonLD.encode(context, ldModel, clientId + "_seo");
        }
    }

    @Override
    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    @Override
    public boolean getRendersChildren() {
        return true;
    }

    @Override
    protected void encodeScript(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        BreadCrumb breadcrumb = (BreadCrumb)abstractMenu;
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("BreadCrumb", breadcrumb).attr("seo", breadcrumb.isSeo());
        wb.finish();
    }

    private void encodeDisabledMenuItem(FacesContext context, MenuItem menuItem) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String style = menuItem.getStyle();
        String styleClass = this.getStyleClassBuilder(context).add("ui-menuitem-link").add(menuItem.getStyleClass()).add("ui-state-disabled").build();
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        String icon = menuItem.getIcon();
        Object value = menuItem.getValue();
        if (icon != null) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)("ui-menuitem-icon ui-icon " + icon), null);
            writer.writeAttribute("aria-hidden", (Object)"true", null);
            writer.endElement("span");
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-menuitem-text", null);
        if (value != null) {
            if (menuItem.isEscape()) {
                writer.writeText(value, "value");
            } else {
                writer.write(value.toString());
            }
        }
        writer.endElement("span");
        writer.endElement("span");
    }
}

