/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.button;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.button.Button;
import org.primefaces.renderkit.OutcomeTargetRenderer;
import org.primefaces.util.EscapeUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.SharedStringBuilder;
import org.primefaces.util.WidgetBuilder;

public class ButtonRenderer
extends OutcomeTargetRenderer {
    private static final String SB_BUILD_ONCLICK = ButtonRenderer.class.getName() + "#buildOnclick";

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Button button = (Button)component;
        this.encodeMarkup(context, button);
        this.encodeScript(context, button);
    }

    public void encodeMarkup(FacesContext context, Button button) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = button.getClientId(context);
        Object value = button.getValue();
        String icon = button.getIcon();
        String title = button.getTitle();
        writer.startElement("button", (UIComponent)button);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("name", (Object)clientId, "name");
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("class", (Object)button.resolveStyleClass(), "styleClass");
        this.renderPassThruAttributes(context, (UIComponent)button, HTML.BUTTON_WITHOUT_CLICK_ATTRS);
        if (button.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", "disabled");
        }
        writer.writeAttribute("onclick", (Object)this.buildOnclick(context, button), null);
        if (!this.isValueBlank(icon)) {
            String defaultIconClass = button.getIconPos().equals("left") ? "ui-button-icon-left ui-icon ui-c" : "ui-button-icon-right ui-icon ui-c";
            String iconClass = defaultIconClass + " " + icon;
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)iconClass, null);
            writer.endElement("span");
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text ui-c", null);
        this.renderButtonValue(writer, button.isEscape(), value, title, button.getAriaLabel());
        writer.endElement("span");
        writer.endElement("button");
    }

    public void encodeScript(FacesContext context, Button button) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Button", button);
        wb.finish();
    }

    protected String buildOnclick(FacesContext context, Button button) {
        String onclickBehaviors;
        String userOnclick = button.getOnclick();
        StringBuilder onclick = SharedStringBuilder.get(context, SB_BUILD_ONCLICK);
        String targetURL = this.getTargetURL(context, button);
        if (userOnclick != null) {
            onclick.append(userOnclick).append(";");
        }
        if ((onclickBehaviors = this.getEventBehaviors(context, (ClientBehaviorHolder)button, "click", null)) != null) {
            onclick.append(onclickBehaviors).append(";");
        }
        if (targetURL != null) {
            onclick.append("window.open('").append(EscapeUtils.forJavaScript(targetURL)).append("','");
            onclick.append(EscapeUtils.forJavaScript(button.getTarget())).append("')");
        }
        return onclick.toString();
    }
}

