/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.captcha;

import java.io.Serializable;
import javax.faces.component.UIInput;
import org.primefaces.component.api.Widget;
import org.primefaces.util.ComponentUtils;

public abstract class CaptchaBase
extends UIInput
implements Widget {
    public static final String COMPONENT_FAMILY = "org.primefaces.component";
    public static final String DEFAULT_RENDERER = "org.primefaces.component.CaptchaRenderer";

    public CaptchaBase() {
        this.setRendererType(DEFAULT_RENDERER);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getTheme() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.theme), (Object)"auto");
    }

    public void setTheme(String theme) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.theme), (Object)theme);
    }

    public String getLanguage() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.language), (Object)"en");
    }

    public void setLanguage(String language) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.language), (Object)language);
    }

    public int getTabindex() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.tabindex), (Object)0);
    }

    public void setTabindex(int tabindex) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.tabindex), (Object)tabindex);
    }

    public String getLabel() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.label), null);
    }

    public void setLabel(String label) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.label), (Object)label);
    }

    public String getCallback() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.callback), null);
    }

    public void setCallback(String callback) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.callback), (Object)callback);
    }

    public String getExpired() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.expired), null);
    }

    public void setExpired(String expired) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.expired), (Object)expired);
    }

    public String getSize() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.size), null);
    }

    public void setSize(String size) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.size), (Object)size);
    }

    public String getType() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.type), (Object)"g-recaptcha");
    }

    public void setType(String type) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.type), (Object)type);
    }

    public String getExecutor() {
        return ComponentUtils.eval(this.getStateHelper(), (Serializable)((Object)PropertyKeys.executor), () -> {
            String type;
            switch (type = this.getType()) {
                case "g-recaptcha": {
                    return "grecaptcha";
                }
                case "h-captcha": {
                    return "hcaptcha";
                }
            }
            return null;
        });
    }

    public void setExecutor(String executor) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.executor), (Object)executor);
    }

    public String getSourceUrl() {
        return ComponentUtils.eval(this.getStateHelper(), (Serializable)((Object)PropertyKeys.sourceUrl), () -> {
            String type;
            switch (type = this.getType()) {
                case "g-recaptcha": {
                    return "https://www.google.com/recaptcha/api.js";
                }
                case "h-captcha": {
                    return "https://js.hcaptcha.com/1/api.js";
                }
            }
            return null;
        });
    }

    public void setSourceUrl(String sourceUrl) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.sourceUrl), (Object)sourceUrl);
    }

    public String getVerifyUrl() {
        return ComponentUtils.eval(this.getStateHelper(), (Serializable)((Object)PropertyKeys.verifyUrl), () -> {
            String type;
            switch (type = this.getType()) {
                case "g-recaptcha": {
                    return "https://www.google.com/recaptcha/api/siteverify";
                }
                case "h-captcha": {
                    return "https://api.hcaptcha.com/siteverify";
                }
            }
            return null;
        });
    }

    public void setVerifyUrl(String verifyUrl) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.verifyUrl), (Object)verifyUrl);
    }

    public static enum PropertyKeys {
        type,
        theme,
        language,
        tabindex,
        label,
        callback,
        expired,
        size,
        executor,
        sourceUrl,
        verifyUrl;

    }
}

