/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.clock;

import java.io.IOException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Locale;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.PrimeFaces;
import org.primefaces.component.clock.Clock;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.CalendarUtils;
import org.primefaces.util.LocaleUtils;
import org.primefaces.util.WidgetBuilder;

public class ClockRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        Clock clock = (Clock)component;
        if (clock.isSyncRequest()) {
            PrimeFaces.current().ajax().addCallbackParam("datetime", System.currentTimeMillis());
            context.renderResponse();
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Clock clock = (Clock)component;
        this.encodeMarkup(context, clock);
        this.encodeScript(context, clock);
    }

    protected void encodeMarkup(FacesContext context, Clock clock) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = clock.getClientId(context);
        if (clock.getDisplayMode().equals("analog")) {
            writer.startElement("div", (UIComponent)clock);
            writer.writeAttribute("id", (Object)clientId, null);
            writer.writeAttribute("class", (Object)"ui-analog-clock ui-widget", null);
            writer.endElement("div");
        } else {
            writer.startElement("span", (UIComponent)clock);
            writer.writeAttribute("id", (Object)clientId, null);
            writer.writeAttribute("class", (Object)"ui-clock ui-widget ui-widget-header", null);
            writer.endElement("span");
        }
    }

    protected void encodeScript(FacesContext context, Clock clock) throws IOException {
        String mode = clock.getMode();
        WidgetBuilder wb = this.getWidgetBuilder(context);
        Locale locale = LocaleUtils.getCurrentLocale(context);
        wb.init("Clock", clock);
        wb.attr("mode", mode).attr("pattern", clock.getPattern(), null).attr("displayMode", clock.getDisplayMode()).attr("locale", locale.toString());
        if ("server".equals(mode)) {
            wb.attr("value", this.getValueWithTimeZone(locale, clock));
            if (clock.isAutoSync()) {
                wb.attr("autoSync", true).attr("syncInterval", clock.getSyncInterval());
            }
        }
        wb.finish();
    }

    protected String getValueWithTimeZone(Locale locale, Clock clock) {
        if (locale == null) {
            return "";
        }
        TemporalAccessor time = ZonedDateTime.now();
        Object value = clock.getValue();
        if (value != null) {
            if (value instanceof Date) {
                time = CalendarUtils.convertDate2LocalDateTime((Date)value);
            } else if (value instanceof TemporalAccessor) {
                time = (TemporalAccessor)value;
            }
        }
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss", locale).withZone(CalendarUtils.calculateZoneId(clock.getTimeZone()));
        return dateTimeFormatter.format(time);
    }
}

