/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datascroller;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.PrimeFaces;
import org.primefaces.component.datascroller.DataScroller;
import org.primefaces.model.LazyDataModel;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.FacetUtils;
import org.primefaces.util.WidgetBuilder;

public class DataScrollerRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        DataScroller ds = (DataScroller)component;
        Map params = context.getExternalContext().getRequestParameterMap();
        String clientId = ds.getClientId(context);
        int chunkSize = ds.getChunkSize();
        if (ds.isLoadRequest()) {
            int offset = Integer.parseInt((String)context.getExternalContext().getRequestParameterMap().get(clientId + "_offset"));
            this.loadChunk(context, ds, offset, ds.getChunkSize());
        } else if (ds.isVirtualScrollingRequest(context)) {
            int rowCount;
            int virtualScrollRows;
            int offset = Integer.parseInt((String)params.get(clientId + "_first"));
            int scrollRows = offset + (virtualScrollRows = chunkSize * 2) > (rowCount = ds.getRowCount()) ? rowCount - offset : virtualScrollRows;
            this.loadChunk(context, ds, offset, scrollRows);
        } else {
            if (chunkSize == 0) {
                chunkSize = ds.getRowCount();
            }
            this.encodeMarkup(context, ds, chunkSize);
            this.encodeScript(context, ds, chunkSize);
        }
    }

    protected void encodeMarkup(FacesContext context, DataScroller ds, int chunkSize) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = ds.getClientId(context);
        boolean inline = ds.getMode().equals("inline");
        boolean isLazy = ds.isLazy();
        UIComponent header = ds.getFacet("header");
        UIComponent loader = ds.getFacet("loader");
        UIComponent loading = ds.getFacet("loading");
        String containerClass = inline ? "ui-datascroller ui-datascroller-inline ui-widget" : "ui-datascroller ui-widget";
        String style = ds.getStyle();
        String userStyleClass = ds.getStyleClass();
        String styleClass = userStyleClass == null ? containerClass : containerClass + " " + userStyleClass;
        writer.startElement("div", (UIComponent)ds);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (FacetUtils.shouldRenderFacet(header)) {
            writer.startElement("div", (UIComponent)ds);
            writer.writeAttribute("class", (Object)"ui-datascroller-header ui-widget-header", null);
            header.encodeAll(context);
            writer.endElement("div");
        }
        writer.startElement("div", (UIComponent)ds);
        writer.writeAttribute("class", (Object)"ui-datascroller-content ui-widget-content", null);
        if (inline) {
            writer.writeAttribute("style", (Object)("height:" + ds.getScrollHeight() + "px"), null);
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-datascroller-loading", null);
        if (FacetUtils.shouldRenderFacet(loading)) {
            loading.encodeAll(context);
        } else {
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-datascroller-loading-default", null);
            writer.endElement("div");
        }
        writer.endElement("div");
        int rowCount = ds.getRowCount();
        int start = 0;
        if (inline && ds.isVirtualScroll()) {
            int rowCountToRender;
            int virtualScrollRowCount = chunkSize * 2;
            int n = rowCountToRender = isLazy && rowCount == 0 ? virtualScrollRowCount : Math.min(virtualScrollRowCount, rowCount);
            if (ds.isStartAtBottom()) {
                int totalPage = (int)Math.ceil((double)rowCount * 1.0 / (double)chunkSize);
                start = Math.max((totalPage - 2) * chunkSize, 0);
            }
            this.encodeVirtualScrollList(context, ds, start, rowCountToRender);
        } else {
            if (ds.isStartAtBottom()) {
                start = rowCount > chunkSize ? rowCount - chunkSize : 0;
            }
            this.encodeList(context, ds, start, chunkSize);
            if (ds.isLazy()) {
                rowCount = ds.getRowCount();
            }
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-datascroller-loader", null);
            if (rowCount > chunkSize && FacetUtils.shouldRenderFacet(loader)) {
                loader.encodeAll(context);
            }
            writer.endElement("div");
        }
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void encodeList(FacesContext context, DataScroller ds, int start, int chunkSize) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("ul", (UIComponent)ds);
        writer.writeAttribute("class", (Object)"ui-datascroller-list", null);
        this.loadChunk(context, ds, start, chunkSize);
        ds.setRowIndex(-1);
        writer.endElement("ul");
    }

    protected void encodeVirtualScrollList(FacesContext context, DataScroller ds, int start, int chunkSize) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-datascroller-virtualscroll-wrapper", null);
        this.encodeList(context, ds, start, chunkSize);
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, DataScroller ds, int chunkSize) throws IOException {
        String loadEvent = ds.getFacet("loader") == null ? "scroll" : "manual";
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("DataScroller", ds).attr("chunkSize", chunkSize).attr("totalSize", this.getTotalSize(ds)).attr("loadEvent", loadEvent).attr("mode", ds.getMode(), "document").attr("buffer", ds.getBuffer()).attr("virtualScroll", ds.isVirtualScroll()).attr("startAtBottom", ds.isStartAtBottom());
        this.encodeClientBehaviors(context, ds);
        wb.finish();
    }

    protected int getTotalSize(DataScroller ds) {
        LazyDataModel lazyModel;
        if (ds.isLazy() && (lazyModel = (LazyDataModel)ds.getValue()) != null) {
            return lazyModel.count(Collections.emptyMap());
        }
        return ds.getRowCount();
    }

    protected void loadChunk(FacesContext context, DataScroller ds, int start, int size) throws IOException {
        int _start;
        ResponseWriter writer = context.getResponseWriter();
        boolean isLazy = ds.isLazy();
        int n = _start = start < 0 ? 0 : start;
        if (isLazy) {
            this.loadLazyData(context, ds, _start, size);
        }
        String rowIndexVar = ds.getRowIndexVar();
        Map requestMap = context.getExternalContext().getRequestMap();
        int lastIndex = _start + size;
        lastIndex = start < 0 ? lastIndex + start : lastIndex;
        for (int i = _start; i < lastIndex; ++i) {
            ds.setRowIndex(i);
            if (rowIndexVar != null) {
                requestMap.put(rowIndexVar, i);
            }
            if (!ds.isRowAvailable()) break;
            writer.startElement("li", null);
            writer.writeAttribute("class", (Object)"ui-datascroller-item", null);
            this.renderChildren(context, (UIComponent)ds);
            writer.endElement("li");
        }
        ds.setRowIndex(-1);
        if (rowIndexVar != null) {
            requestMap.remove(rowIndexVar);
        }
    }

    protected void loadLazyData(FacesContext context, DataScroller ds, int start, int size) {
        LazyDataModel lazyModel = (LazyDataModel)ds.getValue();
        if (lazyModel != null) {
            List data = lazyModel.load(start, size, Collections.emptyMap(), Collections.emptyMap());
            lazyModel.setPageSize(size);
            lazyModel.setWrappedData(data);
            if (ComponentUtils.isRequestSource((UIComponent)ds, context) && ds.isVirtualScroll()) {
                PrimeFaces.current().ajax().addCallbackParam("totalSize", lazyModel.getRowCount());
            }
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

