/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable.export;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.faces.context.FacesContext;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.export.ExporterOptions;
import org.primefaces.component.export.TableExporter;
import org.primefaces.model.LazyDataModel;

public abstract class DataTableExporter<P, O extends ExporterOptions>
extends TableExporter<DataTable, P, O> {
    private static final int NO_ROW_INDEX_REQUIRED = Integer.MIN_VALUE;

    protected DataTableExporter(O defaultOptions) {
        super(defaultOptions);
    }

    protected DataTableExporter(O defaultOptions, Set<TableExporter.FacetType> supportedFacetTypes, boolean joinComponents) {
        super(defaultOptions, supportedFacetTypes, joinComponents);
    }

    @Override
    protected void exportSelectionOnly(FacesContext context, DataTable table) {
        Object selection = table.getSelection();
        String var = table.getVar();
        if (selection != null) {
            Map requestMap = context.getExternalContext().getRequestMap();
            if (selection.getClass().isArray()) {
                int size = Array.getLength(selection);
                for (int i = 0; i < size; ++i) {
                    requestMap.put(var, Array.get(selection, i));
                    this.exportRow(context, table, Integer.MIN_VALUE);
                }
            } else if (Collection.class.isAssignableFrom(selection.getClass())) {
                for (Object obj : (Collection)selection) {
                    requestMap.put(var, obj);
                    this.exportRow(context, table, Integer.MIN_VALUE);
                }
            } else {
                requestMap.put(var, selection);
                this.exportRow(context, table, Integer.MIN_VALUE);
            }
        }
    }

    @Override
    protected void exportPageOnly(FacesContext context, DataTable table) {
        int first = table.getFirst();
        int rows = table.getRows();
        if (rows == 0) {
            rows = table.getRowCount();
        }
        int rowsToExport = first + rows;
        for (int rowIndex = first; rowIndex < rowsToExport; ++rowIndex) {
            this.exportRow(context, table, rowIndex);
        }
    }

    @Override
    protected void exportAll(FacesContext context, DataTable table) {
        if (table.isLazy()) {
            LazyDataModel lazyDataModel = (LazyDataModel)table.getValue();
            Integer bufferSize = this.exportConfiguration.getBufferSize();
            boolean bufferized = bufferSize != null;
            int batchSize = Objects.requireNonNullElseGet(bufferSize, () -> lazyDataModel.getRowCount());
            if (batchSize > 0) {
                List items;
                Object wrappedData = lazyDataModel.getWrappedData();
                int pageSize = lazyDataModel.getPageSize();
                lazyDataModel.setPageSize(batchSize);
                int offset = 0;
                do {
                    items = lazyDataModel.load(offset, batchSize, table.getActiveSortMeta(), table.getActiveFilterMeta());
                    lazyDataModel.setWrappedData(items);
                    for (int rowIndex = 0; rowIndex < items.size(); ++rowIndex) {
                        this.exportRow(context, table, rowIndex);
                    }
                } while (bufferized && !items.isEmpty() || !bufferized && (offset += items.size()) < batchSize);
                table.setRowIndex(-1);
                lazyDataModel.setWrappedData(wrappedData);
                lazyDataModel.setPageSize(pageSize);
                lazyDataModel.setRowIndex(-1);
            }
        } else {
            int first = table.getFirst();
            int rowCount = table.getRowCount();
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                this.exportRow(context, table, rowIndex);
            }
            table.setFirst(first);
        }
    }

    protected void exportRow(FacesContext context, DataTable table, int rowIndex) {
        if (rowIndex != Integer.MIN_VALUE) {
            table.setRowIndex(rowIndex);
            if (!table.isRowAvailable()) {
                return;
            }
        }
        this.addCells(context, table);
    }
}

