/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.dnd;

import java.util.Collection;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.BehaviorEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.component.dnd.DroppableBase;
import org.primefaces.event.DragDropEvent;
import org.primefaces.expression.SearchExpressionUtils;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.MapBuilder;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js")})
public class Droppable
extends DroppableBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.Droppable";
    private static final String DEFAULT_EVENT = "drop";
    private static final Map<String, Class<? extends BehaviorEvent>> BEHAVIOR_EVENT_MAPPING = MapBuilder.builder().put("drop", null).build();
    private static final Collection<String> EVENT_NAMES = BEHAVIOR_EVENT_MAPPING.keySet();

    @Override
    public Map<String, Class<? extends BehaviorEvent>> getBehaviorEventMapping() {
        return BEHAVIOR_EVENT_MAPPING;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public String getDefaultEventName() {
        return DEFAULT_EVENT;
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        if (ComponentUtils.isRequestSource((UIComponent)this, context)) {
            Map params = context.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("javax.faces.behavior.event");
            String clientId = this.getClientId(context);
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            if (DEFAULT_EVENT.equals(eventName)) {
                String dragId = (String)params.get(clientId + "_dragId");
                String dropId = (String)params.get(clientId + "_dropId");
                DragDropEvent<Object> dndEvent = null;
                String datasourceId = this.getDatasource();
                if (datasourceId != null) {
                    UIData datasource = this.findDatasource(context, this, datasourceId);
                    String[] idTokens = dragId.split(String.valueOf(UINamingContainer.getSeparatorChar((FacesContext)context)));
                    int rowIndex = Integer.parseInt(idTokens[idTokens.length - 2]);
                    datasource.setRowIndex(rowIndex);
                    Object data = datasource.getRowData();
                    datasource.setRowIndex(-1);
                    dndEvent = new DragDropEvent<Object>((UIComponent)this, behaviorEvent.getBehavior(), dragId, dropId, data);
                } else {
                    dndEvent = new DragDropEvent((UIComponent)this, behaviorEvent.getBehavior(), dragId, dropId);
                }
                super.queueEvent(dndEvent);
            }
        } else {
            super.queueEvent(event);
        }
    }

    protected UIData findDatasource(FacesContext context, Droppable droppable, String datasourceId) {
        return (UIData)SearchExpressionUtils.contextlessResolveComponent(context, (UIComponent)droppable, datasourceId);
    }
}

