/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.export;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.ObjIntConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.el.MethodExpression;
import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIPanel;
import javax.faces.component.UISelectMany;
import javax.faces.component.ValueHolder;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.component.html.HtmlGraphicImage;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import org.primefaces.component.api.ColumnAware;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.api.UITable;
import org.primefaces.component.celleditor.CellEditor;
import org.primefaces.component.columngroup.ColumnGroup;
import org.primefaces.component.export.ColumnValue;
import org.primefaces.component.export.ExportConfiguration;
import org.primefaces.component.export.Exporter;
import org.primefaces.component.export.ExporterOptions;
import org.primefaces.component.overlaypanel.OverlayPanel;
import org.primefaces.component.rowtoggler.RowToggler;
import org.primefaces.model.ColumnMeta;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.EscapeUtils;
import org.primefaces.util.FacetUtils;
import org.primefaces.util.IOUtils;
import org.primefaces.util.LangUtils;

public abstract class TableExporter<T extends UIComponent, D, O extends ExporterOptions>
implements Exporter<T> {
    protected static final Set<FacetType> ALL_FACETS = EnumSet.allOf(FacetType.class);
    private static final Logger LOGGER = Logger.getLogger(TableExporter.class.getName());
    protected D document;
    protected ExportConfiguration exportConfiguration;
    protected final boolean cellJoinComponents;
    private final Map<T, List<UIColumn>> exportableColumnsCache = new HashMap<T, List<UIColumn>>();
    private final O defaultOptions;
    private final Set<FacetType> supportedFacetTypes;

    protected TableExporter(O defaultOptions) {
        this(defaultOptions, ALL_FACETS, true);
    }

    protected TableExporter(O defaultOptions, Set<FacetType> supportedFacetTypes, boolean cellJoinComponents) {
        this.defaultOptions = defaultOptions;
        this.supportedFacetTypes = supportedFacetTypes;
        this.cellJoinComponents = cellJoinComponents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export(FacesContext context, List<T> tables, ExportConfiguration exportConfiguration) throws IOException {
        this.exportConfiguration = exportConfiguration;
        try {
            this.preExport(context);
            ExportVisitCallback exportCallback = new ExportVisitCallback(tables);
            exportCallback.export(context);
            this.postExport(context);
        }
        finally {
            if (this.document instanceof AutoCloseable) {
                IOUtils.closeQuietly((AutoCloseable)this.document, e -> LOGGER.log(Level.SEVERE, e.getMessage(), (Throwable)e));
            }
        }
    }

    protected void exportTable(FacesContext context, T table, int index) throws IOException {
        if (this.exportConfiguration.getOnTableRender() != null) {
            this.exportConfiguration.getOnTableRender().invoke(context.getELContext(), this.getOnTableRenderArgs());
        }
        if (this.exportConfiguration.isExportHeader()) {
            this.addTableFacets(context, table, ColumnType.HEADER);
            boolean headerGroup = this.addColumnGroupFacets(context, table, ColumnType.HEADER);
            if (!headerGroup) {
                this.addColumnFacets(context, table, ColumnType.HEADER);
            }
        }
        if (this.exportConfiguration.isPageOnly()) {
            this.exportPageOnly(context, table);
        } else if (this.exportConfiguration.isSelectionOnly()) {
            this.exportSelectionOnly(context, table);
        } else {
            this.exportAll(context, table);
        }
        if (this.exportConfiguration.isExportFooter()) {
            if (((UITable)table).hasFooterColumn()) {
                this.addColumnFacets(context, table, ColumnType.FOOTER);
            }
            this.addTableFacets(context, table, ColumnType.FOOTER);
        }
    }

    protected void addTableFacets(FacesContext context, T table, ColumnType columnType) {
        if (!this.supportedFacetTypes.contains((Object)FacetType.TABLE)) {
            return;
        }
        String facetText = this.getComponentFacetValue(context, (UIComponent)table, columnType.facet());
        if (LangUtils.isNotBlank(facetText)) {
            this.proxifyWithRowExport(context, table, 0, -1, () -> this.exportTabletFacetValue(context, table, facetText));
        }
    }

    protected void addColumnFacets(FacesContext context, T table, ColumnType columnType) throws IOException {
        if (!this.supportedFacetTypes.contains((Object)FacetType.COLUMN)) {
            return;
        }
        this.addRow(context, table, (col, i) -> {
            ColumnValue columnValue = this.getColumnFacetValue(context, (UIColumn)col, columnType);
            this.exportColumnFacetValue(context, table, columnValue, i);
        });
    }

    protected boolean addColumnGroupFacets(FacesContext context, T table, ColumnType columnType) {
        if (!this.supportedFacetTypes.contains((Object)FacetType.COLUMN_GROUP)) {
            return false;
        }
        ColumnGroup cg = ((ColumnAware)table).getColumnGroup(columnType.facet());
        if (cg == null || cg.getChildCount() == 0) {
            return false;
        }
        int total = this.getExportableColumns(table).size();
        ((ColumnAware)table).forEachColumnGroupRow(context, cg, true, row -> {
            AtomicInteger colIndex = new AtomicInteger(0);
            ((ColumnAware)table).forEachColumn(context, (UIComponent)row, true, true, false, column -> {
                if (column.isExportable()) {
                    ColumnValue columnValue = this.getColumnFacetValue(context, (UIColumn)column, columnType);
                    this.proxifyWithRowExport(context, table, colIndex.get(), total, () -> this.exportColumnGroupFacetValue(context, table, (UIColumn)column, colIndex, columnValue));
                    colIndex.incrementAndGet();
                }
                return true;
            });
            return true;
        });
        return true;
    }

    protected void addCells(FacesContext context, T table) {
        this.addRow(context, table, (col, i) -> this.exportCellValue(context, table, (UIColumn)col, this.getColumnValue(context, (UITable)table, (UIColumn)col, this.cellJoinComponents), i));
    }

    protected void exportTabletFacetValue(FacesContext context, T table, String textValue) {
        if (this.supportedFacetTypes.contains((Object)FacetType.TABLE)) {
            throw new UnsupportedOperationException(this.getClass().getName() + "#exportTabletFacetValue() must be implemented");
        }
    }

    protected void exportColumnFacetValue(FacesContext context, T table, ColumnValue columnValue, int index) {
        if (this.supportedFacetTypes.contains((Object)FacetType.COLUMN)) {
            throw new UnsupportedOperationException(this.getClass().getName() + "#exportColumnFacetValue() must be implemented");
        }
    }

    protected void exportColumnGroupFacetValue(FacesContext context, T table, UIColumn column, AtomicInteger colIndex, ColumnValue columnValue) {
        if (this.supportedFacetTypes.contains((Object)FacetType.COLUMN_GROUP)) {
            throw new UnsupportedOperationException(this.getClass().getName() + "#exportColumnGroupFacetValue() must be implemented");
        }
    }

    protected abstract void exportCellValue(FacesContext var1, T var2, UIColumn var3, ColumnValue var4, int var5);

    protected abstract void exportPageOnly(FacesContext var1, T var2);

    protected abstract void exportAll(FacesContext var1, T var2);

    protected abstract void exportSelectionOnly(FacesContext var1, T var2);

    protected void preExport(FacesContext context) throws IOException {
        this.document = this.createDocument(context);
        if (this.exportConfiguration.getPreProcessor() != null) {
            this.exportConfiguration.getPreProcessor().invoke(context.getELContext(), new Object[]{this.document});
        }
    }

    protected void postExport(FacesContext context) throws IOException {
        if (this.exportConfiguration.getPostProcessor() != null) {
            this.exportConfiguration.getPostProcessor().invoke(context.getELContext(), new Object[]{this.document});
        }
    }

    protected void preRowExport(FacesContext context, T table) {
    }

    protected void postRowExport(FacesContext context, T table) {
        if (this.exportConfiguration.getOnRowExport() != null) {
            this.exportConfiguration.getOnRowExport().invoke(context.getELContext(), new Object[]{this.document});
        }
    }

    protected abstract D createDocument(FacesContext var1) throws IOException;

    private void addRow(FacesContext context, T table, ObjIntConsumer<UIColumn> callback) {
        List<UIColumn> columns = this.getExportableColumns(table);
        for (int i = 0; i < columns.size(); ++i) {
            UIColumn col = columns.get(i);
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyStatelessModel();
            }
            int finalI = i;
            this.proxifyWithRowExport(context, table, i, columns.size(), () -> callback.accept(col, finalI));
        }
    }

    private void proxifyWithRowExport(FacesContext context, T table, int colIndex, int colTotal, Runnable callback) {
        if (colIndex == 0) {
            this.preRowExport(context, table);
        }
        callback.run();
        if (colIndex == colTotal - 1) {
            this.postRowExport(context, table);
        }
    }

    protected List<UIColumn> getExportableColumns(T table) {
        if (this.exportableColumnsCache.containsKey(table)) {
            return this.exportableColumnsCache.get(table);
        }
        int allColumnsSize = ((ColumnAware)table).getColumns().size();
        ArrayList<UIColumn> exportableColumns = new ArrayList<UIColumn>(allColumnsSize);
        boolean visibleColumnsOnly = this.exportConfiguration.isVisibleOnly();
        Map<String, ColumnMeta> allColumnMeta = ((ColumnAware)table).getColumnMeta();
        ArrayList<ColumnMeta> exportableColumnsMetadata = new ArrayList<ColumnMeta>(allColumnsSize);
        ((ColumnAware)table).forEachColumn(true, true, true, column -> {
            if (column.isExportable()) {
                String columnKey = column.getColumnKey();
                ColumnMeta currentMeta = (ColumnMeta)allColumnMeta.get(columnKey);
                if (currentMeta == null) {
                    currentMeta = new ColumnMeta(columnKey);
                    currentMeta.setVisible(true);
                    currentMeta.setDisplayPriority(column.getDisplayPriority());
                }
                if (!visibleColumnsOnly || currentMeta.getVisible().booleanValue()) {
                    exportableColumnsMetadata.add(currentMeta);
                }
            }
            return true;
        });
        Comparator sortIntegersNaturallyWithNullsLast = Comparator.nullsLast(Comparator.naturalOrder());
        exportableColumnsMetadata.sort(Comparator.comparing(ColumnMeta::getDisplayPriority, sortIntegersNaturallyWithNullsLast));
        for (ColumnMeta meta : exportableColumnsMetadata) {
            String metaColumnKey = meta.getColumnKey();
            ((ColumnAware)table).invokeOnColumn(metaColumnKey, -1, exportableColumns::add);
        }
        this.exportableColumnsCache.put(table, exportableColumns);
        return exportableColumns;
    }

    protected O options() {
        ExporterOptions opts = this.exportConfiguration.getOptions();
        if (opts != null) {
            if (this.defaultOptions.getClass().isAssignableFrom(opts.getClass())) {
                return (O)opts;
            }
            throw new IllegalArgumentException("Options must be an instance of " + this.defaultOptions.getClass().getName());
        }
        return this.defaultOptions;
    }

    protected OutputStream os() {
        return this.exportConfiguration.getOutputStream();
    }

    protected Object[] getOnTableRenderArgs() {
        return new Object[]{this.document};
    }

    public String getComponentValue(FacesContext context, UIComponent component) {
        if (component instanceof HtmlCommandLink) {
            HtmlCommandLink link = (HtmlCommandLink)component;
            Object value = link.getValue();
            if (value != null) {
                return String.valueOf(value);
            }
            for (UIComponent child : link.getChildren()) {
                if (!(child instanceof ValueHolder)) continue;
                return this.getComponentValue(context, child);
            }
            return "";
        }
        if (component instanceof ValueHolder) {
            Object submittedValue;
            if (component instanceof EditableValueHolder && (submittedValue = ((EditableValueHolder)component).getSubmittedValue()) != null) {
                return submittedValue.toString();
            }
            ValueHolder valueHolder = (ValueHolder)component;
            Object value = valueHolder.getValue();
            if (value == null) {
                return "";
            }
            Converter converter = valueHolder.getConverter();
            if (converter == null) {
                Class<?> valueType = value.getClass();
                converter = context.getApplication().createConverter(valueType);
            }
            if (converter != null) {
                if (component instanceof UISelectMany) {
                    List<Object> collection = null;
                    if (value instanceof List) {
                        collection = (List<Object>)value;
                    } else if (value.getClass().isArray()) {
                        collection = Arrays.asList(value);
                    } else {
                        throw new FacesException("Value of " + component.getClientId(context) + " must be a List or an Array.");
                    }
                    Converter finalConverter = converter;
                    return collection.stream().map(o -> finalConverter.getAsString(context, component, o)).collect(Collectors.joining(","));
                }
                return converter.getAsString(context, component, value);
            }
            return value.toString();
        }
        if (component instanceof CellEditor) {
            return this.getComponentValue(context, component.getFacet("output"));
        }
        if (component instanceof HtmlGraphicImage) {
            return (String)component.getAttributes().get("alt");
        }
        if (component instanceof OverlayPanel) {
            return "";
        }
        if (component instanceof RowToggler) {
            return "";
        }
        String value = component.toString();
        if (value != null) {
            return value.trim();
        }
        return "";
    }

    public ColumnValue getColumnValue(FacesContext context, UITable table, UIColumn column, boolean joinComponents) {
        if (column.getExportValue() != null) {
            return ColumnValue.of(column.getExportValue());
        }
        if (column.getExportFunction() != null) {
            MethodExpression exportFunction = column.getExportFunction();
            return ColumnValue.of(exportFunction.invoke(context.getELContext(), new Object[]{column}));
        }
        if (LangUtils.isNotBlank(column.getField())) {
            String value = table.getConvertedFieldValue(context, column);
            return ColumnValue.of(value);
        }
        return ColumnValue.of(column.getChildren().stream().filter(UIComponent::isRendered).map(c -> this.getComponentValue(context, (UIComponent)c)).filter(LangUtils::isNotBlank).limit(!joinComponents ? 1L : (long)column.getChildren().size()).collect(Collectors.joining(" ")));
    }

    public String getComponentFacetValue(FacesContext context, UIComponent parent, String facetname) {
        UIComponent facet = parent.getFacet(facetname);
        if (FacetUtils.shouldRenderFacet(facet)) {
            if (facet instanceof UIPanel) {
                for (UIComponent child : facet.getChildren()) {
                    String value;
                    if (!child.isRendered() || (value = ComponentUtils.getValueToRender(context, child)) == null) continue;
                    return value;
                }
            } else {
                return ComponentUtils.getValueToRender(context, facet);
            }
        }
        return null;
    }

    public ColumnValue getColumnFacetValue(FacesContext context, UIColumn column, ColumnType columnType) {
        ColumnValue columnValue = ColumnValue.EMPTY_VALUE;
        if (columnType == ColumnType.HEADER) {
            columnValue = ColumnValue.of(Optional.ofNullable(column.getExportHeaderValue()).orElseGet(column::getHeaderText));
        } else if (columnType == ColumnType.FOOTER) {
            columnValue = ColumnValue.of(Optional.ofNullable(column.getExportFooterValue()).orElseGet(column::getFooterText));
        }
        UIComponent facet = column.getFacet(columnType.facet());
        if (LangUtils.isBlank(columnValue.toString()) && FacetUtils.shouldRenderFacet(facet)) {
            columnValue = ColumnValue.of(this.getComponentValue(context, facet));
        }
        return columnValue;
    }

    public String getColumnExportTag(FacesContext context, UIColumn column) {
        String columnTag = column.getExportTag();
        if (LangUtils.isBlank(columnTag)) {
            columnTag = this.getColumnFacetValue(context, column, ColumnType.HEADER).toString();
        }
        return EscapeUtils.forXmlTag(columnTag.toLowerCase());
    }

    private class ExportVisitCallback
    implements VisitCallback {
        private final List<T> tables;
        private int index;

        public ExportVisitCallback(List<T> tables) {
            this.tables = tables;
            this.index = 0;
        }

        public VisitResult visit(VisitContext context, UIComponent component) {
            try {
                TableExporter.this.exportTable(context.getFacesContext(), component, this.index);
                ++this.index;
            }
            catch (IOException e) {
                throw new FacesException((Throwable)e);
            }
            return VisitResult.ACCEPT;
        }

        public void export(FacesContext context) {
            List tableIds = this.tables.stream().map(dt -> ((UITable)dt).getClientId(context)).collect(Collectors.toList());
            VisitContext visitContext = VisitContext.createVisitContext((FacesContext)context, tableIds, null);
            context.getViewRoot().visitTree(visitContext, (VisitCallback)this);
        }
    }

    protected static enum ColumnType {
        HEADER("header"),
        FOOTER("footer");

        private final String facet;

        private ColumnType(String facet) {
            this.facet = facet;
        }

        public String facet() {
            return this.facet;
        }

        public String toString() {
            return this.facet;
        }
    }

    protected static enum FacetType {
        TABLE,
        COLUMN_GROUP,
        COLUMN;

    }
}

