/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.fileupload;

import java.util.Arrays;
import java.util.Map;
import javax.el.MethodExpression;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.validator.ValidatorException;
import org.primefaces.component.fileupload.FileUploadBase;
import org.primefaces.event.FileUploadEvent;
import org.primefaces.event.FilesUploadEvent;
import org.primefaces.model.file.UploadedFile;
import org.primefaces.model.file.UploadedFiles;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.FileUploadUtils;
import org.primefaces.validate.FileValidator;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="fileupload/fileupload.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js"), @ResourceDependency(library="primefaces", name="fileupload/fileupload.js")})
public class FileUpload
extends FileUploadBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.FileUpload";
    public static final String CONTAINER_CLASS = "ui-fileupload ui-widget ui-fileupload-responsive";
    public static final String DRAG_OVERLAY_CLASS = "ui-fileupload-drag-overlay";
    public static final String DRAG_OVERLAY_CONTENT_CLASS = "ui-fileupload-drag-overlay-content";
    public static final String BUTTON_BAR_CLASS = "ui-fileupload-buttonbar ui-widget-header";
    public static final String CONTENT_CLASS = "ui-fileupload-content ui-widget-content";
    public static final String EMPTY_CLASS = "ui-fileupload-empty";
    public static final String FILES_CLASS = "ui-fileupload-files";
    public static final String CHOOSE_BUTTON_CLASS = "ui-fileupload-choose";
    public static final String UPLOAD_BUTTON_CLASS = "ui-fileupload-upload";
    public static final String CANCEL_BUTTON_CLASS = "ui-fileupload-cancel";
    public static final String BUTTON_ICON_ONLY = "ui-fileupload-icon-only";
    public static final String CONTAINER_CLASS_SIMPLE = "ui-fileupload-simple ui-widget";
    public static final String FILENAME_CLASS = "ui-fileupload-filename";
    public static final String WITHDROPZONE_CLASS = "ui-fileupload-withdropzone";

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        MethodExpression me;
        super.broadcast(event);
        FacesContext facesContext = this.getFacesContext();
        if ((event instanceof FileUploadEvent || event instanceof FilesUploadEvent) && (me = this.getListener()) != null) {
            me.invoke(facesContext.getELContext(), new Object[]{event});
        }
    }

    protected void validateValue(FacesContext context, Object newValue) {
        super.validateValue(context, newValue);
        if (this.isValid()) {
            if (newValue instanceof UploadedFile) {
                this.validateFilename(context, (UploadedFile)newValue);
            } else if (newValue instanceof UploadedFiles) {
                for (UploadedFile uploadedFile : ((UploadedFiles)newValue).getFiles()) {
                    this.validateFilename(context, uploadedFile);
                }
            }
            if (this.isValid() && ComponentUtils.isRequestSource((UIComponent)this, context)) {
                if (newValue instanceof UploadedFile) {
                    int totalFilesCount = 0;
                    if ("advanced".equals(this.getMode())) {
                        Map params = context.getExternalContext().getRequestParameterMap();
                        totalFilesCount = Integer.parseInt((String)params.get(this.getClientId(context) + "_totalFilesCount"));
                    }
                    this.queueEvent(new FileUploadEvent((UIComponent)this, (UploadedFile)newValue, totalFilesCount));
                } else if (newValue instanceof UploadedFiles) {
                    this.queueEvent(new FilesUploadEvent((UIComponent)this, (UploadedFiles)newValue));
                }
            }
        }
    }

    public void validateFilename(FacesContext context, UploadedFile file) {
        try {
            FileUploadUtils.requireValidFilename(context, file.getFileName());
        }
        catch (ValidatorException ve) {
            this.setValid(false);
            context.addMessage(this.getClientId(context), ve.getFacesMessage());
        }
    }

    public FileValidator getFileValidator() {
        return Arrays.stream(this.getValidators()).filter(v -> v instanceof FileValidator).map(v -> (FileValidator)v).findFirst().orElse(null);
    }

    public Long getSizeLimit() {
        FileValidator fileValidator = this.getFileValidator();
        return fileValidator == null ? null : fileValidator.getSizeLimit();
    }
}

