/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.growl;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.growl.Growl;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.renderkit.UINotificationRenderer;
import org.primefaces.util.EscapeUtils;
import org.primefaces.util.WidgetBuilder;

public class GrowlRenderer
extends UINotificationRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Growl growl = (Growl)component;
        String clientId = growl.getClientId(context);
        String widgetVar = growl.resolveWidgetVar(context);
        writer.startElement("span", (UIComponent)growl);
        writer.writeAttribute("id", (Object)clientId, "id");
        if (PrimeApplicationContext.getCurrentInstance(context).getConfig().isClientSideValidationEnabled()) {
            writer.writeAttribute("class", (Object)"ui-growl-pl", null);
            writer.writeAttribute("data-global", (Object)growl.isGlobalOnly(), null);
            writer.writeAttribute("data-summary", (Object)growl.isShowSummary(), null);
            writer.writeAttribute("data-detail", (Object)growl.isShowDetail(), null);
            writer.writeAttribute("data-severity", (Object)this.getClientSideSeverity(growl.getSeverity()), null);
            writer.writeAttribute("data-redisplay", (Object)String.valueOf(growl.isRedisplay()), null);
        }
        writer.endElement("span");
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Growl", growl).attr("sticky", growl.isSticky()).attr("life", growl.getLife()).attr("escape", growl.isEscape()).attr("keepAlive", growl.isKeepAlive());
        writer.write(",msgs:");
        this.encodeMessages(context, growl);
        wb.finish();
    }

    protected void encodeMessages(FacesContext context, Growl growl) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        boolean first = true;
        List<FacesMessage> messages = this.collectFacesMessages(growl, context);
        writer.write("[");
        if (messages != null && !messages.isEmpty()) {
            for (int i = 0; i < messages.size(); ++i) {
                String severityName;
                FacesMessage message = messages.get(i);
                if (!this.shouldRender(growl, message, severityName = this.getSeverityName(message))) continue;
                if (!first) {
                    writer.write(",");
                } else {
                    first = false;
                }
                String summary = EscapeUtils.forJavaScript(message.getSummary());
                String detail = EscapeUtils.forJavaScript(message.getDetail());
                writer.write("{");
                if (growl.isShowSummary() && growl.isShowDetail()) {
                    if (growl.isSkipDetailIfEqualsSummary() && Objects.equals(summary, detail)) {
                        detail = "";
                    }
                    writer.writeText((Object)("summary:\"" + summary + "\",detail:\"" + detail + "\""), null);
                } else if (growl.isShowSummary() && !growl.isShowDetail()) {
                    writer.writeText((Object)("summary:\"" + summary + "\",detail:\"\""), null);
                } else if (!growl.isShowSummary() && growl.isShowDetail()) {
                    writer.writeText((Object)("summary:\"\",detail:\"" + detail + "\""), null);
                }
                writer.write(",severity:'" + severityName + "'");
                writer.write("}");
                message.rendered();
            }
        }
        writer.write("]");
    }
}

