/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.media.player;

import java.util.Map;
import org.primefaces.component.media.player.MediaPlayer;
import org.primefaces.component.media.player.PDFPlayer;
import org.primefaces.component.media.player.QuickTimePlayer;
import org.primefaces.component.media.player.RealPlayer;
import org.primefaces.component.media.player.WindowsPlayer;
import org.primefaces.util.MapBuilder;

public class MediaPlayerFactory {
    private static final Map<String, MediaPlayer> PLAYERS = MapBuilder.builder().put("quicktime", new QuickTimePlayer()).put("windows", (QuickTimePlayer)((Object)new WindowsPlayer())).put("real", (QuickTimePlayer)((Object)new RealPlayer())).put("pdf", (QuickTimePlayer)((Object)new PDFPlayer())).build();

    private MediaPlayerFactory() {
    }

    public static Map<String, MediaPlayer> getPlayers() {
        return PLAYERS;
    }

    public static MediaPlayer getPlayer(String type) {
        if (type == null) {
            throw new IllegalArgumentException("A media player type must be provided");
        }
        MediaPlayer player = PLAYERS.get(type);
        if (player != null) {
            return player;
        }
        throw new IllegalArgumentException(type + " is not a valid media player type");
    }
}

