/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.menu;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.menu.AbstractMenu;
import org.primefaces.component.menu.BaseMenuRenderer;
import org.primefaces.component.menu.Menu;
import org.primefaces.expression.SearchExpressionUtils;
import org.primefaces.model.menu.MenuElement;
import org.primefaces.model.menu.MenuItem;
import org.primefaces.model.menu.Separator;
import org.primefaces.model.menu.Submenu;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;

public class MenuRenderer
extends BaseMenuRenderer {
    @Override
    protected void encodeScript(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        Menu menu = (Menu)abstractMenu;
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("PlainMenu", menu).attr("appendTo", SearchExpressionUtils.resolveOptionalClientIdForClientSide(context, (UIComponent)menu, menu.getAppendTo())).attr("toggleable", menu.isToggleable(), false).attr("tabIndex", menu.getTabindex(), "0").attr("statefulGlobal", menu.isStatefulGlobal(), false);
        if (menu.isOverlay()) {
            this.encodeOverlayConfig(context, menu, wb);
            wb.attr("collision", menu.getCollision());
        }
        wb.finish();
    }

    @Override
    protected void encodeMarkup(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        char lastChar;
        ResponseWriter writer = context.getResponseWriter();
        Menu menu = (Menu)abstractMenu;
        String clientId = menu.getClientId(context);
        boolean isOverlay = menu.isOverlay();
        String maxHeight = menu.getMaxHeight();
        boolean hasMaxHeight = LangUtils.isNotEmpty(maxHeight);
        String styleClass = this.getStyleClassBuilder(context).add(menu.getStyleClass()).add(isOverlay, "ui-menu ui-menu-dynamic ui-widget ui-widget-content ui-helper-clearfix ui-shadow").add(!isOverlay, "ui-menu ui-widget ui-widget-content ui-helper-clearfix").add(menu.isToggleable(), "ui-menu-toggleable").add(hasMaxHeight, "ui-menu-dynamic-maxheight").build();
        Object style = this.getStyleBuilder(context).add(menu.getStyle()).add(hasMaxHeight, "max-height", maxHeight).build();
        if (hasMaxHeight && Character.isDigit(lastChar = maxHeight.charAt(maxHeight.length() - 1))) {
            style = (String)style + "px";
        }
        writer.startElement("div", (UIComponent)menu);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", style, "style");
        }
        writer.writeAttribute("role", (Object)"menu", null);
        if (menu.getElementsCount() > 0) {
            writer.writeAttribute("tabindex", (Object)"-1", "tabindex");
            writer.startElement("ul", null);
            writer.writeAttribute("class", (Object)"ui-menu-list ui-helper-reset", null);
            this.encodeElements(context, menu, menu.getElements(), false, true);
            writer.endElement("ul");
        }
        writer.endElement("div");
    }

    protected void encodeElements(FacesContext context, Menu menu, List<MenuElement> elements, boolean isSubmenu, boolean visible) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        boolean toggleable = menu.isToggleable();
        for (MenuElement element : elements) {
            if (!element.isRendered()) continue;
            if (element instanceof MenuItem) {
                MenuItem menuItem = (MenuItem)element;
                String containerStyle = this.getStyleBuilder(context).add(menuItem.getContainerStyle()).add(!visible, "display", "none").build();
                Object containerStyleClass = this.getStyleClassBuilder(context).add("ui-menuitem ui-widget").add(menuItem.getContainerStyleClass()).build();
                if (toggleable && isSubmenu) {
                    containerStyleClass = (String)containerStyleClass + " ui-submenu-child";
                }
                writer.startElement("li", null);
                writer.writeAttribute("class", containerStyleClass, null);
                writer.writeAttribute("role", (Object)"menuitem", null);
                if (LangUtils.isNotBlank(containerStyle)) {
                    writer.writeAttribute("style", (Object)containerStyle, null);
                }
                this.encodeMenuItem(context, menu, menuItem, "-1");
                writer.endElement("li");
                continue;
            }
            if (element instanceof Submenu) {
                this.encodeSubmenu(context, menu, (Submenu)element);
                continue;
            }
            if (!(element instanceof Separator)) continue;
            this.encodeSeparator(context, (Separator)element);
        }
    }

    protected void encodeSubmenu(FacesContext context, Menu menu, Submenu submenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String label = submenu.getLabel();
        String icon = submenu.getIcon();
        String style = submenu.getStyle();
        Object styleClass = submenu.getStyleClass();
        styleClass = styleClass == null ? "ui-widget-header" : "ui-widget-header " + (String)styleClass;
        boolean toggleable = menu.isToggleable();
        boolean expanded = !toggleable || submenu.isExpanded();
        writer.startElement("li", null);
        if (toggleable) {
            writer.writeAttribute("id", (Object)submenu.getClientId(), null);
        }
        writer.writeAttribute("class", styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        writer.startElement("h3", null);
        if (menu.isToggleable()) {
            this.encodeIcon(context, label, expanded ? "ui-icon ui-icon-triangle-1-s" : "ui-icon ui-icon-triangle-1-e");
        }
        if (icon != null) {
            this.encodeIcon(context, label, "ui-submenu-icon ui-icon " + icon);
        }
        if (label != null) {
            writer.writeText((Object)label, "value");
        }
        writer.endElement("h3");
        writer.endElement("li");
        this.encodeElements(context, menu, submenu.getElements(), true, expanded);
    }

    protected void encodeIcon(FacesContext context, String label, String styleClass) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.endElement("span");
    }
}

