/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.outputlabel;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.PropertyNotFoundException;
import javax.el.ValueExpression;
import javax.faces.component.ContextCallback;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UISelectBoolean;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotNull;
import javax.validation.metadata.ConstraintDescriptor;
import org.primefaces.component.api.InputHolder;
import org.primefaces.component.outputlabel.OutputLabel;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.el.ValueExpressionAnalyzer;
import org.primefaces.expression.SearchExpressionUtils;
import org.primefaces.metadata.BeanValidationMetadataExtractor;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.CompositeUtils;
import org.primefaces.util.EditableValueHolderState;
import org.primefaces.util.HTML;
import org.primefaces.util.StyleClassBuilder;

public class OutputLabelRenderer
extends CoreRenderer {
    private static final Logger LOGGER = Logger.getLogger(OutputLabelRenderer.class.getName());

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        boolean withRequiredIndicator;
        ResponseWriter writer = context.getResponseWriter();
        OutputLabel label = (OutputLabel)component;
        String clientId = label.getClientId(context);
        String value = ComponentUtils.getValueToRender(context, (UIComponent)label);
        StyleClassBuilder styleClassBuilder = this.getStyleClassBuilder(context).add("ui-outputlabel ui-widget").add(ComponentUtils.isRTL(context, label), "ui-outputlabel-rtl").add(label.getStyleClass());
        EditableValueHolderState forState = null;
        String indicateRequired = label.getIndicateRequired();
        boolean isAuto = "auto".equals(indicateRequired) || "autoSkipDisabled".equals(indicateRequired);
        String _for = label.getFor();
        if (!this.isValueBlank(_for)) {
            UIComponent forComponent = SearchExpressionUtils.contextlessResolveComponent(context, (UIComponent)label, _for);
            ContextCallbackFor callback = new ContextCallbackFor(clientId, indicateRequired, isAuto, (UIComponent)label, styleClassBuilder, value);
            forState = callback.getState();
            if (CompositeUtils.isComposite(forComponent)) {
                CompositeUtils.invokeOnDeepestEditableValueHolder(context, forComponent, callback);
            } else {
                callback.invokeContextCallback(context, forComponent);
            }
        }
        boolean bl = withRequiredIndicator = "true".equals(indicateRequired) || isAuto && forState != null && forState.isRequired();
        if (withRequiredIndicator) {
            styleClassBuilder.add("ui-required");
        }
        writer.startElement("label", (UIComponent)label);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClassBuilder.build(), "styleClass");
        this.renderPassThruAttributes(context, (UIComponent)label, HTML.LABEL_ATTRS);
        this.renderDomEvents(context, (UIComponent)label, HTML.LABEL_EVENTS);
        this.renderRTLDirection(context, label);
        if (!this.isValueBlank(_for) && forState != null) {
            writer.writeAttribute("for", (Object)forState.getClientId(), "for");
        }
        if (value != null) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)"ui-outputlabel-label", null);
            if (label.isEscape()) {
                writer.writeText((Object)value, "value");
            } else {
                writer.write(value);
            }
            writer.endElement("span");
        }
        this.renderChildren(context, (UIComponent)label);
        if (withRequiredIndicator) {
            this.encodeRequiredIndicator(writer, label);
        }
        writer.endElement("label");
    }

    protected void encodeRequiredIndicator(ResponseWriter writer, OutputLabel label) throws IOException {
        writer.startElement("span", (UIComponent)label);
        writer.writeAttribute("class", (Object)"ui-outputlabel-rfi", null);
        writer.write("*");
        writer.endElement("span");
    }

    protected boolean isBeanValidationDefined(UIInput input, FacesContext context) {
        try {
            PrimeApplicationContext applicationContext = PrimeApplicationContext.getCurrentInstance(context);
            Set<ConstraintDescriptor<?>> constraints = BeanValidationMetadataExtractor.extractDefaultConstraintDescriptors(context, applicationContext, ValueExpressionAnalyzer.getExpression(context.getELContext(), input.getValueExpression("value")));
            if (constraints == null || constraints.isEmpty()) {
                return false;
            }
            for (ConstraintDescriptor<?> constraintDescriptor : constraints) {
                Class<? extends Annotation> annotationType = constraintDescriptor.getAnnotation().annotationType();
                if (annotationType.equals(NotNull.class) && applicationContext.getConfig().isInterpretEmptyStringAsNull()) {
                    return true;
                }
                String annotationClassName = annotationType.getSimpleName();
                if ("NotBlank".equals(annotationClassName) || "NotEmpty".equals(annotationClassName)) {
                    return true;
                }
                if (!(input instanceof UISelectBoolean) || !annotationType.equals(AssertTrue.class)) continue;
                return true;
            }
        }
        catch (PropertyNotFoundException e) {
            String message = "Skip evaluating [@NotNull,@NotBlank,@NotEmpty,@AssertTrue] for outputLabel and referenced component \"" + input.getClientId(context) + "\" because the ValueExpression of the \"value\" attribute isn't resolvable completely (e.g. a sub-expression returns null)";
            LOGGER.log(Level.FINE, message);
        }
        return false;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    private class ContextCallbackFor
    implements ContextCallback {
        private final EditableValueHolderState state = new EditableValueHolderState();
        private final UIComponent label;
        private final String indicateRequired;
        private final String clientId;
        private final String value;
        private final StyleClassBuilder styleClassBuilder;
        private final boolean isAuto;

        public ContextCallbackFor(String clientId, String indicateRequired, boolean isAuto, UIComponent label, StyleClassBuilder styleClassBuilder, String value) {
            this.clientId = clientId;
            this.indicateRequired = indicateRequired;
            this.isAuto = isAuto;
            this.label = label;
            this.styleClassBuilder = styleClassBuilder;
            this.value = value;
        }

        public void invokeContextCallback(FacesContext context, UIComponent target) {
            if (target instanceof InputHolder) {
                InputHolder inputHolder = (InputHolder)target;
                this.state.setClientId(inputHolder.getInputClientId());
                inputHolder.setLabelledBy(this.clientId);
            } else {
                this.state.setClientId(target.getClientId(context));
            }
            if (target instanceof UIInput) {
                UIInput input = (UIInput)target;
                if (this.value != null && (input.getAttributes().get("label") == null || input.getValueExpression("label") == null)) {
                    ValueExpression ve = this.label.getValueExpression("value");
                    if (ve != null) {
                        input.setValueExpression("label", ve);
                    } else {
                        String labelString = this.value;
                        char separatorChar = UINamingContainer.getSeparatorChar((FacesContext)context);
                        int separatorCharPos = labelString.lastIndexOf(separatorChar);
                        if (separatorCharPos != -1) {
                            labelString = labelString.substring(0, separatorCharPos);
                        }
                        input.getAttributes().put("label", labelString);
                    }
                }
                if (!input.isValid()) {
                    this.styleClassBuilder.add("ui-state-error");
                }
                if (this.isAuto) {
                    boolean disabled = false;
                    if ("autoSkipDisabled".equals(this.indicateRequired)) {
                        disabled = ComponentUtils.isDisabledOrReadonly(input);
                    }
                    if (disabled) {
                        this.state.setRequired(false);
                    } else {
                        PrimeApplicationContext applicationContext;
                        this.state.setRequired(input.isRequired());
                        if (!this.state.isRequired() && (applicationContext = PrimeApplicationContext.getCurrentInstance(context)).getConfig().isBeanValidationEnabled() && OutputLabelRenderer.this.isBeanValidationDefined(input, context)) {
                            this.state.setRequired(true);
                        }
                    }
                }
            }
        }

        public EditableValueHolderState getState() {
            return this.state;
        }
    }
}

